<?php
/**
 * @author Rayanik.com
 */
if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Cards extends Frontend_Controller {

    function __construct() {
        parent::__construct(); 
    }

    public function index($offset = null, $tracking_code = null) {
        if (!$this->user_login) {
            if($tracking_code){
                $this->session->set_userdata('last_page', base_url("buy/$tracking_code"));
            } else {
                $this->session->set_userdata('last_page', base_url("cards"));
            }
            redirect('login');
        }

        if($this->checkActiveAuthCall() && !$this->user_login->auth_call){
            redirect('auth-call');
        }

        //css
        $css = array();
        array_push($css, 'assets/plugins/noty/css/flat.css');
        $this->data['css'] = $css;

        //js
        $js = array();
        array_push($js, 'assets/plugins/noty/js/noty/packaged/jquery.noty.packaged.min.js');
        $this->data['js'] = $js;
        
        $this->load->model('cards_m');
        //تعداد کل کارت های این کاربر
        $count_order = $this->cards_m->getUserCards($this->user_login->id, $tracking_code, null, null, true);


        //========================BEGIN pagination ========================
        $this->load->library('pagination');

        $config['base_url'] = base_url('/cards');

        $config['total_rows'] = $count_order;

        // The number of items you intend to show per page
        $config['per_page'] = ($tracking_code) ? 1000 : '5';

        //The number of "digit" links you would like before and after the selected page number
        $config['num_links'] = '5';


        $config['full_tag_open'] = '<ul class="pagination pagination-info">';
        $config['full_tag_close'] = '</ul>';

        $config['first_link'] = 'ابتدا';
        $config['first_tag_open'] = '<li>';
        $config['first_tag_close'] = '</li>';


        $config['last_link'] = 'انتها';
        $config['last_tag_open'] = '<li>';
        $config['last_tag_close'] = '</li>';

        $config['next_link'] = '<i class="fa fa-angle-left"></i>';
        $config['next_tag_open'] = '<li>';
        $config['next_tag_close'] = '</li>';

        $config['prev_link'] = '<i class="fa fa-angle-right"></i>';
        $config['prev_tag_open'] = '<li>';
        $config['prev_tag_close'] = '</li>';

        $config['cur_tag_open'] = '<li class="active"><a>';
        $config['cur_tag_close'] = '</a></li>';

        $config['num_tag_open'] = '<li>';
        $config['num_tag_close'] = '</li>';

        $this->pagination->initialize($config);
        //========================END pagination ========================
        //به دست آوردن تراکنش ها
        $offset = (int) $offset; //$this->uri->segment(2);
        $limit = $config['per_page'];
        $cards = $this->cards_m->getUserCards($this->user_login->id, $tracking_code, $offset, $limit, false);
        $this->data['cards'] = $cards;
        $this->data['tracking_code'] = $tracking_code;

        // Canonical
        $this->data['canonical'] = ($tracking_code) ? base_url("buy/$tracking_code") : base_url("cards");

        $this->data['content'] = 'card/index';
        $this->load->view('_layout_main', $this->data);
    }

    public function download($id = null){
        if (!$this->user_login) {
            redirect('login');
        }

        if($this->checkActiveAuthCall() && !$this->user_login->auth_call){
            redirect('auth-call');
        }

        $this->load->model('cards_m');
        $id = intval($id);
        $card = $this->cards_m->getDetailCard($id);
        if(!$card){
            redirect('cards');
        }
        
        if(
            $card->user_id != $this->user_login->id ||
            $card->pending ||
            empty($card->file) ||
            !file_exists($card->file)
        ){
            redirect('cards');
        }

        $this->load->helper('download');
        force_download($card->file, null);
    }

}
?>
