<?php
/**
* @author Rayanik.com
*/
if (!defined('BASEPATH'))
exit('No direct script access allowed');

class Establish extends CI_Controller {

	public function __construct(){
		parent::__construct();

		$this->load->helper('url');

		// Check not insttal
		$file = ROOTPATH .DS. 'install.txt';
		if(file_exists($file) && filesize($file) != 0){
            redirect('home');
        }
		//$this->config->set_item('sess_use_database', false);
		//$this->config->set_item('subclass_prefix', 'INSTALL_');
	}

	// Check server
	public function index()
	{
		$this->data['content'] = 'install/start';
		$this->load->view('_layout_install', $this->data);
	}

	// Add info
	public function info()
	{

		include_once (ROOTPATH .DS. 'application' .DS. 'config' .DS. 'database.php');

		if ($db['default']['hostname'] != '%HOSTNAME%'){
			$this->data['hostname']	= $db['default']['hostname'];
		}

		if ($db['default']['username'] != '%USERNAME%'){
			$this->data['username']	= $db['default']['username'];
		}

		if ($db['default']['password'] != '%PASSWORD%'){
			$this->data['password']	= $db['default']['password'];
		}

		if ($db['default']['database'] != '%DATABASE%'){
			$this->data['database']	= $db['default']['database'];
		}

		$this->data['content'] = 'install/info';
		$this->load->view('_layout_install', $this->data);
	}

	public function setup()
	{
		$this->load->helper('genaral_helper');
		$this->load->helper('file');

		$hostname = trim($this->input->post('hostname'));
		$username = trim($this->input->post('username'));
		$password = trim($this->input->post('password'));
		$database = trim($this->input->post('database'));

		$this->data['hostname'] = $hostname;
		$this->data['username'] = $username;
		$this->data['password'] = $password;
		$this->data['database'] = $database;

		// Save encrypt config
		$config 	= ROOTPATH .DS. 'application' .DS. 'config' .DS. 'encrypt_config_install.php';
		$file 		= ROOTPATH .DS. 'application' .DS. 'config' .DS. 'encrypt_config.php';
		$content 	= read_file($config);

		$encryption_key = random_str(10);
		$crypt_key = random_str(32);

		$patterns		= array('/%ENCRYPTION_KEY%/', '/%CRYPT_KEY%/');
		$replacements 	= array($encryption_key, $crypt_key);

		$content 		= preg_replace($patterns, $replacements, $content);

		if ( ! write_file($file, $content)){
			$data['error'] = 'نوشتن در فایل encrypt_config.php امکان پذیر نیست. لطفا دوباره تلاش کنید.';
			$this->data['content'] = 'install/info';
			$this->load->view('_layout_install', $this->data);
			return;
		}

		// Database information
		if ($hostname && $username && $database){
            $check = true;
            try {
                $mysqli = new mysqli($hostname, $username, $password);
                if ($mysqli->connect_errno) {
                    $check = false;
                }

                $select_db = $mysqli->select_db($database);
                if(!$select_db){
                    $check = false;
                }

                if (!$mysqli->set_charset("utf8")) {
                    $check = false;
                }
            } catch (\Throwable $th) {
                $check = false;
            }

			if ($check === false)
			{
				$this->data['error'] = 'نمی توان به بانک اطلاعاتی متصل شد. لطفا اطلاعات خود را بررسی کنید!';

				$this->data['content'] = 'install/info';
				$this->load->view('_layout_install', $this->data);
				return;
			}

			// Save database config
			$config 	= ROOTPATH .DS. 'application' .DS. 'config' .DS. 'database_install.php';
			$file 		= ROOTPATH .DS. 'application' .DS. 'config' .DS. 'database.php';
			$content 	= read_file($config);

			$patterns		= array('/%HOSTNAME%/', '/%USERNAME%/', '/%PASSWORD%/', '/%DATABASE%/');
			$replacements 	= array($hostname, $username, $password, $database);

			$content 		= preg_replace($patterns, $replacements, $content);

			if ( ! write_file($file, $content))
			{
				$data['error'] = 'نوشتن در فایل database.php امکان پذیر نیست. لطفا دوباره تلاش کنید.';
				$this->data['content'] = 'install/info';
				$this->load->view('_layout_install', $this->data);
				return;
			}

			// Add tables
			$sql 		= ROOTPATH .DS. 'sql' .DS. 'tables.sql';
			$content 	= file_get_contents($sql);

			$tables 	= explode(';', $content);
			foreach($tables as $table)
			{
				if ($table == '' || strlen($table) < 10) continue;

				$result = $mysqli->query($table);

				if (!$result)
				{
					$this->data['error'] = $mysqli->error;
					$this->data['content'] = 'install/info';
					$this->load->view('_layout_install', $this->data);
					return;
				}
			}


			// Add views
			$sql 		= ROOTPATH .DS. 'sql' .DS. 'views.sql';
			$content 	= file_get_contents($sql);

			$tables 	= explode(';', $content);
			foreach($tables as $table)
			{
				if ($table == '' || strlen($table) < 10) continue;

				$result = $mysqli->query($table);

				if (!$result)
				{
					$this->data['error'] = $mysqli->error;
					$this->data['content'] = 'install/info';
					$this->load->view('_layout_install', $this->data);
					return;
				}
			}

			// Insert data
			$sql 		= ROOTPATH .DS. 'sql' .DS. 'data.sql';
			$content 	= file_get_contents($sql);
			$values 	= explode('INSERT INTO', $content);
			foreach($values as $value)
			{
				if ($value != '' && strlen($value) >10 )
				{
					$result = $mysqli->query('INSERT INTO' . $value);
				}
			}

            // Use migration from 20240709131600 
            $this->load->library('migration');
            if ($this->migration->latest() === FALSE) {
                show_error($this->migration->error_string());
            } else {
                $this->settings_m->save(['value' => '5.5.0'], 'version');
            }

			redirect('establish/config');
		}
		else
		{
			redirect('establish/info');
		}
	}

	public function config()
	{

		$submit = $this->input->post('submit');
		$this->data['posted'] = $this->input->post();
		if($submit){

			// Add user admin
			$this->load->library('form_validation');
			// $this->form_validation->set_rules('username', 'نام کاربری', 'trim|required|min_length[2]|is_unique[users.username]');
			$this->form_validation->set_rules('username', 'نام کاربری', 'trim|required|min_length[2]|regex_match[/^[a-zA-Z0-9]+$/]');
			$this->form_validation->set_rules('password', 'رمز عبور ادمین', 'required|min_length[6]');
			$this->form_validation->set_rules('password_cards', 'رمز عبور کارت ها', 'required|min_length[6]');
			$this->form_validation->set_rules('site_name', 'نام سایت', 'trim|required');

			$this->form_validation->set_message('required', 'وارد کردن فیلد %s الزامی است.');
			$this->form_validation->set_message('regex_match', 'برای %s فقط می توانید از حروف انگلیسی و اعداد استفاده کنید.');
			$this->form_validation->set_message('valid_email', 'لطفا %s را صحیح وارد کنید.');
			$this->form_validation->set_message('is_unique', 'لطفا %s دیگری را وارد کنید.');
			$this->form_validation->set_message('min_length', '%s حداقل باید %s کارکتر باشد.');



			if($this->form_validation->run() == TRUE)
			{

				$this->load->database();
				$this->load->model('settings_m');
				$this->load->model('users_m');
				$this->load->helper('file');

				// Save settings
				$site_name = $this->security->xss_clean($this->input->post('site_name'));
				$data = array('value' => $site_name);
				$this->settings_m->save($data, 'site_name');

				$data = array('value' => $site_name);
				$this->settings_m->save($data, 'meta_title');

				$password_cards = $this->input->post('password_cards');
				$data = array('value' => $this->users_m->hash($password_cards));
				$this->settings_m->save($data, 'password_cards');

				// Save user admin
				$username = $this->security->xss_clean($this->input->post('username'));
				$password = $this->input->post('password');
				$data 	= array(
					'username' => $username,
					'type' => 'admin',
					'kind' => $this->users_m->hash('admin' . $username),
					'activation' => 1,
					'role_id' => 1,
					'password' => $this->users_m->hash($password . $username),
				);

				if($user_id = $this->users_m->save($data))
				{
					// Done
					$this->data['warning'] = '';
					$file = ROOTPATH .DS. 'install.txt';
					if ( ! write_file($file, 'done')){
						$this->data['warning'] .= '<p>نوشتن در فایلinstall.txt امکان پذیر نیست. نصب با موفقیت انجام شده است ولی برای دسترسی کلمه done را در فایل install.txt قرار دهید.</p> ';
					}

					// Remove sql
					$path_sql = ROOTPATH .DS. 'sql';
					delete_files($path_sql, true);
			        $path_sql = ROOTPATH .DS. 'sql' .DS;
			        $files = glob( $path_sql ."*" );
					$file_count  = ($files) ? count($files) : 0;
					if ($file_count){
						$this->data['warning'] .= '<p>پوشه sql و فایل های درونش را برای امنیت سایتتان پاک کنید.</p> ';
					}

					if($this->data['warning'] == ''){
						unset($this->data['warning']);
					}

                    // Install
                    $this->load->library('update_lib');
                    $this->update_lib->send((object)[
                        'from' => '',
                        'to' => $this->settings_m->getSingle('version'),
                        'action' => 'install',
                    ]);

					$this->data['content'] = 'install/finish';
					$this->load->view('_layout_install', $this->data);
					return true;
				}else
				{
					$this->data['error'] = 'سیستم نمی تواند مدیر اضافه کند. لطفا دوباره تلاش کنید.';
				}

			}else
			{
				$this->data['error'] = validation_errors();
			}
		}

		$this->data['content'] = 'install/config';
		$this->load->view('_layout_install', $this->data);
	}

}

?>
