<?php

/**
 * @author Rayanik.com
 */
if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Pages extends Frontend_Controller {

    function __construct() {
        parent::__construct();
    }

    public function detail($id = null) {
        $id = intval($id);

        $this->load->model('pages_m');
        $page = $this->pages_m->get_by("id, slug, title, content, meta_title, meta_description, meta_keywords", array('publish' => '1', 'id' => $id), true);

        if (!$page) {
            redirect('errors/404');
        }

        // Sliders
        $this->load->model('sliders_m');
        $this->data['sliders'] = $this->sliders_m->getForShow($this->is_mobile, 'page', $page->id);

        //meta
        if ($page->meta_title != '') {
            $this->data['meta_title'] = $page->meta_title;
        } else {
            $this->data['meta_title'] = $page->title;
        }
        if ($page->meta_description != '')
            $this->data['meta_description'] = $page->meta_description;
        if ($page->meta_keywords != '')
            $this->data['meta_keywords'] = $page->meta_keywords;

        // Canonical
        $this->data['canonical'] = base_url("page/$page->id-$page->slug");

        $this->data['page'] = $page;
        $this->data['content'] = 'page';
        $this->load->view('_layout_main', $this->data);
    }

    public function contact() {
        $this->load->model('contacts_m');

        $this->load->model('categories_m');
        $subjects = $this->categories_m->get_by("id, title_fa AS title", array('type' => 'contact', 'publish' => '1', 'deleted' => 0));
        $this->data['subjects'] = $subjects;


        $submit = $this->input->post('submit');
        if ($submit) {
            $captcha = $this->session->userdata('captcha');

            $this->form_validation->set_rules('email', 'ایمیل', 'trim|valid_email|required');
            $this->form_validation->set_rules('cell_phone', 'شماره همراه', 'trim|callback_is_cellphone');
            $this->form_validation->set_rules('subject', 'بخش', 'trim|required|numeric');
            $this->form_validation->set_rules('text', 'متن پیام', 'trim|required');
            $this->form_validation->set_rules('captcha', 'کد امنیتی', "required|callback_is_equal[$captcha]");

            $this->form_validation->set_message('required', '%s الزامی است.');
            $this->form_validation->set_message('numeric', 'لطفا %s را انتخاب کنید.');
            $this->form_validation->set_message('regex_match', ' %s را صحیح وارد کنید.');
            $this->form_validation->set_message('is_cellphone', ' %s را صحیح وارد کنید.');
            $this->form_validation->set_message('valid_email', ' %s را صحیح وارد کنید');
            $this->form_validation->set_message('is_equal', 'لطفا %s را صحیح وارد کنید');

            if ($this->form_validation->run() != FALSE) {

                //چک میکنیم که موضوع را درست انتخاب کرده باشد
                $subject_id = intval($this->input->post('subject'));
                $subject_valid = false;
                $subject_title = '';
                if ($subject_id != 0) {
                    if ($subjects) {
                        foreach ($subjects as $subject) {
                            if ($subject->id == $subject_id) {
                                $subject_title = $subject->title;
                                $subject_valid = true;
                                break;
                            }
                        }
                    }
                }
                //اگر موضوع درست انتخاب شده بود
                if ($subject_valid) {
                    //گرفت کد کاربر در صورت لاگین بودن
                    $this->load->library('pdate');
                    $jalali_date = $this->pdate->date('Y/m/d H:i:s');

                    $data = array();
                    $data['category_id'] = $subject_id;
                    $data['subject'] = $subject_title;
                    $data['email'] = $this->security->xss_clean($this->input->post('email'));
                    $data['name'] = $this->security->xss_clean($this->input->post('name'));
                    $data['cell_phone'] = $this->input->post('cell_phone');
                    $data['text'] = $this->security->xss_clean($this->input->post('text'));
                    $data['is_read'] = '0';
                    $data['jalali_created'] = $jalali_date;
                    $data['ip'] = $this->input->ip_address();


                    if ($id = $this->contacts_m->save($data)) {

                        // Send email to admin...
                        $to = $this->settings->admin_email;
                        if($to){
                            $contact = $this->contacts_m->get($id, true);
                            $this->data['contact'] = $contact;
                            $email_body = $this->load->view('email/contact_us', $this->data, TRUE);
                            $this->load->library('frontend_general');
                            $this->frontend_general->sendEmail($to, $email_body, null, $contact->subject, $this->settings->site_name, $this->settings->site_name_en, $this->settings->logo);
                        }

                        $this->data['message_success'] = '<p>با موفقیت ثبت گردید.</p>';
                        $this->data['message_send'] = TRUE;
                    } else {
                        $this->data['message_danger'] = 'خطای سیستمی';
                    }
                } else {
                    //موضوع انتخاب شده وجود ندارد
                    $this->data['message_danger'] = '<p>بخش مرتبط را مشخص نماپید</p>';
                }
            } else {
                $this->data['message_danger'] = validation_errors();
            }
        }

        $this->data['captcha_image'] = $this->frontend_general->create_captcha();

        // Sliders
        $this->load->model('sliders_m');
        $this->data['sliders'] = $this->sliders_m->getForShow($this->is_mobile, 'contact_us');

        //meta
        $this->data['meta_title'] = 'تماس با ما';
        $this->data['meta_description'] = 'تماس با ما';
        $this->data['meta_keyword'] = 'تماس با ما';

        // Canonical
        $this->data['canonical'] = base_url("contact-us");
        

        $this->data['content'] = 'contact';
        $this->load->view('_layout_main', $this->data);
    }

    //for captcha validation
    function is_equal($str, $value) {
        return (strtoupper($str) === strtoupper($value));
    }

    //for cell phone validation
    function is_cellphone($str) {
        if ($str == '') {
            return true;
        } else {
            if (preg_match('/^09\d{9}$/', $str) || preg_match('/^9\d{9}$/', $str) || preg_match('/^(\+\d{1,3}[- ]?)?\d{10}$/', $str)) {
                return TRUE;
            }
            return FALSE;
        }
    }

    //reload captcha ajax
    function create_captcha() {
        $captcha_image = $this->frontend_general->create_captcha();
        echo $captcha_image;
    }

}

?>
