<?php

/**
 * @author Rayanik.com
 */
if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Pay extends Frontend_Controller
{

    public $category_fileds = null;

    function __construct()
    {
        parent::__construct();

        $this->load->model('orders_m');
        $this->load->model('transactions_m');
        $this->load->model('gateways_m');
        $this->load->library('pdate');
    }

    // شارژ کیف پول
    public function charge(){
        if (!$this->user_login) {
            $this->session->set_userdata('last_page', base_url("charge"));
            redirect('login');
        }

        // چک می‌کنیم که کاربر مجاز به پرداخت می‌باشد
        $access_buy = accessToBuy($this->user_login, $this->settings);
        if($access_buy->condition == false){
            $this->session->set_userdata('last_page', base_url("charge"));
            redirect($access_buy->redirect);
        }

        // Active charge page
        $this->data['active_charge_page'] = $this->settings_m->getSingle('active_charge_page');

        // Packages
        $packages = $this->settings_m->getSingle('charge_packages');
        $this->data['packages'] = ($packages) ? json_decode($packages) : [];

        // CSS & JS
        $this->data['css'] = [];
        $this->data['js'] = [];

        $this->gateways('charge');

        $this->data['settings']->show_gift_box = (in_array($this->settings->show_gift_box, ['charge', 'both'])) ? true : false;

        // Canonical
        $this->data['canonical'] = base_url("charge");

        $this->data['content'] = 'pay/charge';
        $this->load->view('_layout_main', $this->data);
    }

    public function request($order_id = 0, $gateway = '')
    {
        
        $is_charge = ($order_id) ? false : true;

        // چک می‌کنیم که کاربر مجاز به پرداخت می‌باشد
        $access_buy = accessToBuy($this->user_login, $this->settings);
        if($access_buy->condition == false){
            redirect($access_buy->redirect);
        }

        // Charge
        if($is_charge){
            if(!$this->user_login){
                redirect('home');
            }

            $user_id = $this->user_login->id;

            // Active charge page
            $active_charge_page = $this->settings_m->getSingle('active_charge_page');
            if(!$active_charge_page){
                redirect('charge');
            }

            // چک می کنیم بیش از حد مجاز تراکنش ثبت نکند
            $number_try = $this->transactions_m->get_by('COUNT(id) AS number', [
                'user_id' => $this->user_login->id,
                'created >' => date('Y-m-d H:i:s', strtotime("-10 minutes")),
            ], true)->number * 1;

            if($number_try >= 5){
                $this->session->set_flashdata('frontend_error', 'چند دقیقه دیگر تلاش کنید.');
                redirect('charge');
            }

            $_POST['price'] = str_replace(',', '', $this->input->post('price'));
            $gateway = $this->input->post('gateway');

            $this->form_validation->set_rules('price', 'مبلغ', "trim|required|numeric|greater_than_equal_to[1000]");

            // کاربر باید با کارت بانکی خودش پرداخت انجام دهد
            if($gateway != 'card2card' && in_array('bank_card', $this->settings->verify_when_buy)){
                $this->form_validation->set_rules('card_number', 'شماره کارت', "trim|required|regex_match[/^\d{16}$/]");
            }

            // برای کارت به کارت
            if($gateway == 'card2card'){
                $_POST['transfer']['date'] = englishNumber($this->input->post('transfer[date]'));
                $_POST['transfer']['reference'] = englishNumber($this->input->post('transfer[reference]'));
                $this->form_validation->set_rules('transfer[reference]', 'شماره پیگیری تراکنش', "trim|required|min_length[5]|regex_match[/^[a-zA-Z0-9]+$/]");
                $this->form_validation->set_rules('transfer[card]', 'شماره کارت', "trim|required|regex_match[/^\d{16}$/]");
                $this->form_validation->set_rules('transfer[date]', 'تاریخ واریز', array('trim', 'required', 'regex_match[/^1(3|4)(\d{2})\/(0?[1-9]|1[012])\/(0?[1-9]|[12][0-9]|3[01])$/]'));
                $this->form_validation->set_rules('transfer[clock]', 'ساعت واریز', array('trim', 'required', 'regex_match[/^([01]?\d|2[0-3]):([0-5]?\d)$/]'));
            }

            $this->form_validation->set_message('required', 'وارد کردن %s اجباری است.');
            $this->form_validation->set_message('greater_than_equal_to', 'حداقل %s بایستی %s تومان باشد.');
            $this->form_validation->set_message('regex_match', '%s صحیح نیست.');
            $this->form_validation->set_message('numeric', '%s صحیح نیست.');

            if ($this->form_validation->run()) {
                $order_id = 0;
                $amount = $this->input->post('price');

                // چک کردن صحت درگاه
                $gateway_row = $this->gateways_m->get_by(null, [
                    'publish' => 1, 
                    'deleted' => 0, 
                    'title_en' => $gateway
                ], true);
                if (!$gateway_row) {
                    $this->session->set_flashdata('frontend_error', 'درگاه انتخاب شده مجاز نیست. یک درگاه دیگر انتخاب کنید.');
                    redirect('charge');
                }

                if($gateway != 'card2card' && in_array('bank_card', $this->settings->verify_when_buy)){
                    // کاربر باید با کارت بانکی خودش پرداخت انجام دهد
                    $card_number = $this->input->post('card_number');

                    $this->load->model('bank_cards_m');
                    $bank_card = $this->bank_cards_m->get_by('id, card_number', [
                        'user_id' => $this->user_login->id,
                        'card_number' => $card_number,
                        'deleted' => 0
                    ], true);

                    if(!$bank_card){
                        $message = 'شماره کارت بانکی صحیح نبود.';
                        $this->session->set_flashdata('frontend_error', $message);
                        redirect('charge');
                    }
                }
    
                if($gateway == 'card2card'){
                    // ثبت تراکنش برای کارت به کارت
                    // Transfer image
                    $transfer_image = '';
                    $image_result = $this->uploadImageTransaction('image');
                    if ($image_result->condition) {
                        $transfer_image = $image_result->file_path;
                    } else {
                        // $image_error = $image_result->error
                    }

                    // Transfer time
                    [$year, $month, $day] = explode('/', $this->input->post('transfer[date]'));
                    [$hour, $minute] = explode(':', $this->input->post('transfer[clock]'));
                    $second = 0;
                    $temp = $this->pdate->mktime($hour, $minute, $second, $month, $day, $year);
                    $transfer_date = $this->pdate->date("Y-m-d H:i:s", $temp, false, false);
    
                    $this->transactions_m->save([
                        'user_id' => $this->user_login->id,
                        'order_id' => 0,
                        'amount' => $amount,
                        'gateway' => 'card2card',
                        'type' => 'charge',
                        'completed' => 0,
                        'reference' => $this->input->post('transfer[reference]'),
                        'detail' => json_encode([
                            'customer_card' => $this->input->post('transfer[card]'),
                            'transfer_date' => $transfer_date,
                            'image' => $transfer_image,
                            'description' => $this->security->xss_clean($this->input->post('transfer[description]')),
                        ], JSON_UNESCAPED_UNICODE),
                    ]);

                    // Send SMS for admins
                    $settings = $this->settings_m->getSettings(['sms', 'notification_cell_phone']);
                    $settings->sms = json_decode($settings->sms);
                    $pattern = isset($settings->sms->patterns->notify_card2card_admin) ? $settings->sms->patterns->notify_card2card_admin : '';
                    if($settings->sms->active && $settings->sms->api_key && $settings->notification_cell_phone && $pattern){
                        $this->load->library($settings->sms->active, null, 'sms');
                        $sms_status = $this->sms->send_by_token($settings->sms->api_key, $settings->sms->from, $settings->notification_cell_phone, $pattern, number_format($amount));
                    }

                    $this->session->set_flashdata('frontend_success', 'اطلاعات تراکنش شما با موفقیت ثبت شد.');
                    redirect('transactions');
                }
            } else {
                $message = validation_errors();
                $this->session->set_flashdata('frontend_error', $message);
                redirect('charge');
            }

            $cell_phone = $this->user_login->cell_phone;
        } 
        
        // Payment order
        else {

            //چک می کنیم که این سفارش وجود دارد
            $order = $this->orders_m->get_by(null, ['id' => intval($order_id)], TRUE);

            if (!$order) {
                $this->session->set_flashdata('order_message', 'فاکتوری با این مشخصات یافت نشد.');
                redirect('home');
            }

            if($order->paid){
                redirect('cards');
            }

            if(in_array('cell_phone', $this->settings->verify_when_buy) && !$this->user_login){
                $use_wallet_url = ($this->input->get('use_wallet') && $gateway != 'card2card') ? '/?use_wallet=1' : '';
                $this->session->set_userdata('last_page', "pay/request/$order_id/$gateway".$use_wallet_ur);
                //ارسال کد تایید
                $this->sendVerifyCode($order->cell_phone);
                redirect("verify");
            }

            $cell_phone = $order->cell_phone;

            if($this->user_login && $this->user_login->id != $order->user_id){
                redirect("home");
            }
            $user_id = $order->user_id;

            // چک کردن کوپن تخفیف
            if ($this->checkCouponAgain($order) == false) {
                $this->session->set_flashdata('order_message', 'کوپن تخفیفی که استفاده کردید دیگر قابل استفاده نیست. بنابراین امکان پرداخت وجود ندارد.');
                redirect('home');
            }

            // چک کردن کارت
            if ($this->checkOrderCardsAgain($order->id)  == false) {
                if($order->card2card){
                    // قبلا فیلد فروخته شده برای کارت‌های کارت به کارت  ثبت شده و پیامک و ایمیل هم ارسال شده
                    // کاربر داره دوباره صفحه را مجدد لود میکنه
                    if($this->user_login){
                        redirect('cards');
                    } else {
                        redirect('home');
                    }
                } else {
                    $this->session->set_flashdata('order_message', 'در فاصله زمانی ثبت سفارش و پرداخت شما موجودی این محصول به پایان رسید. لطفا از ابتدا سفارش خود را ثبت کنید.');
                    redirect('home');
                }
            }

            // اگر کارت به کارت بود نتیجه ثبت سفارش را بهش نمایش می دهیم و تمام
            if($order->card2card){
                $this->finishOrder($order);
                
                $this->data['card2card'] = true;
                $this->data['content'] = 'pay/result';
                $this->load->view('_layout_main', $this->data);
                return;
            }

            //به دست آوردن مبلغ قابل پرداخت
            $amount = $order->price;
            if($this->user_login && $this->user_login->credit && $this->input->get('use_wallet')){
                $amount = ($this->user_login->credit  >= $amount ) ? 0 : $order->price - $this->user_login->credit;
            }

            // تخفیف صد درصدی یا محصول رایگان  یا استفاده کامل از کیف پول
            if ($amount == 0) {

                $pay_result = $this->transactions_m->payOrderWithWallet($order_id, $this->user_login);
                if($pay_result->success){
                    if(isset($pay_result->new_credit)){
                        $this->user_login->credit = $pay_result->new_credit;
                        $this->data['user_login']->credit = $pay_result->new_credit;
                    }
                    $this->finishOrder($order);
                } else {
                    $this->session->set_flashdata('order_message', $pay_result->error);
                    redirect('home');
                }
    
                //css
                // $css = array();
                // array_push($css, 'assets/plugins/noty/css/flat.css');
                // $this->data['css'] = $css;
    
                //js
                // $js = array();
                // array_push($js, 'assets/plugins/noty/js/noty/packaged/jquery.noty.packaged.min.js');
                // $this->data['js'] = $js;
    
                $this->data['content'] = 'pay/result';
                $this->load->view('_layout_main', $this->data);
                return;
            }

            if ($amount < 100) {
                $this->setCardsAccess($order->id);
                $this->session->set_flashdata('order_message', 'مبلغ فاکتور شما زیر 100تومان است. بنابراین امکان پرداخت وجود ندارد.');
                redirect('home');
            }

            // چک کردن صحت درگاه
            $gateway_row = $this->gateways_m->get_by(null, [
                'publish' => 1, 
                'deleted' => 0, 
                'title_en' => $gateway
            ], true);
            if (!$gateway_row) {
                $this->session->set_flashdata('order_message', 'درگاه انتخاب شده مجاز نیست. یک درگاه دیگر انتخاب کنید.');
                redirect('home');
            }

            if($gateway != 'card2card' && in_array('bank_card', $this->settings->verify_when_buy)){
                // کاربر باید با کارت بانکی خودش پرداخت انجام دهد
                $card_number = $this->input->get('card');

                $this->load->model('bank_cards_m');
                $bank_card = $this->bank_cards_m->get_by('id, card_number', [
                    'user_id' => $this->user_login->id,
                    'card_number' => $card_number,
                    'deleted' => 0
                ], true);

                if(!$bank_card){
                    $message = 'شماره کارت بانکی صحیح نبود.';
                    $this->session->set_flashdata('frontend_error', $message);
                    redirect('home');
                }
            }
        }


        // در ابتدا در جدول تراکنش ها آن را ثبت می کنیم
        $data = array(
            'user_id' => $user_id,
            'order_id' => $order_id,
            'amount' => $amount,
            'type' => ($is_charge) ? 'charge' : 'credit_increase',
            'gateway' => $gateway,
            'completed' => 0
        );

        $card_number = (isset($bank_card)) ? $bank_card->card_number : '';

        //اتصال به درگاه
        // Zarinpal
        if ($gateway == 'zarinpal') {
            $this->load->library('zarinpal');
            // $sand_box = ($gateway_row->sandbox) ? true : false;
            $desc = ($this->settings->site_name) ? $this->settings->site_name : base_url();
            $call_back = site_url() . 'pay/verify/zarinpal';
            $gate = '';
            $mobile = ($this->user_login) ? $this->user_login->cell_phone : '';
            $email = '';
            if ($this->zarinpal->request($gateway_row->token, $amount, $desc, $email, $mobile, $call_back, $card_number)) {
                $data['authority'] = $this->zarinpal->get_authority();

                // Save Transaction in DB and go to gateway
                if ($this->transactions_m->save($data)) {
                    $this->zarinpal->redirect();
                    die();
                } else {
                    $error_message = 'خطای سیستمی!';
                }
            } else {
                $error_message = $this->zarinpal->get_error();
            }
        }

        // Mellat
        else if ($gateway == 'mellat') {
            $this->load->library('mellat');
            $call_back = site_url() . 'pay/verify/mellat';
            $this->mellat->init($gateway_row->token, $gateway_row->username, $gateway_row->password);

            // Save Transaction in DB and go to gateway
            if ($transaction_id = $this->transactions_m->save($data)) {
                $amount = $amount * 10; // Rial
                if ($this->mellat->request($transaction_id, $amount, $call_back)) {
                    $this->transactions_m->save(['authority' => $this->mellat->get_refId()], $transaction_id);
                    $this->mellat->redirect();
                    die();
                } else {
                    $error_message = $this->mellat->get_error();
                }
            } else {
                $error_message = 'خطای سیستمی!';
            }
        }

        // Pay.ir
        elseif ($gateway == 'payir') {
            $this->load->library('payir');
            $call_back = site_url() . 'pay/verify/payir';
            $amount = $amount * 10; // Rial
            if ($this->payir->send($gateway_row->token, $amount, $call_back, $order_id)) {
                $data['authority'] = $this->payir->get_authority();

                // Save Transaction in DB and go to gateway
                if ($this->transactions_m->save($data)) {
                    $this->payir->redirect();
                    die();
                } else {
                    $error_message = 'خطای سیستمی!';
                }
            } else {
                $error_message = $this->payir->get_error();
            }
        }

        // Parsian
        else if ($gateway == 'parsian') {
            $this->load->library('parsian');
            $call_back = base_url() . 'pay/verify/parsian';
            if($transaction_id = $this->transactions_m->save($data)){
                $amount = $amount * 10; // Rial
                if ($this->parsian->request($gateway_row->token, $amount, $transaction_id, $call_back, $order_id)) {
                    $data = ['authority'=> $this->parsian->getToken()];
                    if ($this->transactions_m->save($data, $transaction_id)) {
                        $this->parsian->redirect();
                        die();
                    } else {
                        $error_message = 'خطای سیستمی';
                    }
                } else {
                    $error_message = $this->parsian->getError();
                }
            }else{
                $error_message = 'خطای سیستمی';
            }
        }

        // Saderat
        else if ($gateway == 'saderat') {
            $this->load->library('saderat');
            $call_back = site_url() . 'pay/verify/saderat';
            if($transaction_id = $this->transactions_m->save($data)){
                $amount = $amount * 10; // Rial
                if ($this->saderat->send($gateway_row->token, $amount, $call_back, $transaction_id, $cell_phone)) {
                    $data = ['authority' => $this->saderat->get_authority()];
                    if ($this->transactions_m->save($data)) {
                        $this->saderat->redirect();
                        die();
                    } else {
                        $error_message = 'خطای سیستمی!';
                    }
                } else {
                    $error_message = $this->saderat->get_error();
                }
            }
            else{
                $error_message = 'خطای سیستمی';
            }
        }

        // Vandar 
        else if ($gateway == 'vandar') {
            $this->load->library('vandar');
            $call_back = site_url() . 'pay/verify/vandar';
            $amount = $amount * 10; // Rial
            if ($this->vandar->send($gateway_row->token, $amount, $call_back, $order_id, $cell_phone)) {
                $data['authority'] = $this->vandar->get_authority();
                if ($this->transactions_m->save($data)) {
                    $this->vandar->redirect();
                    die();
                } else {
                    $error_message = 'خطای سیستمی!';
                }
            } else {
                $error_message = $this->vandar->get_error();
            }
        }

        // Sepal
        else if ($gateway == 'sepal') {
            $this->load->library('sepal');
            $desc = $this->settings->site_name;
            $call_back = site_url() . 'pay/verify/sepal';
            if ($transaction_id = $this->transactions_m->save($data)) {
                $amount = $amount * 10; // Rial
                if ($this->sepal->request($gateway_row->token, $amount, $call_back, $transaction_id)) {
                    $this->transactions_m->save(['authority' => $this->sepal->getPaymentNumber()], $transaction_id);
                    $this->sepal->redirect();
                    die();
                } else {
                    $error_message = $this->sepal->getError();
                }
            } else {
                $error_message = 'خطای سیستمی!';
            }
        }

        // Zibal
        else if ($gateway == 'zibal') {
            $this->load->library('zibal');
            $call_back = site_url() . 'pay/verify/zibal';
            if($transaction_id = $this->transactions_m->save($data)){
                $mobile = ($this->user_login) ? $this->user_login->cell_phone : '';
                $amount = $amount * 10; // Rial
                if ($this->zibal->request($gateway_row->token, $amount, $call_back, $transaction_id, $mobile, $card_number)) {
                    if ($this->transactions_m->save(['authority' => $this->zibal->get_authority()], $transaction_id)) {
                        $this->zibal->redirect();
                        die();
                    } else {
                        $error_message = 'خطای سیستمی!';
                    }
                } else {
                    $error_message = $this->zibal->get_error();
                }
            } else {
                $error_message = 'خطای سیستمی!';
            }
        }

        // Id pay
        else if ($gateway == 'idpay') {
            $this->load->library('idpay');
            $name = '';
            $phone = '';
            $mail = '';
            $desc = $this->settings->site_name;
            $call_back = site_url() . 'pay/verify/idpay';
            $gate = '';
            $amount = $amount * 10; // Rial
            if ($transaction_id = $this->transactions_m->save($data)) {
                if ($this->idpay->send($gateway_row->token, $transaction_id, $amount, $call_back, $name = null, $phone = null, $mail = null, $desc = null)) {
                    if ($this->transactions_m->save(['authority' => $this->idpay->get_authority()], $transaction_id)) {
                        $this->idpay->redirect();
                        die();
                    } else {
                        $error_message = 'خطای سیستمی!';
                    }
                } else {
                    $error_message = $this->idpay->get_error();
                }
            } else {
                $error_message = 'خطای سیستمی!';
            }
        }

        // Nextpay
        else if ($gateway == 'nextpay') {
            $this->load->library('nextpay');
            $call_back = site_url() . 'pay/verify/nextpay';
            if ($transaction_id = $this->transactions_m->save($data)) {
                if ($this->nextpay->request($gateway_row->token, $amount, $call_back, $transaction_id, $cell_phone)) {
                    if ($this->transactions_m->save(['authority' => $this->nextpay->get_trans_id()], $transaction_id)) {
                        $this->nextpay->redirect();
                        die();
                    } else {
                        $error_message = 'خطای سیستمی!';
                    }
                } else {
                    $error_message = $this->nextpay->get_error();
                }
            } else {
                $error_message = 'خطای سیستمی!';
            }
        }

        // Vanda
        else if ($gateway == 'vanda') {
            $this->load->library('vanda');
            $desc = $this->settings->site_name;
            $call_back = site_url() . 'pay/verify/vanda';
            $mobile = '';
            $email = '';
            if ($transaction_id = $this->transactions_m->save($data)) {
                $gateway_result = $this->vanda->request($gateway_row->token, $amount, $transaction_id, $call_back, $desc, $mobile, $email);
                if ($gateway_result && $gateway_result['vprescode']) {
                    $data['authority'] = $gateway_result['vprescode'];
    
                    // Save Transaction in DB and go to gateway
                    if ($this->transactions_m->save($data, $transaction_id)) {
                        $this->vanda->redirect($gateway_result['form']);
                        die();
                    } else {
                        $error_message = 'خطای سیستمی!';
                    }
                } else {
                    $error_message = $this->vanda->get_error();
                }
            } else {
                $error_message = 'خطای سیستمی!';
            }

        }

        // Saman
        else if ($gateway == 'saman') {
            $this->load->library('saman');
            $call_back = base_url() . 'pay/verify/saman';
            if ($transaction_id = $this->transactions_m->save($data)) {                
                $amount = $amount * 10; // Rial
                if($this->saman->request($gateway_row->username, $amount, $transaction_id, $call_back)){
                    $this->transactions_m->save(['authority' => $this->saman->getToken()], $transaction_id);
                    $this->saman->redirect();
                    die();
                } else {
                    $error_message = 'خطا در اتصال به بانک';
                }
            } else {
                $error_message = 'خطای سیستمی!';
            }
        }

        // Bitpay
        else if ($gateway == 'bitpay') {
            $this->load->library('bitpay');
            $call_back = site_url() . 'pay/verify/bitpay';
            $name = '';
            $email = '';
            $desc = $this->settings->site_name;
            $amount = $amount * 10; // Rial
            if ($this->bitpay->request($gateway_row->token, $amount, $order_id, $call_back, $email, $name, $desc)) {
                $data['authority'] = $this->bitpay->get_authority();
                if ($this->transactions_m->save($data)) {
                    $this->bitpay->redirect();
                    die();
                } else {
                    $error_message = 'خطای سیستمی!';
                }
            } else {
                $error_message  = $this->bitpay->get_error();
            }
        }

        // Novinopay
        else if ($gateway == 'novinopay') {
            $this->load->library('novinopay');
            $call_back = site_url() . 'pay/verify/novinopay';
            if ($transaction_id = $this->transactions_m->save($data)) {
                $amount = $amount * 10; // Rial
                if ($this->novinopay->request($gateway_row->token, $amount, $call_back, $transaction_id, $cell_phone)) {
                    if ($this->transactions_m->save(['authority' => $this->novinopay->get_authority()], $transaction_id)) {
                        $this->novinopay->redirect();
                        die();
                    } else {
                        $error_message = 'خطای سیستمی!';
                    }
                } else {
                    $error_message = $this->novinopay->get_error();
                }
            } else {
                $error_message = 'خطای سیستمی!';
            }
        }

        // PayPing
        else if ($gateway == 'payping') {
            $this->load->library('payping');
            $call_back = site_url() . 'pay/verify/payping';
            if ($transaction_id = $this->transactions_m->save($data)) {
                if ($this->payping->request($gateway_row->token, $amount, $call_back, $transaction_id, $cell_phone)) {
                    if ($this->transactions_m->save(['authority' => $this->payping->get_trans_code()], $transaction_id)) {
                        $this->payping->redirect();
                        die();
                    } else {
                        $error_message = 'خطای سیستمی!';
                    }
                } else {
                    $error_message = $this->payping->get_error();
                }
            } else {
                $error_message = 'خطای سیستمی!';
            }
        }

        // Jibit
        else if ($gateway == 'jibit') {
            $this->load->library('jibit/gateway', [
                'apiKey' => $gateway_row->token,
                'apiSecret' => $gateway_row->password,
            ], 'jibit');
            if ($transaction_id = $this->transactions_m->save($data)) {
                $call_back = base_url('pay/verify/jibit');
                $amount = $amount * 10; // Rial
                if ($this->jibit->request($amount, $transaction_id, $cell_phone, $call_back, $card_number)) {
                    if ($this->transactions_m->save(['authority' => $this->jibit->getPurchaseId()], $transaction_id)) {
                        $this->jibit->redirect();
                        die();
                    } else {
                        $error_message = 'خطای سیستمی!';
                    }
                } else {
                    $error_message = $this->jibit->getError();
                }
            } else {
                $error_message = 'خطای سیستمی!';
            }
        }

        // Aqayepardakht
        else if ($gateway == 'aqayepardakht') {
            $this->load->library('aqayepardakht');
            
            // $call_back = base_url('pay/verify/aqayepardakht');
            $call_back = base_url('callback.php/?gateway=aqayepardakht');
            
            if ($transaction_id = $this->transactions_m->save($data)) {
                if ($this->aqayepardakht->request($gateway_row->token, $amount, $call_back, $transaction_id)) {
                    if ($this->transactions_m->save(['authority' => $this->aqayepardakht->getTransid()], $transaction_id)) {
                        $this->aqayepardakht->redirect();
                        die();
                    } else {
                        $error_message = 'خطای سیستمی!';
                    }
                } else {
                    $error_message = $this->aqayepardakht->getError();
                }
            } else {
                $error_message = 'خطای سیستمی!';
            }
        }

        // Paystar
        else if ($gateway == 'paystar') {
            $this->load->library('paystar');
            
            $call_back = base_url('pay/verify/paystar');
            
            if ($transaction_id = $this->transactions_m->save($data)) {
                $amount = $amount * 10; // Rial
                if ($this->paystar->request($gateway_row->token, $amount, $call_back, $transaction_id, $card_number)) {
                    if ($this->transactions_m->save(['authority' => $this->paystar->getRefNum()], $transaction_id)) {
                        $this->paystar->redirect();
                        die();
                    } else {
                        $error_message = 'خطای سیستمی!';
                    }
                } else {
                    $error_message = $this->paystar->getError();
                }
            } else {
                $error_message = 'خطای سیستمی!';
            }
        }

        // Starshop
        else if ($gateway == 'starshop') {
            $this->load->library('starshop');
            
            $call_back = base_url('pay/verify/starshop');
            
            if ($transaction_id = $this->transactions_m->save($data)) {
                $amount = $amount * 10; // Rial
                if ($this->starshop->request($gateway_row->token, $amount, $call_back, $transaction_id, $card_number)) {
                    if ($this->transactions_m->save(['authority' => $this->starshop->getRefNum()], $transaction_id)) {
                        $this->starshop->redirect();
                        die();
                    } else {
                        $error_message = 'خطای سیستمی!';
                    }
                } else {
                    $error_message = $this->starshop->getError();
                }
            } else {
                $error_message = 'خطای سیستمی!';
            }
        }

        // Directpay
        else if ($gateway == 'directpay') {
            $this->load->library('directpay');
            
            $call_back = base_url('pay/verify/directpay');
            if ($transaction_id = $this->transactions_m->save($data)) {
                $amount = $amount * 10; // Rial
                $cell_phone = $this->user_login ? $this->user_login->cell_phone : '';
                if ($this->directpay->request($gateway_row->token, $amount, $call_back, $transaction_id, $cell_phone, $card_number)) {
                    if ($this->transactions_m->save(['authority' => $this->directpay->getRefNum()], $transaction_id)) {
                        $this->directpay->redirect();
                        die();
                    } else {
                        $error_message = 'خطای سیستمی!';
                    }
                } else {
                    $error_message = $this->directpay->getError();
                }
            } else {
                $error_message = 'خطای سیستمی!';
            }
        }

        // Novinpal
        else if ($gateway == 'novinpal') {
            $this->load->library('novinpal');
            $call_back = site_url() . 'pay/verify/novinpal';
            if ($transaction_id = $this->transactions_m->save($data)) {
                $amount = $amount * 10; // Rial
                if ($this->novinpal->request($gateway_row->token, $amount, $call_back, $transaction_id, $cell_phone)) {
                    if ($this->transactions_m->save(['authority' => $this->novinpal->get_trans_id()], $transaction_id)) {
                        $this->novinpal->redirect();
                        die();
                    } else {
                        $error_message = 'خطای سیستمی!';
                    }
                } else {
                    $error_message = $this->novinpal->get_error();
                }
            } else {
                $error_message = 'خطای سیستمی!';
            }
        }


        // MixPay
        else if ($gateway == 'mixpay') {
            //  این درگاه کرپتو و بر پایه دلار هست پس  باید نرخ دلار و ارزش دلاری سفارش را واکشی و در تراکنش ذخیره کنیم
            if($gateway_row->dollar_base){
                //  چک کردن نرخ دلار از تنظیمات
                if(isset($this->settings->rate->dollar) && $this->settings->rate->dollar > 0){
                    // ابتدا باید سفارش را بر اساس دلار ویرایش کنیم
                    //  تابع ceil و round جواب نمیده
                    $amount_dollar = ceilWithPrecision($amount / $this->settings->rate->dollar, 3);

                    if($amount_dollar >= 0.01){
                        $data['amount_dollar'] = $amount_dollar;
                        $data['dollar_rate'] = $this->settings->rate->dollar;

                        $this->load->library('mixpay');
                        $call_back = base_url('pay/verify/mixpay');
                        // $call_back = base_url('callback.php/?gateway=mixpay');
                        
                        if ($transaction_id = $this->transactions_m->save($data)) {
                            // طبق قانونش حداقل شش کاراکتر لازم داریم

                            $needed_id = str_pad((string)$transaction_id, 6, '0', STR_PAD_LEFT);
                            $call_back .= "?tranId=$needed_id";
                            if ($this->mixpay->request($gateway_row->token, $amount_dollar, $needed_id, $call_back)) {
                                
                                if ($this->transactions_m->save(['authority' => $this->mixpay->getTransid()], $transaction_id)) {
                                    $this->mixpay->redirect();
                                    die();
                                } else {
                                    $error_message = 'خطای سیستمی!';
                                }
                            } else {
                                $error_message = $this->mixpay->getError();
                            }
                        } else {
                            $error_message = 'خطای سیستمی!';
                        }
                    }else{
                        $error_message = $this->get_error('dollar_min');
                    }
                    
                }else{
                    $error_message = $this->get_error('dollar');
                }
            }else{
                // در حالت عادی نباید به این بخش برسیم
                $error_message = $this->get_error('dollar');
            }
        }

        // Oxapay
        else if ($gateway == 'oxapay') {
            //  این درگاه کرپتو و بر پایه دلار هست پس  باید نرخ دلار و ارزش دلاری سفارش را واکشی و در تراکنش ذخیره کنیم
            if($gateway_row->dollar_base){
                //  چک کردن نرخ دلار از تنظیمات
                if(isset($this->settings->rate->dollar) && $this->settings->rate->dollar > 0){
                    // ابتدا باید سفارش را بر اساس دلار ویرایش کنیم
                    //  تابع ceil و round جواب نمیده
                    $amount_dollar = ceilWithPrecision($amount / $this->settings->rate->dollar, 3);

                    if($amount_dollar >= 0.1){
                        $data['amount_dollar'] = $amount_dollar;
                        $data['dollar_rate'] = $this->settings->rate->dollar;

                        $this->load->library('oxapay');
                        
                        if ($transaction_id = $this->transactions_m->save($data)) {
                            $call_back = base_url('pay/verify/oxapay') . "?transaction_id=$transaction_id";
                            // $call_back = base_url('callback.php/?gateway=oxapay');
                           
                            // در این درگاه کالبک برای نوتیف استفاده میشه
                            if ($this->oxapay->request($gateway_row->token, $amount_dollar, $transaction_id, $call_back)) {
                                
                                if ($this->transactions_m->save(['authority' => $this->oxapay->getTransid()], $transaction_id)) {
                                    $this->oxapay->redirect();
                                    die();
                                } else {
                                    $error_message = 'خطای سیستمی!';
                                }
                            } else {
                                $error_message = $this->oxapay->getError();
                            }
                        } else {
                            $error_message = 'خطای سیستمی!';
                        }
                    }else{
                        $error_message = $this->get_error('dollar_min');
                    }
                }else{
                    $error_message = $this->get_error('dollar');
                }
            }else{
                // در حالت عادی نباید به این بخش برسیم
                $error_message = $this->get_error('dollar');
            }
        }

        // وقتی به اینجا می رسیم یعنی نتوانسته به درگاه وصل شود

        if(!$is_charge){
            // کارت ها را آزاد می کنیم
            $this->setCardsAccess($order->id);
        }

        // Error message
        if(!isset($error_message) || (isset($error_message) && $error_message == '')){
            $error_message = $this->get_error('connection');
        }
        $this->data['error_message'] = $error_message;

        $this->data['content'] = 'pay/result';
        $this->load->view('_layout_main', $this->data);
    }

    
    public function verify($gateway = NULL)
    {
        // چک کردن صحت درگاه
        $gateway_row = $this->gateways_m->get_by(null, [
            'publish' => 1, 
            'deleted' => 0, 
            'title_en' => $gateway,
        ], true);
        if ($gateway_row) {

            // Zarinpal
            if ($gateway == 'zarinpal') {
                $this->load->library('zarinpal');
                if (isset($_GET['Status']) && isset($_GET['Authority'])) {
                    $authority = $_GET['Authority'];
                    $where = ['authority' => $authority, 'gateway' => $gateway];
                    $transaction = $this->transactions_m->get_by(NULL, $where, true);
                    if ($transaction) {
                        if($transaction->completed == 1){
                            $this->completedTransaction($transaction);
                        }
                        if ($_GET['Status'] == 'OK') {
                            // $sand_box = ($gateway_row->sandbox) ? true : false;
                            if ($this->zarinpal->verify($gateway_row->token, $transaction->amount)) {
                                $this->verifiedTransaction($transaction, $this->zarinpal->get_ref_id());
                            } else {
                                $error_message = $this->zarinpal->get_error();
                                if(!$error_message){
                                    $error_message = $this->get_error('connection');
                                }
                            }
                        } else {
                            $error_message = $this->get_error('cancel'); 
                        }
                    }
                } else {
                    $error_message = $this->get_error('imperfect');
                }
            }

            // Mellat
            else if ($gateway == 'mellat') {
                $this->load->library('mellat');
                if (isset($_POST['ResCode']) && isset($_POST['RefId']) && isset($_POST['SaleOrderId']) && isset($_POST['SaleReferenceId'])) {
                    $ResCode = $_POST['ResCode'];
                    $authority = $this->security->xss_clean($_POST['RefId']);
                    $SaleOrderId = intval($_POST['SaleOrderId']);
                    $refid = $SaleReferenceId = $_POST['SaleReferenceId'];

                    $where = [
                        'id' => $SaleOrderId,
                        'authority' => $authority,
                        'gateway' => $gateway
                    ];
                    $transaction = $this->transactions_m->get_by(NULL, $where, true);
                    if ($transaction) {
                        if($transaction->completed == 1){
                            $this->completedTransaction($transaction);
                        }
                        if ($ResCode == '0') {
                            $this->mellat->init($gateway_row->token, $gateway_row->username, $gateway_row->password);
                            if ($this->mellat->verify($SaleOrderId, $SaleReferenceId)) {
                                if ($this->mellat->settle($SaleOrderId, $SaleReferenceId)) {
                                    $this->verifiedTransaction($transaction, $refid);
                                } else {
                                    $error_message = 'خطا در تایید نهایی تراکنش';
                                }
                            } else {
                                $error_message = 'خطا در تایید تراکنش';
                            }
                        } else {
                            $error_message = $this->get_error('cancel'); 
                        }
                    }
                } else {
                    $error_message = $this->get_error('imperfect');
                }
            }

            // Pay.ir
            else if ($gateway == 'payir') {
                $this->load->library('payir');
                if (isset($_POST['status']) && isset($_POST['transId'])) {
                    $authority = $_POST['transId'];
                    $where = array('authority' => $authority, 'gateway' => $gateway);
                    $transaction = $this->transactions_m->get_by(NULL, $where, true);
                    if ($transaction) {
                        if($transaction->completed == 1){
                            $this->completedTransaction($transaction);
                        }
                        if ($_POST['status'] == 1) {
                            $amount = $transaction->amount;
                            $merchant_id = $gateway_row->token;
                            if ($this->payir->verify($merchant_id, $authority)) {
                                $paid_amount = $this->payir->get_paid_amount() / 10; //toman
                                if ($amount == $paid_amount) {
                                    $this->verifiedTransaction($transaction, $authority);
                                }else{
                                    $error_message = 'خطای عدم مطابقت مبلغ پرداختی ';
                                }
                            } else {
                                $error_message = $this->payir->get_error();
                            }
                        } else {
                            $error_message = $this->get_error('cancel'); 
                        }
                    }
                } else {
                    $error_message = $this->get_error('imperfect');
                }
            }

            // Parsian
            else if ($gateway == 'parsian') {
                $this->load->library('parsian');
                if (isset($_POST['Token']) && isset($_POST['status']) && isset($_POST['OrderId']) && isset($_POST['Amount']) && isset($_POST['RRN'])) {
                    $token = $this->input->post('Token');
                    $status = $this->input->post('status');
                    $transaction_id = $this->input->post('OrderId');
                    //$TerminalNo = $this->input->post('TerminalNo')
                    $amount = $this->input->post('Amount');
                    $refid = $this->input->post('RRN');

                    $amount = str_replace(',', '', $amount);
                    $amount = is_numeric($amount) ? $amount/10 : $amount;

                    $where = [
                        'authority' => $token,
                        'gateway' => $gateway,
                        'id' => $transaction_id
                    ];
                    $transaction = $this->transactions_m->get_by(NULL, $where, true);
                    if ($transaction) { 
                        if($transaction->completed == 1){
                            $this->completedTransaction($transaction);
                        }                    
                        if ($refid > 0 && $status == 0) {
                            if($amount == $transaction->amount){
                                if ($this->parsian->verify($gateway_row->token, $token)) {
                                    $this->verifiedTransaction($transaction, $this->parsian->getRRN());
                                } else {
                                    $error_message = $this->parsian->getError();
                                }
                            } else{
                                $error_message = $this->get_error('price');
                            }
                        } else {
                            $error_message = $this->get_error('cancel'); 
                        }
                    }
                } else {
                    $error_message = $this->get_error('imperfect');
                }
            }

            // Saderat
            else if ($gateway == 'saderat') {
                $this->load->library('saderat');
                if(isset($_POST['respcode']) && isset($_POST['invoiceid']) && isset($_POST["amount"]) && isset($_POST["rrn"]) && isset($_POST['digitalreceipt'])){
                    $transaction = $this->transactions_m->get_by(NULL, [
                        // 'authority' => ,
                        'id' => intval($_POST['invoiceid']), 
                        'gateway' => $gateway
                    ], true);
                    if ($transaction) {
                        if($transaction->completed == 1){
                            $this->completedTransaction($transaction);
                        } 
                        if($_POST['respcode'] === 0 ){
                            $paid_amount = intval($_POST["amount"]) / 10;
                            if($paid_amount >= $transaction->amount) {
                                if ($this->saderat->verify($gateway_row->token, $_POST['digitalreceipt'])) {
                                    $this->verifiedTransaction($transaction, $_POST["rrn"]);
                                } else {
                                    $error_message =  $this->saderat->get_error();
                                }
                            }else{
                                $error_message = $this->get_error('price');
                            }
                        } elseif(isset($_POST['respmsg'])) {
                            $error_message = $_POST['respmsg'];
                        } else {
                            $error_message = $this->get_error('imperfect');
                        }
                    } 
                } else {
                    $error_message = $this->get_error('imperfect');
                }
            }

            // Vandar
            else if ($gateway == 'vandar') {
                $this->load->library('vandar');
                if (isset($_GET['payment_status']) && isset($_GET['token'])) {
                    $authority = $_GET['token'];
                    $where = ['authority' => $authority, 'gateway' => $gateway];
                    $transaction = $this->transactions_m->get_by(NULL, $where, true);
                    if ($transaction) {
                        if($transaction->completed == 1){
                            $this->completedTransaction($transaction);
                        } 
                        if ($_GET['payment_status'] == 'OK') {
                            if ($this->vandar->verify($gateway_row->token, $authority)) {
                                // Check transaction amount
                                $amount = $transaction->amount;
                                $paid_amount = intval($this->vandar->get_paid_amount()) / 10;
                                if($paid_amount && $paid_amount >= $amount) {
                                    $this->verifiedTransaction($transaction, $this->vandar->get_trans_id());
                                } else {
                                    $error_message = $this->get_error('price');
                                }
                            } else {
                                $error_message = $this->vandar->get_error();
                            }
                        } else {
                            $error_message = $this->get_error('cancel');
                        }
                    }
                } else {
                    $error_message = $this->get_error('imperfect');
                }
            }

            // Sepal
            else if ($gateway == 'sepal') {
                $this->load->library('sepal');
                if (isset($_POST['status']) && isset($_POST['paymentNumber']) && isset($_POST['invoiceNumber'])) {
                    $authority = $this->security->xss_clean($_POST['paymentNumber']);
                    $transaction_id = intval($_POST['invoiceNumber']);

                    $where = array(
                        'id' => $transaction_id,
                        'authority' => $authority,
                        'gateway' => $gateway
                    );
                    $transaction = $this->transactions_m->get_by(NULL, $where, true);
                    if ($transaction) {
                        if($transaction->completed == 1){
                            $this->completedTransaction($transaction);
                        } 
                        if ($_POST['status'] == 1) {
                            if ($this->sepal->verify($gateway_row->token, $authority)) {
                                $this->verifiedTransaction($transaction, $authority);
                            } else {
                                $error_message = $this->sepal->getError();
                            }
                        } else {
                            $error_message = $this->get_error('cancel'); 
                        }
                    }
                } else {
                    $error_message = $this->get_error('imperfect');
                }
            }

            // Zibal
            else if ($gateway == 'zibal') {
                $this->load->library('zibal');
                if (isset($_GET['success']) && isset($_GET['trackId']) && isset($_GET['orderId'])) {
                    $authority = $_GET['trackId'];
                    $transaction_id = intval($_GET['orderId']);
                    $where = ['id' => $transaction_id, 'authority' => $authority, 'gateway' => $gateway];
                    $transaction = $this->transactions_m->get_by(NULL, $where, true);
                    if ($transaction) {
                        if($transaction->completed == 1){
                            $this->completedTransaction($transaction);
                        } 
                        if ($_GET['success'] == 1) {
                            if ($this->zibal->verify($gateway_row->token, $authority)) {
                                if($this->zibal->get_paid_amount() == $transaction->amount * 10){
                                    $this->verifiedTransaction($transaction, $this->zibal->get_trans_id());
                                } else {
                                    $error_message = $this->get_error('price');
                                }
                            } else {
                                $error_message = $this->zibal->get_error();
                            }
                        } else {
                            $error_message = $this->get_error('cancel');
                        }
                    }
                } else {
                    $error_message = $this->get_error('imperfect');
                }
            }

            // Idpay
            else if ($gateway == 'idpay') {
                $this->load->library('idpay');
                $status = intval($this->input->post('status'));
                $track_id = $this->input->post('track_id');
                $authority = $this->input->post('id');
                $transaction_id = intval($this->input->post('order_id'));
                $amount = $this->input->post('amount');

                if ($track_id && $authority && $transaction_id && is_numeric($amount)) {
                    $amount = $amount / 10; // Tooman
                    $where = [
                        'authority' => $authority,
                        'gateway' => $gateway,
                        'id' => $transaction_id,
                        'amount' => $amount
                    ];
                    $transaction = $this->transactions_m->get_by(NULL, $where, TRUE);
                    if ($transaction) {
                        if($transaction->completed == 1){
                            $this->completedTransaction($transaction);
                        } 
                        if ($status == 10) {
                            if ($this->idpay->verify($gateway_row->token, $transaction->authority, $transaction->id)) {
                                if ($transaction->amount * 10 === $this->idpay->get_paid_amount() * 1) {
                                    if($track_id == $this->idpay->get_track_id()){
                                        $this->verifiedTransaction($transaction, $track_id);
                                    }
                                } else {
                                    $error_message = $this->get_error('price');
                                }
                            } else {
                                $error_message = $this->idpay->get_error();
                            }
                        } else {
                            $error_message = $this->idpay->get_status_message($status);
                        }
                    }
                } else {
                    $error_message = $this->get_error('imperfect');
                }
            }

            // Nextpay
            else if ($gateway == 'nextpay') {
                $this->load->library('nextpay');
                $transaction_id = intval($this->input->get('order_id'));
                $authority = $this->input->get('trans_id');
                $amount = $this->input->get('amount');
                if ($transaction_id && $authority && is_numeric($amount)) {
                    $where = [
                        'authority' => $authority,
                        'gateway' => $gateway,
                        'id' => $transaction_id,
                        'amount' => $amount
                    ];
                    $transaction = $this->transactions_m->get_by(NULL, $where, TRUE);
                    if ($transaction) {
                        if($transaction->completed == 1){
                            $this->completedTransaction($transaction);
                        } 
                        if ($this->nextpay->verify($gateway_row->token, $transaction->amount, $transaction->authority)) {
                            if ($this->nextpay->get_paid_amount() * 1 === $transaction->amount * 1) {
                                if($this->nextpay->get_order_id() == $transaction->id){
                                    $this->verifiedTransaction($transaction, $this->nextpay->get_ref_id());
                                }
                            } else {
                                $error_message = $this->get_error('price');
                            }
                        } else {
                            $error_message = $this->nextpay->get_error();
                        }
                    }
                } else {
                    $error_message = $this->get_error('imperfect');
                }
            }

            // Vanda
            else if ($gateway == 'vanda') {
                $this->load->library('vanda');
                if (isset($_GET['au'])) {

                    $authority = $_GET['au'];
                    // $transaction_id = $_GET['tid'];
                    // Is exists buy?
                    $where = array( 
                        'authority' => $authority, 
                        'gateway'   => $gateway
                    );
                    $transaction = $this->transactions_m->get_by(NULL, $where, true);
                    if ($transaction) {
                        if($transaction->completed == 1){
                            $this->completedTransaction($transaction);
                        } 
                        $bank_return = $_POST + $_GET;
                        $vandaVerify = $this->vanda->verify($gateway_row->token, $transaction->amount, $transaction->id, $authority, $bank_return);
                        if ($vandaVerify && isset($vandaVerify['result']) && $vandaVerify['result']==1) {
                            $this->verifiedTransaction($transaction, $authority);
                        } else {
                            $error_message = $this->vanda->get_error();
                        }
                    }
                }else{
                    $error_message = $this->get_error('imperfect');
                }
            }

            // Saman
            else if ($gateway == 'saman') {
                $this->load->library('saman');
                if (isset($_POST['State']) && isset($_POST['ResNum']) && isset($_POST['RefNum'])) {
                    $refrence = $_POST['RefNum'];
                    $transaction_id = $_POST['ResNum'];
                    $where = array('id' => $transaction_id, 'gateway' => $gateway);

                    $transaction = $this->transactions_m->get_by(NULL, $where, true);
                    if ($transaction) {
                        if($transaction->completed == 1){
                            $this->completedTransaction($transaction);
                        } 
                        if ($_POST['State'] === 'OK') {
                            $result = $this->saman->verify($gateway_row->username, $refrence);
                            if ($result > 0) {
                                if ($transaction->amount * 10 <> $result) {
                                    $this->saman->reverseTransaction($gateway_row->username, $gateway_row->password, $refrence);  // بازگشت تراکنش
                                    $error_message = 'خطا در تایید مبلغ، تراکنش برگشت خورد و در صورت کم شدن مبلغ از حساب شما، تا 72 ساعت به حساب شما باز می گردد.';
                                } else {
                                    $this->verifiedTransaction($transaction, $refrence);
                                }
                            } else {
                                $error_message = 'خطا در تایید نهایی تراکنش';
                            }
                        } else {
                            $error_message = $this->get_error('cancel'); 
                        }
                    }
                } else {
                    $error_message = $this->get_error('imperfect');
                }                
            }

            // Bitpay
            else if ($gateway == 'bitpay') {
                $this->load->library('bitpay');
                if (isset($_POST['trans_id']) && isset($_POST['id_get'])) {
                    $authority = $_POST['id_get'];
                    $refid = $_POST['trans_id'];
                    $where = array('authority' => $authority, 'gateway' => $gateway);
                    $transaction = $this->transactions_m->get_by(NULL, $where, true);
                    if ($transaction) {
                        if($transaction->completed == 1){
                            $this->completedTransaction($transaction);
                        } 
                        if ($refid>0) {
                            // $amount = $transaction->amount;
                            $merchant_id = $gateway_row->token;
                            $bitpayVerify = $this->bitpay->verify($merchant_id, $authority, $refid);
                            if ($bitpayVerify==1) {
                                $this->verifiedTransaction($transaction, $refid);
                            } else {
                                $error_message = $this->bitpay->get_error();
                            }
                        } else {
                            $error_message = $this->get_error('cancel');
                        }
                    }
                } else {
                    $error_message = $this->get_error('imperfect');
                }
            }

            // Novinopay
            else if ($gateway == 'novinopay') {
                $this->load->library('novinopay');
                if (isset($_GET['InvoiceID']) && isset($_GET['Authority']) && isset($_GET['PaymentStatus'])) {
                    $transaction_id = intval($this->input->get('InvoiceID'));
                    $authority = $this->input->get('Authority');
                    $where = [
                        'authority' => $authority,
                        'gateway' => $gateway,
                        'id' => $transaction_id
                    ];
                    $transaction = $this->transactions_m->get_by(NULL, $where, TRUE);
                    if ($transaction) {
                        if($transaction->completed == 1){
                            $this->completedTransaction($transaction);
                        } 
                        if($this->input->get('PaymentStatus') == 'OK'){
                            $transaction_amount_rial = $transaction->amount * 10;
                            if ($this->novinopay->verify($gateway_row->token, $transaction_amount_rial, $transaction->authority)) {
                                if ($this->novinopay->get_paid_amount() * 1 === $transaction_amount_rial) {
                                    if($this->novinopay->get_data()->invoice_id && $transaction->id){
                                        $this->verifiedTransaction($transaction, $this->novinopay->get_ref_id(), json_encode($this->novinopay->get_data()));
                                    }
                                } else {
                                    $error_message = $this->get_error('price');
                                }
                            } else {
                                $error_message = $this->novinopay->get_error();
                            }
                        } else {
                            $error_message = $this->get_error('cancel'); 
                        }
                    }
                } else {
                    $error_message = $this->get_error('imperfect');
                }
            }

            // PayPing
            else if ($gateway == 'payping') {
                $this->load->library('payping');
                $status = $this->input->post('status');
                // $errorCode = $this->input->post('errorCode');
                $data = $this->input->post('data');
                $transaction_id = 0;
                $authority = '';
                $refid = '';
                if($status == 1){
                    $data = json_decode($data);
                    $transaction_id = isset($data->clientRefId) ? $data->clientRefId : '';
                    $authority = isset($data->paymentCode) ? $data->paymentCode : '';
                    $refid = isset($data->paymentRefId) ? $data->paymentRefId : '';
                }


                if ($status == 1 && $transaction_id && $authority && $refid) {
                    $where = [
                        'authority' => $authority,
                        'gateway' => $gateway,
                        'id' => $transaction_id
                    ];
                    $transaction = $this->transactions_m->get_by(NULL, $where, TRUE);
                    if ($transaction) {
                        if($transaction->completed == 1){
                            $this->completedTransaction($transaction);
                        } 
                        if ($this->payping->verify($gateway_row->token, $refid)) {
                            if ($this->payping->get_paid_amount() * 1 === $transaction->amount * 1) {
                                $this->verifiedTransaction($transaction, $refid, json_encode($this->payping->get_data()));
                            } else {
                                $error_message = $this->get_error('price');
                            }
                        } else {
                            $error_message = $this->payping->get_error();
                        }
                    }
                } elseif($refid){
                    $error_message = $this->payping->code_error($refid);
                } else {
                    $error_message = $this->get_error('imperfect');
                }
            }

            // Jibit
            else if ($gateway == 'jibit') {
                $status = $this->input->post('status');
                $authority = $this->input->post('purchaseId');
                $transaction_id = intval($this->input->post('clientReferenceNumber'));
                $refid = $this->input->post('pspRRN');
                if($status === 'SUCCESSFUL' && $authority && $transaction_id && $refid){
                    $where = [
                        'authority' => $authority,
                        'gateway' => $gateway,
                        'id' => $transaction_id
                    ];
                    $transaction = $this->transactions_m->get_by(NULL, $where, TRUE);
                    if ($transaction) {
                        if($transaction->completed == 1){
                            $this->completedTransaction($transaction);
                        } 
                        $this->load->library('jibit/gateway', [
                            'apiKey' => $gateway_row->token,
                            'apiSecret' => $gateway_row->password,
                        ], 'jibit');

                        if ($this->jibit->verify($authority)) {
                            if ($this->jibit->getPaidAmount() * 1 === $transaction->amount * 10) {
                                // json_encode($this->jibit->getDetail())
                                $this->verifiedTransaction($transaction, $refid);
                            } else {
                                $error_message = $this->get_error('price');
                            }
                        } else {
                            $error_message = $this->jibit->getError();
                        }
                    }
                } elseif($refid){
                    $error_message = $this->jibit->getError();
                } else {
                    $error_message = $this->get_error('imperfect');
                }
            }

            // Aqayepardakht
            else if ($gateway == 'aqayepardakht') {
                $this->load->library('aqayepardakht');
                if (isset($_POST['status']) && isset($_POST['transid']) && isset($_POST['tracking_number']) && isset($_POST['invoice_id'])) {

                    $authority = $this->security->xss_clean($_POST['transid']);
                    $transaction_id = intval($_POST['invoice_id']);

                    $where = [
                        'id' => $transaction_id, 
                        'gateway' => $gateway,
                        'authority' => $authority, 
                    ];
                    $transaction = $this->transactions_m->get_by(NULL, $where, true);
                    if ($transaction) {
                        if($transaction->completed == 1){
                            $this->completedTransaction($transaction);
                        } 
                        if ($_POST['status'] === '1') {
                            if ($this->aqayepardakht->verify($gateway_row->token, $transaction->amount, $authority)) {
                                $tracking_number = $this->input->post('tracking_number');
                                $detail = [
                                    'cardnumber' => $this->security->xss_clean($this->input->post('cardnumber')),
                                    'bank' => $this->security->xss_clean($this->input->post('bank')),
                                ];
                                $this->verifiedTransaction($transaction, $tracking_number, json_encode($detail));
                            } else {
                                $error_message = $this->aqayepardakht->getError();
                            }
                        } else {
                            $error_message = $this->get_error('cancel'); 
                        }
                    }
                } else {
                    $error_message = $this->get_error('imperfect');
                }
            }

            // Paystar
            else if ($gateway == 'paystar') {
                $this->load->library('paystar');

                $status = $this->input->get('status');
                $transaction_id = intval($this->input->get('order_id'));
                $authority = $this->input->get('ref_num');

                if ($transaction_id && $authority) {

                    $where = [
                        'authority' => $authority,
                        'gateway' => $gateway,
                        'id' => $transaction_id
                    ];
                    $transaction = $this->transactions_m->get_by(NULL, $where, TRUE);
                    if ($transaction) {
                        if($transaction->completed == 1){
                            $this->completedTransaction($transaction);
                        } 

                        if($status === '1'){
                            $paystar_transaction_id = $this->input->get('transaction_id');
                            $card_number = $this->input->get('card_number');
                            $tracking_code = $this->input->get('tracking_code');
                            $transaction_amount_rial = $transaction->amount * 10;
                            if ($this->paystar->verify($gateway_row->token, $transaction_amount_rial, $authority, $card_number, $tracking_code)) {
                                if ($this->paystar->getPaidAmount() * 1 === $transaction_amount_rial * 1) {
                                    $detail = [
                                        'card_number' => $card_number,
                                        'transaction_id' => $paystar_transaction_id,
                                    ];
                                    $this->verifiedTransaction($transaction, $tracking_code, json_encode($detail));
                                } else {
                                    $error_message = $this->get_error('price');
                                }
                            } else {
                                $error_message = $this->paystar->getError();
                            }
                        } else {
                            $error_message = $this->paystar->codeError($status);
                        }
                    }
                } elseif($status){
                    $error_message = $this->paystar->codeError($status);
                } else {
                    $error_message = $this->get_error('imperfect');
                }
            }

            // Starshop
            else if ($gateway == 'starshop') {
                $this->load->library('starshop');

                $status = $this->input->get('status');
                $transaction_id = intval($this->input->get('order_id'));
                $authority = $this->input->get('ref_num');

                if ($transaction_id && $authority) {

                    $where = [
                        'authority' => $authority,
                        'gateway' => $gateway,
                        'id' => $transaction_id
                    ];
                    $transaction = $this->transactions_m->get_by(NULL, $where, TRUE);
                    if ($transaction) {
                        if($transaction->completed == 1){
                            $this->completedTransaction($transaction);
                        } 

                        if($status === '1'){
                            $starshop_transaction_id = $this->input->get('transaction_id');
                            $card_number = $this->input->get('card_number');
                            $tracking_code = $this->input->get('tracking_code');
                            $transaction_amount_rial = $transaction->amount * 10;
                            if ($this->starshop->verify($gateway_row->token, $transaction_amount_rial, $authority, $card_number, $tracking_code)) {
                                // if ($this->starshop->getPaidAmount() * 1 === $transaction_amount_rial * 1) {
                                    $detail = [
                                        'card_number' => $card_number,
                                        'transaction_id' => $starshop_transaction_id,
                                    ];
                                    $this->verifiedTransaction($transaction, $tracking_code, json_encode($detail));
                                // } else {
                                //     $error_message = $this->get_error('price');
                                // }
                            } else {
                                $error_message = $this->starshop->getError();
                            }
                        } else {
                            $error_message = $this->starshop->codeError($status);
                        }
                    }
                } elseif($status){
                    $error_message = $this->starshop->codeError($status);
                } else {
                    $error_message = $this->get_error('imperfect');
                }
            }

            // Directpay
            else if ($gateway == 'directpay') {
                $this->load->library('directpay');

                $status = $this->input->get('status');
                $transaction_id = intval($this->input->get('order_id'));
                $authority = $this->input->get('ref_num');

                if ($transaction_id && $authority) {

                    $where = [
                        'authority' => $authority,
                        'gateway' => $gateway,
                        'id' => $transaction_id
                    ];
                    $transaction = $this->transactions_m->get_by(NULL, $where, TRUE);
                    if ($transaction) {
                        if($transaction->completed == 1){
                            $this->completedTransaction($transaction);
                        } 

                        if($status === '1'){
                            $directpay_transaction_id = $this->input->get('transaction_id');
                            $card_number = $this->input->get('card_number');
                            $tracking_code = $this->input->get('tracking_code');
                            $transaction_amount_rial = $transaction->amount * 10;
                            if ($this->directpay->verify($gateway_row->token, $transaction_amount_rial, $authority, $card_number, $tracking_code)) {
                                if ($this->directpay->getPaidAmount() * 1 >= $transaction_amount_rial * 1) {
                                    $detail = [
                                        'card_number' => $card_number,
                                        'transaction_id' => $directpay_transaction_id,
                                    ];
                                    $this->verifiedTransaction($transaction, $tracking_code, json_encode($detail));
                                } else {
                                    $error_message = $this->get_error('price');
                                }
                            } else {
                                $error_message = $this->directpay->getError();
                            }
                        } else {
                            $error_message = $this->directpay->codeError($status);
                        }
                    }
                } elseif($status){
                    $error_message = $this->directpay->codeError($status);
                } else {
                    $error_message = $this->get_error('imperfect');
                }
            }

            // Novinpal
            else if ($gateway == 'novinpal') {
                $this->load->library('novinpal');
                $transaction_id = intval($this->input->get('invoiceNumber'));
                $authority = $this->input->get('refId');
                $amount = $this->input->get('amount'); // به کارمزد تراکنش در سمت مشتری یا سایت بستگی دارد
                $is_success = intval($this->input->get('success'));
                $code = intval($this->input->get('code'));
                
                if ($is_success && $code == 100 && $transaction_id && $authority && is_numeric($amount)) {
                    $where = [
                        'authority' => $authority,
                        'gateway' => $gateway,
                        'id' => $transaction_id
                    ];
                    $transaction = $this->transactions_m->get_by(NULL, $where, TRUE);
                    if ($transaction) {
                        if($transaction->completed == 1){
                            $this->completedTransaction($transaction);
                        } 
                        if ($this->novinpal->verify($gateway_row->token, $transaction->authority)) {
                            // میزان پرداختی به اینکه کارمزد تراکنش در کدام سمت تنظیم شده بستگی دارد
                            if ($this->novinpal->get_paid_amount() * 1 >= $transaction->amount * 10) {
                                if($this->novinpal->get_order_id() == $transaction->id){
                                    $detail = ['card_number' => $this->novinpal->get_card_number()];
                                    $this->verifiedTransaction($transaction, $this->novinpal->get_ref_id(), json_encode($detail));
                                }
                            } else {
                                $error_message = $this->get_error('price');
                            }
                        } else {
                            $error_message = $this->novinpal->get_error();
                        }
                    }
                } else {
                    if($code){
                        $error_message = $this->novinpal->code_error($code);
                    }else{
                        $error_message = $this->get_error('imperfect');
                    }
                }
            }

            // MixPay
            else if ($gateway == 'mixpay') {
                $validIps = ['52.198.117.57'];
                if (1 || in_array($_SERVER['REMOTE_ADDR'], $validIps)) {
                    $this->load->library('mixpay');
                    $orderTrackId = $this->input->get('tranId');
                    $transaction_id = intval($orderTrackId);// اولش  احتمالا صفرهای اضافه داره
                    if ($transaction_id) {
                        $where = [
                            'gateway' => $gateway,
                            'id' => $transaction_id
                        ];
                        $transaction = $this->transactions_m->get_by(NULL, $where, TRUE);
                        if ($transaction) {
                            if($transaction->completed == 1){
                                $this->completedTransaction($transaction);
                            }else{
                                $verify_result = $this->mixpay->verify($gateway_row->token, $orderTrackId);
                                if ($verify_result) {
                                    //  مبلغ و واحد مالی هم باید یکبار دیگه چک بشه، قانون اینه که مبلغ مساوی و بزرگتر تاییده
                                    if ($verify_result['data']['quoteAssetId'] == 'usd' && floatval($verify_result['data']['quoteAmount']) >= $transaction->amount_dollar) {
                                        $this->verifiedTransaction($transaction, $verify_result['data']['txid'], json_encode($verify_result));
                                    } else {
                                        $error_message = $this->get_error('price');
                                    }
                                } else {
                                    $error_message = $this->mixpay->getError();
                                }
                            }
                        }
                    } else {
                        $error_message = $this->get_error('imperfect');
                    }
                }else{
                    $error_message = $this->get_error('ip');
                }
            }

            // Oxapay
            else if ($gateway == 'oxapay') {
                if ($this->input->get('transaction_id')) {
                    $this->load->library('oxapay');
                    $transaction_id = $this->security->xss_clean($this->input->get('transaction_id'));
                    if($transaction_id){
                        $where = [
                            'id' => $transaction_id,
                            'gateway' => $gateway
                        ];
                        $transaction = $this->transactions_m->get_by(NULL, $where, true);
                        if ($transaction) {
                            if($transaction->completed == 1){
                                $this->completedTransaction($transaction);
                            }else{
                                $verify_result = $this->oxapay->verify($gateway_row->token, $transaction->authority);
                                if ($verify_result) {
                                    if(isset($verify_result->data->status, $verify_result->data->amount, $verify_result->data->currency)){
                                        if($verify_result->data->status == 'paid' && floatval($verify_result->data->amount) >= $transaction->amount_dollar && strtoupper($verify_result->data->currency) == 'USD'){
                                            //  مبلغ هم باید یکبار دیگه چک بشه، قانون اینه که مبلغ مساوی و بزرگتر تاییده
                                            $this->verifiedTransaction($transaction, ($verify_result->txs->tx_hash ?? 'sandbox'), json_encode($verify_result));
                                        }else{
                                            $error_message = $this->get_error('price');
                                        }
                                    }else{
                                        $error_message = $this->get_error('imperfect');
                                    }
                                } else {
                                    $error_message = $this->get_error('unsuccessful');
                                }
                            }
                        }
                    }else{
                        $error_message = 'خطای سیستمی';
                    }
                } else {
                    $error_message = $this->get_error('imperfect');
                }
            }
        } 
        
        // Not found gateway
        else {
            $error_message = 'درگاه یافت نشد!';
        }

        if (!isset($this->data['transaction'])) {
            // در صورتی که عملیات پرداخت ناموفق بود کارت ها را آزاد کن
            if(isset($transaction) && $transaction && $transaction->order_id){
                $this->setCardsAccess($transaction->order_id);
            }

            // اگر تراکنش انجام نشده بود و پیام خطایی نداشتیم
            if(!isset($error_message) || (isset($error_message) && $error_message == '')){
                $error_message = $this->get_error('unsuccessful');
            }

            $this->data['error_message'] = $error_message;
        }



        //css
        // $css = array();
        // array_push($css, 'assets/plugins/noty/css/flat.css');
        // $this->data['css'] = $css;

        //js
        // $js = array();
        // array_push($js, 'assets/plugins/noty/js/noty/packaged/jquery.noty.packaged.min.js');
        // $this->data['js'] = $js;

        $this->data['content'] = 'pay/result';
        $this->load->view('_layout_main', $this->data);
    }

    // تراکنش قبلا تایید شده است
    private function completedTransaction($transaction){
        if($transaction->order_id){
            redirect('cards');
        } 
        redirect('transactions');
    }

    // تراکنش صحیح است و باید عملیات بعد از درگاه صورت بگیرد
    private function verifiedTransaction($transaction, $reference, $detail = null){

        // Update transaction
        $data = [
            'reference' => $reference, 
            'completed' => '1',
        ];
        if($detail){
            $data['detail'] = $detail;
        }
        $this->transactions_m->save($data, $transaction->id);

        $transaction->reference = $reference;
        $transaction->completed = 1;
        
        if($transaction->order_id){
            $order = $this->orders_m->get_by(null, ['id' => $transaction->order_id, 'paid' => 0, 'card2card' => ''], true);
            if ($order) {
                if ($this->checkCouponAgain($order)) {
                    if ($this->checkOrderCardsAgain($order->id)) {

                        $pay_result = $this->transactions_m->payOrderWithWallet($order->id, $this->user_login, $transaction);
                        if($pay_result->success){
                            if(isset($pay_result->new_credit)){
                                $this->user_login->credit = $pay_result->new_credit;
                                $this->data['user_login']->credit = $pay_result->new_credit;
                            }
                            $this->finishOrder($order);
                        } else {
                            if(isset($pay_result->not_enough_credit)){
                                // کارت ها را آزاد کن
                                $this->setCardsAccess($order->id);
                                $unpaid_order_error = 'موجودی شما برای پرداخت  فاکتور کافی نبود.';
                            } else {
                                $unpaid_order_error = $pay_result->error;
                            }
                        }
                        
                    } else {
                        $unpaid_order_error = $this->get_error('expire');
                    }
                } else {
                    $unpaid_order_error = $this->get_error('coupon');
                }
            } else {
                $unpaid_order_error = 'فاکتور یافت نشد!';
            }
        }

        $this->data['transaction'] = $transaction;
        if(isset($unpaid_order_error)){
            $this->data['unpaid_order_error'] = $unpaid_order_error;
        }
    }


    private function finishOrder($order)
    {
        // کارت ها را بعنوان فروخته شده علامت بزن
        $card_ids = $this->markCards($order->id);
        $cards = $this->cards_m->getCardsInfo($card_ids);

        // Get category fields
        $category_id = $cards[0]->category_id;
        $where = array('id' => $category_id);
        $category_fileds = $this->categories_m->get_by('field1_title, field2_title, field3_title', $where, true);

        //ارسال اطلاعات سفارش و کد پیگیری
        $this->data['category_fields'] = $category_fileds;
        $this->data['order'] = $order;
        $this->data['cards'] = $cards;

        $auth_call_required = false; 
        if($this->checkActiveAuthCall()){
            if($this->user_login && !$this->user_login->auth_call){
                $auth_call_required = true;
            } elseif(!$this->user_login) {
                $user = $this->users_m->get_by('auth_call', ['id', $order->user_id], true);
                if(!$user->auth_call){
                    $auth_call_required = true;
                }
            }
        }

        $this->data['auth_call_required'] = $auth_call_required;

        // Send SMS
        $this->sendSms($order, $cards, $category_fileds, $auth_call_required);

        // Send email
        if ($order->email) {
            try {
                $this->sendEmail($order, $cards, $category_fileds, $auth_call_required);
            } catch (Exception $ex) {
                $this->data['error_send_email'] = $ex->getMessage();
            }
        }

        // آپدیت کردن سشن جاری
        $count = intval($this->session->userdata('user_submit_count'));
        $count = ($count > 0) ? $count - 1 : 0;
        $this->session->set_userdata('user_submit_count', $count);
    }

    // Check card(s) again before gateway final verify
    private function checkOrderCardsAgain($order_id)
    {
        // کارت ها را دوباره چک کن که همگی قابل فروش باشند
        $this->load->model('order_cards_m');
        $this->load->model('cards_m');

        $cards_list = $this->order_cards_m->get_by('card_id', array('order_id' => $order_id));
        if($cards_list){
            $cards_list = array_map(function ($element) {
                return $element->card_id;
            }, $cards_list);
            $cards_list_str = implode(',', $cards_list);
            $cards = $this->cards_m->get_by('id, sold, publish', array("id in ($cards_list_str)" => null));
    
            if ($cards) {
                foreach ($cards as $card) {
                    if ($card->sold == 1 || $card->publish == 0) {
                        return false;
                    }
                }
                return true;
            }
        }
        return false;
    }

    private function sendEmail($order, $cards, $category_fileds, $auth_call_required)
    {

        $email = $order->email;

        $subject = 'فاکتور';
        $arguments = array(
            'order' => $order,
            'order_cards' => $cards,
            'category_fileds' => $category_fileds
        );
        $message = $this->load->view('email/invoice', $arguments, true);
        $admin_email = ($this->settings->send_admin_invoice) ? $this->settings->admin_email : null;

        if($auth_call_required){
            // فقط برای ادمین ارسال میشه
            if($admin_email){
                $this->frontend_general->sendEmail($admin_email, $message, null, $subject, $this->settings->site_name,  $this->settings->site_name_en, $this->settings->logo, null);
            }
        } else {
            $this->frontend_general->sendEmail($email, $message, null, $subject, $this->settings->site_name,  $this->settings->site_name_en, $this->settings->logo, null, $admin_email);
        }
    }

    private function sendSms($order, $cards, $category_fileds, $auth_call_required)
    {
        $settings = $this->settings_m->getSettings([
            'sms', 
            'notification_cell_phone', 
            'site_name',
        ]);
        $settings->sms = json_decode($settings->sms);
        if($settings->sms->active && $settings->sms->api_key){
            $this->load->library($settings->sms->active, null, 'sms');
            if($order->cell_phone && $settings->sms->after_buy != 'no' && !$order->pending && !$auth_call_required){
                if($settings->sms->after_buy == 'codes'){
                    // باید کد ها یا رمز ها یا سریال ها را برای کاربر پیامک کنیم
                    $message = "خرید شما با موفقیت انجام شد.";
                    $card_number = 1;
                    foreach ($cards as $card) {
                        $message .= "\n";
                        if (count($cards) > 1) {
                            $message .= $card_number . ". ";
                        }
                        $message .= "$category_fileds->field1_title" . ": " . $card->code;
                        if ($card->code2)
                            $message .= "\n" . "$category_fileds->field2_title" . ": " . $card->code2;
                        if ($card->code3)
                            $message .= "\n" . "$category_fileds->field3_title" . ": " . $card->code3;
                        $card_number++;
                    }
                    $sms_status = $this->sms->send($settings->sms->api_key, $settings->sms->from, $order->cell_phone, $message);
    
                } elseif($settings->sms->after_buy == 'successful') {
                    // پیام موفقیت آمیز برای کاربر باید ارسال کنیم
                    if($settings->sms->patterns->successful_buy){
                        // چون الگو را وارد کرده با الگو ارسال می کنیم
                        $sms_status = $this->sms->send_by_token($settings->sms->api_key, $settings->sms->from, $order->cell_phone, $settings->sms->patterns->successful_buy, $order->tracking_code);
                    } else {
                        // الگو را وارد نکرده بنابراین به صورت عادی ارسال می کنیم
                        $message = "از خرید شما متشکریم. لینک مشاهده خرید شما:";
                        $message .= "\n" . base_url("buy/" . $order->tracking_code);
                        $message .= "\n" . $settings->site_name;
                        $sms_status = $this->sms->send($settings->sms->api_key, $settings->sms->from, $order->cell_phone, $message);
                    }
                }
            }

            // حالا بریم سراغ ادمین
            if($order->pending && $settings->notification_cell_phone){
                if($settings->sms->patterns->notify_sale_admin){
                    // چون الگو را وارد کرده با الگو ارسال می کنیم
                    $sms_status = $this->sms->send_by_token($settings->sms->api_key, $settings->sms->from, $settings->notification_cell_phone, $settings->sms->patterns->notify_sale_admin, $order->tracking_code);
                } else {
                    // الگو را وارد نکرده بنابراین به صورت عادی ارسال می کنیم
                    $message = "یک خرید در انتظار تایید شماست.";
                    $message .= "\n" . "شماره پیگیری: " . $order->tracking_code;
                    $message .= "\n" . $settings->site_name;
                    $sms_status = $this->sms->send($settings->sms->api_key, $settings->sms->from, $settings->notification_cell_phone, $message);
                }
            }
        }
    }

    // علامت گذاری کارت ها بعنوان فروخته شده
    private function markCards($order_id)
    {
        $this->load->model('order_cards_m');
        $this->load->model('cards_m');
        $cards = $this->order_cards_m->get_by('card_id', array('order_id' => $order_id));
        $cards_data = array();
        foreach ($cards as $card) {
            $cards_data[] = array('id' => $card->card_id, 'sold' => 1, 'deactive_date' => '');
        }
        $this->cards_m->update_batch($cards_data, 'id');

        return array_map(function ($element) {
            return $element->card_id;
        }, $cards);
    }

    // کارت های خرید های ناموفق را آزاد می کند
    private function setCardsAccess($order_id)
    {
        $this->load->model('cards_m');
        $this->load->model('order_cards_m');
        $cards = $this->order_cards_m->get_by('card_id', array('order_id' => $order_id));
        foreach ($cards as $card) {
            $card_data = array('deactive_date' => '');
            $this->cards_m->save($card_data, $card->card_id);
        }
    }

    // کوپن تخفیف را چک می کنیم که از زمان ثبت فاکتور تا الان قابل استفاده باشد
    private function checkCouponAgain($order)
    {
        if ($order->coupon_id == 0) {
            return true;
        }

        $this->load->model('coupons_m');
        $coupon = $this->coupons_m->get_by('code', ['id' => $order->coupon_id], true);
        if (!$coupon) {
            return false;
        }

        $res_status_coupon = $this->checkCoupon($coupon->code, $order->email, $order->cell_phone);
        if ($res_status_coupon->condition) {
            return true;
        } else {
            return false;
        }
    }

    private function get_error($key){
        switch ($key) {
            case 'expire':
                $message = 'در فاصله زمانی ثبت سفارش و پرداخت شما موجودی این محصول به پایان رسید. در صورتی که وجهی از حساب شما کم شده باشد ظرف 72 ساعت به حساب شما باز خواهد گشت، در صورتی که وجه موردنظر پس از زمان مذکور به حساب شما بازنگشت از طریق صفحه تماس با ما به مدیر سایت اطلاع بدهید.';
                break;
            case 'coupon':
                $message = 'کوپن تخفیفی که استفاده کردید دیگر قابل استفاده نیست. بنابراین امکان پرداخت وجود ندارد.';
                break;
            case 'cancel':
                $message = 'ظاهرا از پرداخت انصراف  داده اید';
                break;
            case 'connection':
                $message = 'خطای غیر متداولی در ارتباط به درگاه پرداخت رخ داده است، ابتدا ارتباط خود را با اینترنت بررسی نمایید در صورت متصل بودن، مشکل را با مدیر سایت مطرح کنید.';                
                break;
            case 'unsuccessful':
                $message = 'عملیات پرداخت نا موفق بود.';
                break;
            case 'imperfect':
                $message = 'عملیات ناتمام، داده های ارسالی ناقص است.';
                break;
            case 'price':
                $message = 'مبلغ ارسالی و دریافتی تطابق ندارد.';
                break;
            case 'dollar':
                $message = 'خطا در نرخ تبدیل درگاه پرداخت ارزی';
                break;
            case 'dollar_min':
                $message = 'مبلغ سفارش شما کمتر از حداقل تعین شده برای درگاه پرداخت ارزی می باشد، بنابراین امکان پرداخت وجود ندارد.';
                break;
            case 'ip':
                $message = 'خطای امنیتی در  ip سرور';
                break;
            default:
                $message = 'عملیات پرداخت نا موفق بود.';
                break;
        }

        return $message;
    }
}
