<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Tickets extends Frontend_Controller
{

    function __construct()
    {
        parent::__construct();

        if (!$this->user_login) {
            $this->session->set_userdata('last_page', base_url("/tickets"));
            redirect('login');
        }

        $this->load->model('tickets_m');
        $this->load->model('messages_m');
    }

    function index()
    {
        $this->data['meta_title'] = 'پشتیبانی';

        //تعداد کل تراکنش های این کاربر
        $count_items = $this->tickets_m->getUserTickets($this->user_login->id, null, null, true);


        //========================BEGIN pagination ========================
        $this->load->library('pagination');

        $config['base_url'] = base_url('/tickets');

        $config['total_rows'] = $count_items;

        // The number of items you intend to show per page
        $config['per_page'] = '10';

        //The number of "digit" links you would like before and after the selected page number
        $config['num_links'] = '5';


        $config['full_tag_open'] = '<ul class="pagination pagination-info">';
        $config['full_tag_close'] = '</ul>';

        $config['first_link'] = 'ابتدا';
        $config['first_tag_open'] = '<li>';
        $config['first_tag_close'] = '</li>';


        $config['last_link'] = 'انتها';
        $config['last_tag_open'] = '<li>';
        $config['last_tag_close'] = '</li>';

        $config['next_link'] = '<i class="fa fa-angle-left"></i>';
        $config['next_tag_open'] = '<li>';
        $config['next_tag_close'] = '</li>';

        $config['prev_link'] = '<i class="fa fa-angle-right"></i>';
        $config['prev_tag_open'] = '<li>';
        $config['prev_tag_close'] = '</li>';

        $config['cur_tag_open'] = '<li class="active"><a>';
        $config['cur_tag_close'] = '</a></li>';

        $config['num_tag_open'] = '<li>';
        $config['num_tag_close'] = '</li>';

        $this->pagination->initialize($config);
        //========================END pagination ========================
        //به دست آوردن تراکنش ها
        $offset = (int) $this->uri->segment(2);
        $limit = $config['per_page'];
        $tickets = $this->tickets_m->getUserTickets($this->user_login->id, $offset, $limit, false);
        if($tickets){
            $this->load->library('pdate');
            foreach ($tickets as $item) {
                $item->created = $this->pdate->date("j F Y H:i", strtotime($item->created));
            }
        }
        $this->data['tickets'] = $tickets;

        // Canonical
        $this->data['canonical'] = base_url("tickets");

        $this->data['content'] = 'ticket/index';
        $this->load->view('_layout_main', $this->data);
    }

    // Add
    function add($id = null)
    {
        $this->load->model('categories_m');

        $this->data['meta_title'] = 'پشتیبانی';
        $this->data['breadcrumb'] = array('پشتیبانی');

        $ticket_setting = json_decode($this->settings_m->getSingle('ticket'));
        $allowed_file_types = isset($ticket_setting->allowed_user_files) ? $ticket_setting->allowed_user_files : [];

        $submit = $this->input->post('submit');
        if ($submit) {
            // ابتدا چک می کنیم در ۱۰ دقیقه اخیر چند تیکت را ثبت کرده است
            $last_time = date('Y-m-d H:i:s', strtotime(' -10 minutes'));
            $number = $this->tickets_m->get_by('COUNT(id) AS number', array('user_id' => $this->user_login->id, 'created >' => $last_time), true)->number * 1;
            if ($number >= 10) {
                $this->data['message_danger'] = 'شما در دقایق گذشته درخواست داده اید، لطفا چند دقیقه دیگر درخواست جدید دهید.';
            } else {
                $this->form_validation->set_rules('title', 'عنوان', "trim|required");
                $this->form_validation->set_rules('category_id', 'بخش', "trim|required|integer");
                $this->form_validation->set_rules('priority', 'فوریت', "trim|required|in_list[low,normal,high]");
                $this->form_validation->set_rules('text', 'متن', "trim|required");

                $this->form_validation->set_message('required', 'وارد کردن فیلد %s الزامی است');
                $this->form_validation->set_message('integer', 'لطفا %s را صحیح انتخاب کنید');
                $this->form_validation->set_message('in_list', 'لطفا %s را صحیح انتخاب کنید');

                if ($this->form_validation->run() != FALSE) {
                    //Check category
                    $category_id = intval($this->input->post('category_id'));
                    $category = $this->categories_m->get_by('id', array('id' => $category_id, 'type' => 'ticket', 'deleted' => 0, 'publish' => 1), false, 'ordering, id');
                    if (!$category) {
                        $this->data['message_danger'] = 'لطفا بخش را انتخاب کنید.';
                    } else {
                        $data = array(
                            'user_id' => $this->user_login->id,
                            'category_id' => $category_id,
                            'status' => 'open',
                            'title' => $this->security->xss_clean($this->input->post('title')),
                            'priority' => $this->input->post('priority'),
                            'updated' => date('Y-m-d H:i:s'),
                        );
    
                        $id = $this->tickets_m->save($data);
                        if ($id) {
                            // Save first message
                            $data = array(
                                'ticket_id' => $id,
                                'user_id' => $this->user_login->id,
                                'text' => $this->security->xss_clean($this->input->post('text')),
                                'reading' => 0,
                            );

                            // Attach
                            if($allowed_file_types){
                                $upload_result = $this->uploadFile('attach', $allowed_file_types);
                                if ($upload_result->condition) {
                                    $data['attach'] = $upload_result->file_path;
                                }
                            }

                            $message_id = $this->messages_m->save($data);
                            $this->tickets_m->updateUnreadAndLastMessage($id, 'admin');

                            if(isset($upload_result->error)){
                                $this->session->set_flashdata('frontend_error', 'تیکت شما ثبت گردید اما فایل پیوست دارای خطا بود:' . $upload_result->error);
                            } else {
                                $this->session->set_flashdata('frontend_success', 'تیکت شما ثبت گردید.');
                            }
                            redirect('tickets');
                        } else{
                            $this->data['message_danger'] = 'خطای سیستمی رخ داده است.';
                        }
                    }
                } else {
                    $this->data['message_danger'] = validation_errors();
                }
            }
        }

        $this->data['allowed_file_types'] = $allowed_file_types;
        $this->data['categories'] = $this->categories_m->get_by('id, title_fa AS title', array('type' => 'ticket', 'deleted' => 0, 'publish' => 1), false, 'ordering, id');

        // Canonical
        $this->data['canonical'] = base_url("tickets/add");

        $this->data['content'] = 'ticket/add';
        $this->load->view('_layout_main', $this->data);
    }

    function messages($ticket_id = null)
    {

        $this->data['meta_title'] = 'پشتیبانی';

        $ticket_id = intval($ticket_id);
        $ticket = $this->tickets_m->get_by(null, array('id' => $ticket_id, 'user_id' => $this->user_login->id), true);
        if (!$ticket) {
            redirect('tickets');
        }
        $this->data['ticket'] = $ticket;

        // Settings
        $page_settings = $this->settings_m->getSettings(['ticket', 'profile_image']);
        $this->settings->ticket = json_decode($page_settings->ticket);
        $this->settings->profile_image = $page_settings->profile_image;
        $this->data['settings'] = $this->settings;

        $allowed_file_types = isset($this->settings->ticket->allowed_user_files) ? $this->settings->ticket->allowed_user_files : [];
        $this->data['allowed_file_types'] = $allowed_file_types;

        //به دست آوردن تمام پیام های این تیکت
        $messages = $this->tickets_m->getMessages($ticket_id);
        $this->data['messages'] = $messages;
        $this->load->library('pdate');
        if ($messages) {
            // User profile image
            $default_ptofile_image = $this->settings->profile_image;
            if($this->user_login->image && file_exists($this->user_login->image)){
                $customer_image = $this->user_login->image;
            } else if($default_ptofile_image && file_exists($default_ptofile_image)){
                $customer_image = $default_ptofile_image;
            } else {
                $customer_image = 'assets/admin/images/user/avatar128.png';
            }

            $admin_images = [];
            
            $first_message_unread = true;
            foreach ($messages as $key => $message) {
                $message->created = $this->pdate->date('j ام F، H:i', strtotime($message->created));

                // Image
                if($message->user_id == $ticket->user_id){
                    $messages[$key]->user_image = $customer_image;
                } else {
                    if(!isset($admin_images[$message->user_id])){
                        if($message->user_image && file_exists($message->user_image)){
                            $admin_image = $message->user_image;
                        } else {
                            $admin_image = 'assets/admin/images/user/avatar128.png';
                        }
                        $admin_images[$message->user_id] = $admin_image;
                    }
                    $messages[$key]->user_image = $admin_images[$message->user_id];
                }

                //پیدا کردن اولین پیامی که خوانده نشده است
                if ($first_message_unread && $message->reading == '0' && $message->user_id != $this->user_login->id) {
                    $this->data['first_message_unread'] = $message->id;
                    $first_message_unread = false;
                }
            }
        }

        //پیام های که مدیر به کاربر در این تیکت فرستاده است را به وضعیت خوانده شده تغییر می دهیم
        $this->messages_m->update_by(array('reading' => 1), array('reading' => '0', 'ticket_id' => $ticket_id, 'user_id <>' => $this->user_login->id));
        $this->tickets_m->updateUnreadAndLastMessage($ticket_id, 'customer');

        //تعداد پیام های خوانده نشده 
        $this->data['number_of_message'] = $this->tickets_m->getUnreadMessagesByUser($this->user_login->id);

        //css
        $css = array();
        array_push($css, 'assets/plugins/sweetalert2/dist/sweetalert2.min.css');
        $this->data['css'] = $css;

        //js
        $js = array();
        array_push($js, 'assets/plugins/sweetalert2/dist/sweetalert2.min.js');
        $this->data['js'] = $js;

        $this->data['content'] = 'ticket/messages';
        $this->load->view('_layout_main', $this->data);
    }

    //ذخیره پیام
    function messageSave()
    {
        $result = new stdClass();
        $result->condition = false;
        $result->msg = 'خطای سیستمی';
        $result->csrf = $this->security->get_csrf_hash();

        //ابتدا چک میکنیم که تیکت مربوط به کاربر لاگین شده باشد
        $ticket_id = intval($this->input->post('ticket_id'));
        $ticket = $this->tickets_m->get_by(null, array('id' => $ticket_id, 'user_id' => $this->user_login->id), true);
        if (!$ticket) {
            $result->msg = 'عدم دسترسی';
            echo json_encode($result);
            die();
        }

        // Settings
        $ticket_setting = json_decode($this->settings_m->getSingle('ticket'));
        if($ticket->status == 'close' && !$ticket_setting->allow_send_after_close){
            $result->msg = 'تیکت بسته شده است، لطفا تیکت جدیدی ثبت کنید.';
            echo json_encode($result);
            die();
        }

        // چک میکنیم که چه تعداد پیام در دقیقه پیش ارسال شده است
        $minute = date('i');
        $where = array(
            'user_id' => $this->user_login->id,
            'created >=' => date("Y-m-d H:$minute:00"),
            'created <=' => date("Y-m-d H:$minute:59")
        );
        $number = $this->messages_m->get_by('count(id) as number', $where, true)->number * 1;
        if ($number >= 3) {
            $result->msg = 'شما در هر یک دقیقه فقط می توانید سه پیام ارسال کنید.';
            echo json_encode($result);
            die();
        }

        $this->form_validation->set_rules('text', 'متن پیام', 'trim|required');
        $this->form_validation->set_message('required', 'وارد کردن فیلد %s الزامی است');
        if ($this->form_validation->run() != FALSE) {

            $data = array(
                'ticket_id' => $ticket_id,
                'user_id' => $this->user_login->id,
                'text' => $this->security->xss_clean($this->input->post('text')),
                'reading' => 0,
            );

            // Attach
            $allowed_file_types = isset($ticket_setting->allowed_user_files) ? $ticket_setting->allowed_user_files : [];
            if($allowed_file_types){
                $upload_result = $this->uploadFile('attach', $allowed_file_types);
                if ($upload_result->condition) {
                    $data['attach'] = $upload_result->file_path;
                }
            }

            $id = $this->messages_m->save($data);
            if ($id) {
                $this->tickets_m->update(['updated' => date('Y-m-d H:i:s')], $ticket_id);
                $this->tickets_m->updateUnreadAndLastMessage($ticket_id, 'admin');

                // اگر تیکت بسته بود بازش می کنیم
                if($ticket->status == 'close'){
                    $this->tickets_m->save(['status' => 'open'], $ticket_id);
                }

                $result->msg = '';
                if(isset($upload_result->error)){
                    $this->session->set_flashdata('frontend_error', 'پیام شما ثبت گردید اما فایل پیوست دارای خطا بود:' . $upload_result->error);
                } else {
                    $this->session->set_flashdata('frontend_success', 'پیام شما ثبت گردید.');
                }
                $result->condition = true;
                $result->url = base_url("tickets/messages/$ticket_id");
            }
        } else {
            $result->msg = validation_errors();
        }

        echo json_encode($result);
    }


    public function close()
    {
        $result = new stdClass();
        $result->condition = false;
        $result->msg = 'عدم دسترسی';
        $result->csrf = $this->security->get_csrf_hash();

        //ابتدا چک میکنیم که تیکت مربوط به کاربر لاگین شده باشد
        $ticket_id = intval($this->input->post('ticket_id'));
        $ticket = $this->tickets_m->get_by(null, array('id' => $ticket_id, 'user_id' => $this->user_login->id), true);
        if (!$ticket) {
            echo json_encode($result);
            die();
        }

        if($ticket->status == 'close'){
            $result->msg = 'این تیکت قبلا بسته شده است.';
            echo json_encode($result);
            die();
        }

        // Settings
        $ticket_setting = json_decode($this->settings_m->getSingle('ticket'));
        if(!$ticket_setting->allow_close){
            echo json_encode($result);
            die();
        }


       
        $this->tickets_m->save(['status' => 'close'], $ticket->id);

        // $result->msg = 'تیکت با موفقیت بسته شد.';
        // $this->session->set_flashdata('frontend_success', $result->msg);
        $result->condition = true;
        $result->url = base_url("tickets");
        
        echo json_encode($result);
    }

    private function uploadFile($name, $allowed_file_types = [])
    {
        $result = new stdClass();
        $result->condition = FALSE;
        if(!$allowed_file_types){
            return $result;
        }
        if($name && isset($_FILES[$name]) && $_FILES[$name]["size"]) {
            $this->load->library('upload');

            // Check upload path
            $output_dir = "media/tickets/";
            if (!file_exists($output_dir)) {
                mkdir($output_dir, 0755, true);
            }

            $file_extension = pathinfo($_FILES[$name]['name'], PATHINFO_EXTENSION);
            $fileName = date('Ymd-His'). '-' . random_str(5) . '-' . random_str(10) . '.' . $file_extension;
            $config['upload_path'] = $output_dir;
            $config['file_name'] = $fileName;
            $config['allowed_types'] = implode('|', $allowed_file_types);
            $config['max_size'] = 3072; //(in kilobyte) 3 MB = 3072 KB

            $this->upload->initialize($config);

            if (!$this->upload->do_upload($name)) {
                $result->error = $this->upload->display_errors();
            } else {
                $result->condition = TRUE;
                $result->file_name = $fileName;
                $result->file_path = $output_dir . $fileName;
            }
        }
        
        return $result;
    }

    public function download($message_id = null){
        $message_id = intval($message_id);
        $message = $this->messages_m->getDetail($message_id);

        if(!$message){
            redirect('errors/error404');
        }

        if($message->ticket_user_id != $this->user_login->id){
            redirect('errors/error404');
        }

        if(empty($message->attach) || !file_exists($message->attach)){
            redirect('errors/error404');
        }

        $this->load->helper('download');
        force_download($message->attach, NULL);

    }
}