<?php
/**
 * @author Rayanik.com
 */
if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Blocks extends Admin_Controller {

    public function __construct() {
        parent::__construct();

        $this->load->model('blocks_m');
        $this->load->library('pdate');
    }

    public function index() {
        $this->data['breadcrumb'] = array('بلاک هوشمند');

        //css
        $css = array();
        array_push($css, 'assets/plugins/data-table/css/dataTables.bootstrap.css');
        array_push($css, 'assets/plugins/persian-datepicker/css/persian-datepicker.css?1');
        $this->data['css'] = $css;

        //js
        $js = array();
        array_push($js, 'assets/plugins/data-table/js/jquery.dataTables.min.js');
        array_push($js, 'assets/plugins/data-table/js/dataTables.bootstrap.js');
        array_push($js, 'assets/plugins/persian-date/persian-date.js?1');
        array_push($js, 'assets/plugins/persian-datepicker/js/persian-datepicker.js?1');
        $this->data['js'] = $js;

        $this->data['subview'] = 'admin/block/index';
        $this->load->view('admin/_layout_main', $this->data);
    }

    public function view() {
        echo $this->load->view('admin/block/index', $this->data, true);
    }

    public function ajax_list() {
        // Filter Start
        $this->blocks_m->filter = [];

        // Created
        $date_regex = '/^1(3|4)(\d{2})\/(0?[1-9]|1[012])\/(0?[1-9]|[12][0-9]|3[01])$/';

        $from_date = NULL;
        $date = englishNumber($this->input->post('from_date'));
        if (preg_match($date_regex, $date)) {
            [$year, $month, $day] = explode('/', $date);
            $timestamp = $this->pdate->mktime($hour = 0, $minute = 0, $second = 0, $month, $day, $year);
            $from_date = date('Y-m-d H:i:s', $timestamp);
        }

        $to_date = NULL;
        $date = englishNumber($this->input->post('to_date'));
        if (preg_match($date_regex, $date)) {
            [$year, $month, $day] = explode('/', $date);
            $timestamp = $this->pdate->mktime($hour = 23, $minute = 59, $second = 59, $month, $day, $year);
            $to_date = date('Y-m-d H:i:s', $timestamp);
        }

        if($from_date && $to_date){
            $this->blocks_m->filter["created >= "] = $from_date;
            $this->blocks_m->filter["created <= "] = $to_date;
        }elseif ($from_date) {
            $this->blocks_m->filter["created >= "] = $from_date;
        }elseif ($to_date) {
            $this->blocks_m->filter["created <= "] = $to_date;
        }
        // Filter End

        $list = $this->blocks_m->get_datatables();

        $data = array();
        $no = $_POST['start'];
        $base_url = trim(base_url(), '/');
        foreach ($list as $item) {
            // Source
            switch ($item->source) {
                case 'order':
                    $source = 'ثبت سفارش';
                    break;
                case 'profile':
                    $source = 'ویرایش پروفایل';
                    break;
                case 'admin':
                    $source = 'توسط ادمین';
                    break;
                case 'user':
                    $source = 'بلاک شدن کاربر';
                    break;
                default:
                    $source = '';
                    break;
            }
            $no++;
            $row = array();
            $row['row'] = $no;
            $row['username'] = "<a href=\"$base_url/admin/customers/edit/$item->user_id\" target=\"_blank\">$item->username</a>";
            $row['email'] = html_escape($item->email);
            $row['source'] = $source;
            $row['ip'] = $item->ip;
            $row['created'] = $this->pdate->date('Y/m/d H:i', strtotime($item->created));

            $data[] = $row;
        }

        $output = array(
            "draw" => $_POST['draw'],
            "recordsTotal" => $this->blocks_m->count_all(),
            "recordsFiltered" => $this->blocks_m->count_filtered(),
            "data" => $data,
            "csrf" => $this->security->get_csrf_hash()
        );
        //output to json format
        echo json_encode($output);
    }

}
