<?php
/**
 * @author Rayanik.com
 */
if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Categories extends Admin_Controller {

    function __construct() {
        parent::__construct();
        // چک کردن دسترسی با توجه به دسته مورد نظر
        $this->categories = array('video', 'attribute', 'page', 'contact', 'ticket');
        $this->type = $this->uri->segment(4);

        if (!in_array($this->type, $this->categories)) {
            redirect('admin/dashboard');
        }

        // check user permission

        $this->load->model('categories_m');
        $this->load->library('admin_general');
    }

    // load list categories
    function index($type = null) {
        $this->userHasPermission("{$type}_categories");

        //css
        $css = array();
        array_push($css, 'assets/plugins/data-table/css/dataTables.bootstrap.css');
        $this->data['css'] = $css;

        //js
        $js = array();
        array_push($js, 'assets/plugins/data-table/js/jquery.dataTables.min.js');
        array_push($js, 'assets/plugins/data-table/js/dataTables.bootstrap.js');
        $this->data['js'] = $js;


        $persianTitle = $this->admin_general->getTypePersianTitle($type);

        //$this->data['meta_title'] = '';
        $this->data['breadcrumb'] = array('دسته بندی ' . $persianTitle);
        $this->data['sub_title'] = 'دسته بندی ' . $persianTitle;

        $this->data['categories'] = $this->categories_m->get_by(null, array('deleted' => 0, 'type' => $type));
        $this->data['type'] = $type;

        $this->data['subview'] = 'admin/category/index';
        $this->load->view('admin/_layout_main', $this->data);
    }

    function view($type = null) {
        $this->userHasPermission("{$type}_categories", false);

        $persianTitle = $this->admin_general->getTypePersianTitle($type);

        $this->data['sub_title'] = 'دسته بندی ' . $persianTitle;

        $this->data['categories'] = $this->categories_m->get_by(null, array('deleted' => 0, 'type' => $type));
        $this->data['type'] = $type;

        echo $this->load->view('admin/category/index', $this->data, true);
    }

    function delete($type = null, $id = NULL) {
        $data = array(
            'deleted' => '1'
        );
        $result = new stdClass();
        $result->condition = false;
        $result->msg = 'موردی انتخاب نشده است.';

        $this->userHasPermission("{$type}_categories_delete", false, $result);

        $id = intval($id);
        if ($id > 0) {
            // حذف عکس
            $cat = $this->categories_m->get($id, true);
            if ($cat) {
                if($cat->image != '' && file_exists($cat->image)){
                    unlink($cat->image);// حذف از سرور
                }
            }

            $this->categories_m->update($data, $id);
            $result->msg = 'دسته مورد نظر با موفقیت حذف شد.';
            $result->condition = true;
        } else {
            if ($checkb = $this->input->post('list_ids')) {
                $checkb = explode(',', $checkb);
                if (count($checkb)) {
                    foreach ($checkb as $id) {
                        // حذف عکس
                        $cat = $this->categories_m->get($id, true);
                        if ($cat) {
                            if($cat->image != '' && file_exists($cat->image)){
                                unlink($cat->image);// حذف از سرور
                            }
                        }

                        $id = intval($id);
                        $this->categories_m->update($data, $id);
                    }
                    $result->msg = 'دسته های مورد نظر با موفقیت حذف شدند.';
                    $result->condition = true;
                }
            }
        }
        echo json_encode($result);
    }

    // Add and edit
    function edit($type = null, $id = null) {

        $persianTitle = $this->admin_general->getTypePersianTitle($type);

        //$this->data['meta_title'] = '';
        $this->data['breadcrumb'] = array('دسته بندی ' . $persianTitle);

        // check exist
        if ($id != null) {
            $category = $this->categories_m->get($id, true);
            if (!$category)
                $id = null;
        }

        if ($id == null) {
            // add
            $this->userHasPermission("{$type}_categories_add");
            $category = $this->categories_m->getNew();
            $category->type = $type;

            $this->data['category'] = $category;
        } else {
            // edit
            $this->userHasPermission("{$type}_categories_edit");
            $this->data['category'] = $category;
        }

        $this->data['subview'] = 'admin/category/edit';
        $this->load->view('admin/_layout_main', $this->data);
    }

    // save
    function save($category_type = null) {
        $result = new stdClass();
        $result->condition = false;
        $result->msg = 'خطای سیستمی.';

        $id = intval($this->input->post('id'));

        $this->form_validation->set_rules('title', 'عنوان دسته', 'trim|required');
        $this->form_validation->set_rules('ordering', 'ترتیب نمایش', 'numeric|required');
        $this->form_validation->set_message('required', 'وارد کردن فیلد %s الزامی است');

        if ($this->form_validation->run() != FALSE) {
            $data = array(
                'title_fa' => $this->input->post('title'),
                'type' => $category_type,
                'publish' => $this->input->post('publish') == 1 ? 1 : 0,
                'ordering' => intval($this->input->post('ordering')),
            );


            //=========================== Save image ===========================
            $image_result = $this->uploadImage('image');
            if ($image_result->condition) {
                $source_image = $image_result->file_path;
                list($width, $height, $type, $attr) = getimagesize($source_image);

                if ($width != 400 || $height != 300) {
                    //در این حالت نیاز به برش و تغییر اندازه داریم
                    $this->load->library('image_lib');
                    $config['source_image'] = $source_image;
                    $config['new_image'] = $source_image;
                    $config['maintain_ratio'] = FALSE;
                    $config['width'] = 400;
                    $config['height'] = 300;

                    $this->image_lib->set_enlarge(TRUE);
                    $this->image_lib->thumb($config);
                }
                $data['image']= $source_image;
            }

            //edit
            if ($id > 0) {
                $this->userHasPermission("{$category_type}_categories_edit", false, $result);
                $id = $this->categories_m->save($data, $id);
            }
            //add
            else {
                $this->userHasPermission("{$category_type}_categories_add", false, $result);
                $id = $this->categories_m->save($data);
            }
            $result->msg = 'با موفقیت ثبت گردید';
            $this->session->set_flashdata('admin_success', $result->msg);
            $result->condition = true;
            $result->url = base_url("admin/categories/index/$category_type");
        } else {
            $result->msg = validation_errors() ;

        }

        echo json_encode($result);
    }

    function publish($type = NULL, $id = NULL) {
        $data = array(
            'publish' => '1'
        );

        $result = new stdClass();
        $result->condition = false;
        $result->msg = 'موردی انتخاب نشده است.';

        $this->userHasPermission("{$type}_categories_edit", false, $result);

        $id = intval($id);
        if ($id > 0) {
            $this->categories_m->update($data, $id);
            $result->msg = 'دسته مورد نظر با موفقیت در وضعیت انتشار قرار گرفت.';
            $result->condition = true;
        } else {
            if ($checkb = $this->input->post('list_ids')) {
                $checkb = explode(',', $checkb);
                if (count($checkb)) {
                    foreach ($checkb as $id) {
                        $id = intval($id);
                        $this->categories_m->update($data, $id);
                    }
                    $result->msg = 'دسته های مورد نظر با موفقیت در وضعیت انتشار قرار گرفت.';
                    $result->condition = true;
                }
            }
        }

        echo json_encode($result);
    }

    function un_publish($type = NULL, $id = NULL) {
        $data = array(
            'publish' => '0'
        );

        $result = new stdClass();
        $result->condition = false;
        $result->msg = 'موردی انتخاب نشده است.';

        $this->userHasPermission("{$type}_categories_edit", false, $result);

        $id = intval($id);
        if ($id > 0) {
            $this->categories_m->update($data, $id);
            $result->msg = 'دسته مورد نظر با موفقیت در وضعیت عدم انتشار قرار گرفت.';
            $result->condition = true;
        } else {
            if ($checkb = $this->input->post('list_ids')) {
                $checkb = explode(',', $checkb);
                if (count($checkb)) {
                    foreach ($checkb as $id) {
                        $id = intval($id);
                        $this->categories_m->update($data, $id);
                    }
                    $result->msg = 'دسته های مورد نظر با موفقیت در وضعیت عدم انتشار قرار گرفت.';
                    $result->condition = true;
                }
            }
        }
        echo json_encode($result);
    }

    // Upload Image
    private function uploadImage($name = NULL) {
        $result = new stdClass();
        $result->condition = FALSE;
        if ($name) {
            $this->load->library('upload');

            $output_dir = 'media/categories/';
            $file_extension = pathinfo($_FILES[$name]['name'], PATHINFO_EXTENSION);
            $fileName = date('Ymd-His').'-'.rand(1000, 9999).'.'.$file_extension;
            $config['upload_path'] = $output_dir;
            $config['file_name'] = $fileName;
            $config['allowed_types'] = 'gif|jpg|png';
            $config['max_size'] = 5120; //(in kilobyte) 5 MB = 5120 KB


            $this->upload->initialize($config);

               if (!$this->upload->do_upload($name)) {
               $result->error = array('error' => $this->upload->display_errors());
            //if (!move_uploaded_file($_FILES[$name]['tmp_name'], $output_dir.$fileName)) {
            //     $result->error = 'Error in uploading.';
            } else {
                $result->condition = TRUE;
                $result->file_name = $fileName;
                $result->file_path = $output_dir . $fileName;
            }
        }
        return $result;
    }

    //remove image
    public function removeImage($type='', $id = 0) {
        $result = new stdClass();
        $result->condition = FALSE;

        $this->userHasPermission("{$type}_categories_edit", false, $result);

        $id = intval($id);
        if ($id != 0) {
            $cat = $this->categories_m->get($id, TRUE);
            if ($cat) {
                $image = trim($cat->image, '/');
                if ( $image!= '' && file_exists($image) ) {
                    unlink($image);
                    $data = array(
                        'image' => ''
                    );
                    $this->categories_m->save($data, $id);
                }
                $result->condition = TRUE;
            }
        }
        echo json_encode($result);
    }
}
?>
