<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Coupons extends Admin_Controller {

    function __construct() {
        parent::__construct();

        $this->load->model('coupons_m');
        $this->load->model('coupon_products_m');
    }

    // load coupons list
    function index() {
        $this->userHasPermission('coupons');
        $this->data['breadcrumb'] = array('مدیریت کوپن تخفیف');

        //css
        $css = array();
        array_push($css, 'assets/plugins/data-table/css/dataTables.bootstrap.css');
        $this->data['css'] = $css;

        //js
        $js = array();
        array_push($js, 'assets/plugins/data-table/js/jquery.dataTables.min.js');
        array_push($js, 'assets/plugins/data-table/js/dataTables.bootstrap.js');
        $this->data['js'] = $js;


        $this->data['subview'] = 'admin/coupon/index';

        $this->load->view('admin/_layout_main', $this->data);
    }

    function view() {
        $this->userHasPermission('coupons', false);
        echo $this->load->view('admin/coupon/index', $this->data, true);
    }

    public function ajax_list() {
        $this->userHasPermission('coupons', false);

        $list = $this->coupons_m->get_datatables();
        $data = array();
        $no = $_POST['start'];
        $base_url = trim(base_url(), '/');
        foreach ($list as $item) {
            $actions = "";
            if (in_array('coupons_edit', $this->user_permissions)){
                if ($item->publish == 1) {
                    $btn_class = 'success';
                    $title = 'انتشار';
                    $url = "$base_url/admin/coupons/un_publish/$item->id";
                } else {
                    $btn_class = 'danger';
                    $title = 'عدم انتشار';
                    $url = "$base_url/admin/coupons/publish/$item->id";
                }
                $actions .= "<a title=\"ویرایش\" class=\"btn btn-warning btn-round btn-icon has-tooltip\" href=\"$base_url/admin/coupons/edit/$item->id\"><i class=\"icon-pencil\"></i></a>";
                $actions .= "<a title=\"$title\" class=\"btn btn-$btn_class btn-round btn-icon has-tooltip\" href=\"javascript: void(0)\" onclick=\"insert('$url', '#frm-main', '$base_url/admin/coupons/view', '#res', '#msg', false, true, 'noty' )\"><i class=\"icon-eye\"></i></a>";
            }
            
            if (in_array('coupons_delete', $this->user_permissions)){
                $actions .= "<a title=\"حذف\" class=\"btn btn-danger btn-round btn-icon has-tooltip\" href=\"javascript: void(0)\" onclick=\"deleteRow('$base_url/admin/coupons/delete/$item->id','#frm-main','$base_url/admin/coupons/view','#res','delete')\"><i class=\"icon-trash\"></i></a>";
            }

            $no++;
            $row = array();
            $row['checkbox'] = '<input type="checkbox" value="' . $item->id . '">';
            $row['id'] = $item->id;
            $row['row'] = $no;
            $row['title'] = $item->title;
            $row['code'] = $item->code;
            $row['amount'] = ($item->discount_type=='percent') ? $item->amount.'%':  number_format($item->amount).'تومان';
            $row['count'] = $item->count;
            $row['number_used'] = $item->number_used;
            $row['start_date'] = $this->pdate->date('Y/m/d',strtotime($item->start_date));
            $row['end_date'] = $this->pdate->date('Y/m/d',strtotime($item->end_date));
            $row['actions'] = $actions;

            $data[] = $row;
        }

        $output = array(
            "draw" => $_POST['draw'],
            "recordsTotal" => $this->coupons_m->count_all(),
            "recordsFiltered" => $this->coupons_m->count_filtered(),
            "data" => $data,
            "csrf" => $this->security->get_csrf_hash()
        );
        //output to json format
        echo json_encode($output);
    }

    // Add and edit
    function edit($id = null) {
        //$this->data['meta_title'] = '';
        $this->data['breadcrumb'] = array('مدیریت کوپن های تخفیف');

        //css
        $css = array();
        array_push($css, 'assets/plugins/persian-datepicker/css/persian-datepicker.css?1');
        array_push($css, 'assets/plugins/select2/dist/css/select2.min.css');
        $this->data['css'] = $css;

        //js
        $js = array();
        array_push($js, 'assets/plugins/persian-date/persian-date.js?1');
        array_push($js, 'assets/plugins/persian-datepicker/js/persian-datepicker.js?1');
        array_push($js, 'assets/plugins/select2/dist/js/select2.full.min.js');
        array_push($js, 'assets/plugins/select2/dist/js/i18n/fa.js');
        $this->data['js'] = $js;

        // check exist
        if ($id != null) {
            $coupon = $this->coupons_m->get($id, true);
            if (!$coupon)
                $id = null;
        }

        if ($id == null) {
            // add
            $this->userHasPermission('coupons_add');
            $coupon = $this->coupons_m->getNew();
            $this->data['coupon'] = $coupon;
            $this->data['selected_products'] = [];
        } else {
            // edit
            $this->userHasPermission('coupons_edit');
            $this->load->library('pdate');
            $coupon->start_date = date('Y/m/d',strtotime($coupon->start_date));
            $coupon->end_date = date('Y/m/d',strtotime($coupon->end_date));

            $this->data['coupon'] = $coupon;

            //get selected products
            $selected_products = $this->coupon_products_m->get_by('product_id', array('coupon_id' => $id));
            if($selected_products){
                $selected_products = json_decode(json_encode($selected_products), true);
                $selected_products = array_column($selected_products, 'product_id');
            } else {
                $selected_products = [];
            }
            $this->data['selected_products'] = $selected_products;
        }

        //products
        $this->load->model('products_m');
        $this->data['products'] = $this->products_m->getProductsForAdmin();

        $this->data['subview'] = 'admin/coupon/edit';
        $this->load->view('admin/_layout_main', $this->data);
    }

    // save
    function save() {
        $result = new stdClass();
        $result->condition = false;
        $result->msg = 'خطای سیستمی.';
        $result->csrf = $this->security->get_csrf_hash();

        $id = intval($this->input->post('id'));

        $is_unique =  '|is_unique[coupons.code]';
        if($id != 0){
            $original_value = $this->coupons_m->get_by('code',array('id'=>$id),true);
            if($original_value){
                if($original_value->code == $this->input->post('code')) {
                   $is_unique =  '';
                }
            }
        }

        $_POST['amount'] = str_replace(',', '', $this->input->post('amount'));
        $_POST['start_date'] = englishNumber($this->input->post('start_date'));
        $_POST['end_date'] = englishNumber($this->input->post('end_date'));

        $discount_type = $this->input->post('discount_type');
        $less_than_equal_to = ($discount_type == 'percent') ? '|less_than_equal_to[100]' : '';

        $this->form_validation->set_rules('title', 'عنوان', 'trim|required');
        $this->form_validation->set_rules('code', 'کد کوپن', 'trim|required'.$is_unique);
        $this->form_validation->set_rules('discount_type', 'نوع تخفیف', 'trim|required|in_list[percent,price]');
        $this->form_validation->set_rules('amount', 'مقدار', 'trim|required|numeric'.$less_than_equal_to);
        $this->form_validation->set_rules('count', 'تعداد', 'trim|required|numeric');
        $this->form_validation->set_rules('start_date', 'شروع', array('trim', 'required', 'regex_match[/^1(3|4)(\d{2})\/(0?[1-9]|1[012])\/(0?[1-9]|[12][0-9]|3[01])$/]'));
        $this->form_validation->set_rules('end_date', 'پایان', array('trim', 'required', 'regex_match[/^1(3|4)(\d{2})\/(0?[1-9]|1[012])\/(0?[1-9]|[12][0-9]|3[01])$/]'));

        $this->form_validation->set_message('required', 'وارد کردن فیلد %s الزامی است');
        $this->form_validation->set_message('numeric', '%s را به درستی وارد نمائید');
        $this->form_validation->set_message('regex_match', 'لطفا %s را صحیح وارد کنید');
        $this->form_validation->set_message('less_than_equal_to', 'لطفا %s را صحیح وارد کنید');
        $this->form_validation->set_message('in_list', 'لطفا %s را صحیح انتخاب کنید');
        $this->form_validation->set_message('is_unique', 'لطفا %s دیگری را وارد کنید');



        if ($this->form_validation->run() != FALSE) {

            $this->load->library('pdate');
            //start date
            $date_jalali = $this->input->post('start_date');
            $arr = explode('/', $date_jalali);
            if (count($arr) == 3) {
                $month = $arr[1];
                $day = $arr[2];
                $year = $arr[0];
                $stamp = $this->pdate->mktime(0, 0, 0, $month, $day, $year);
                $date_gregorian = $this->pdate->date("Y-m-d", $stamp, false, false);
                $start_date = $date_gregorian;
            }else{
                $start_date = date("Y-m-d");
            }

            //end date
            $date_jalali = $this->input->post('end_date');
            $arr = explode('/', $date_jalali);
            if (count($arr) == 3) {
                $month = $arr[1];
                $day = $arr[2];
                $year = $arr[0];
                $stamp = $this->pdate->mktime(0, 0, 0, $month, $day, $year);
                $date_gregorian = $this->pdate->date("Y-m-d", $stamp, false, false);
                $end_date = $date_gregorian;
            }else{
                $end_date = date("Y-m-d");
            }

            $minimum = str_replace(',', '', $this->input->post('minimum'));

            $data = array(
                'title' => $this->input->post('title'),
                'code' => $this->input->post('code'),
                'amount' => $this->input->post('amount'),
                'discount_type' => $discount_type,
                'minimum' => $minimum,
                'publish' => ($this->input->post('publish') == 1) ? 1 : 0,
                'count' => $this->input->post('count'),
                'start_date' => $start_date,
                'end_date' => $end_date,
            );

            //edit
            if ($id > 0) {
                // save
                $this->userHasPermission('coupons_edit', false, $result);
                $id = $this->coupons_m->save($data, $id);
                $action = 'update';
            }
            //add
            else {
                // save
                $this->userHasPermission('coupons_add', false, $result);
                $id = $this->coupons_m->save($data);
                $action = 'insert';
            }

            if($id){
                //save products
                if($action == 'insert'){
                    $coupon_products = null;
                }else{
                    $coupon_products = $this->coupon_products_m->get_by('id, product_id', array('coupon_id'=>$id));
                }

                $posted_products = $this->input->post('products');

                //مشترک های بین محصولات پست شده و آن های که قبلا در دیتابیس ذخیره شده اند را پیدا می کنیم و از متغیر هایشان حذف می  کنیم
                if($coupon_products && $posted_products){
                    foreach($coupon_products as $key => $coupon_product){
                        if(in_array($coupon_product->id, $posted_products)){
                            unset($posted_products[array_search($coupon_product->product_id, $posted_products)]);
                            unset($coupon_products[$key]);
                        }
                    }
                }

                //insert
                if($posted_products){
                    $data = array();
                    foreach($posted_products as $product_id){
                        $data[] = array(
                            'coupon_id' => $id,
                            'product_id' => $product_id
                        );
                    }
                    $this->coupon_products_m->insert_batch($data);
                }

                //remove
                if($coupon_products){
                    $coupon_products = json_decode(json_encode($coupon_products), true);
                    $coupon_product_ids = array_column($coupon_products, 'id');
                    $coupon_product_ids = implode(',', $coupon_product_ids);
                    $this->coupon_products_m->delete_by(array("id IN ($coupon_product_ids)" => null));
                }

            }

            $result->msg = 'با موفقیت ثبت گردید.';
            $this->session->set_flashdata('admin_success', $result->msg);
            $result->condition = true;
            $result->url = base_url('admin/coupons');
        } else {
            $result->msg = validation_errors();
        }

        echo json_encode($result);
    }

    function publish($id = '') {
        $data = array(
            'publish' => '1'
        );

        $result = new stdClass();
        $result->condition = false;
        $result->msg = 'موردی انتخاب نشده است.';

        $this->userHasPermission('coupons_edit', false, $result);

        $id = intval($id);
        if ($id > 0) {
            $this->coupons_m->update($data, $id);
            $result->msg = 'کوپن مورد نظر با موفقیت در وضعیت انتشار قرار گرفت.';
            $result->condition = true;
        } else {
            if ($checkb = $this->input->post('list_ids')) {
                $checkb = explode(',', $checkb);
                if (count($checkb)) {
                    foreach ($checkb as $id) {
                        $id = intval($id);
                        $this->coupons_m->update($data, $id);
                    }
                    $result->msg = 'کوپن های مورد نظر با موفقیت در وضعیت انتشار قرار گرفتند.';
                    $result->condition = true;
                }
            }
        }

        echo json_encode($result);
    }

    function un_publish($id = '') {
        $data = array(
            'publish' => '0'
        );

        $result = new stdClass();
        $result->condition = false;
        $result->msg = 'موردی انتخاب نشده است.';

        $this->userHasPermission('coupons_edit', false, $result);

        $id = intval($id);
        if ($id > 0) {
            $this->coupons_m->update($data, $id);
            $result->msg = 'کوپن مورد نظر با موفقیت در وضعیت عدم انتشار قرار گرفت.';
            $result->condition = true;
        } else {
            if ($checkb = $this->input->post('list_ids')) {
                $checkb = explode(',', $checkb);
                if (count($checkb)) {
                    foreach ($checkb as $id) {
                        $id = intval($id);
                        $this->coupons_m->update($data, $id);
                    }
                    $result->msg = 'کوپن های مورد نظر با موفقیت در وضعیت عدم انتشار قرار گرفتند.';
                    $result->condition = true;
                }
            }
        }

        echo json_encode($result);
    }

    function delete($id = '') {
        $result = new stdClass();
        $result->condition = false;
        $result->msg = 'موردی انتخاب نشده است.';
        
        $this->userHasPermission('coupons_delete', false, $result);

        $id = intval($id);
        if ($id > 0) {
            $this->coupons_m->delete($id);
            $result->msg = 'کوپن مورد نظر با موفقیت حذف شد.';
            $result->condition = true;
        } else {
            if ($checkb = $this->input->post('list_ids')) {
                $checkb = explode(',', $checkb);
                if (count($checkb)) {
                    foreach ($checkb as $id) {
                        $id = intval($id);
                        $this->coupons_m->delete($id);
                    }
                    $result->msg = 'کوپن های مورد نظر با موفقیت حذف شدند.';
                    $result->condition = true;
                }
            }
        }
        echo json_encode($result);
    }

}

?>
