<?php
/**
 * @author Rayanik.com
 */
if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Faqs extends Admin_Controller {

    function __construct() {
        parent::__construct();
        $this->load->model('faqs_m');
    }

    function index() {
        $this->userHasPermission('faqs');
        $this->data['breadcrumb'] = array('مدیریت سوالات متداول');

        // CSS
        $css = array();
        array_push($css, 'assets/plugins/data-table/css/dataTables.bootstrap.css');
        $this->data['css'] = $css;

        // JS
        $js = array();
        array_push($js, 'assets/plugins/data-table/js/jquery.dataTables.min.js');
        array_push($js, 'assets/plugins/data-table/js/dataTables.bootstrap.js');
        $this->data['js'] = $js;

        // FAQs
        $this->data['faqs'] = $this->faqs_m->get();

        $this->data['subview'] = 'admin/faq/index';
        $this->load->view('admin/_layout_main', $this->data);
    }

    function view() {
        $this->userHasPermission('faqs', false);
        $this->data['faqs'] = $this->faqs_m->get();
        echo $this->load->view('admin/faq/index', $this->data, true);
    }

    function delete($id = '') {
        $result = new stdClass();
        $result->csrf = $this->security->get_csrf_hash();
        $result->condition = false;
        $result->msg = 'موردی انتخاب نشده است.';

        $this->userHasPermission('faqs_delete', false, $result);

        $id = intval($id);
        if ($id > 0) {
            $this->faqs_m->delete($id);
            $result->msg = 'آیتم مورد نظر با موفقیت حذف شد.';
            $result->condition = true;
        } else {
            if ($checkb = $this->input->post('list_ids')) {
                $checkb = explode(',', $checkb);
                if (count($checkb)) {
                    foreach ($checkb as $id) {
                        $id = intval($id);
                        $this->faqs_m->delete($id);
                    }
                    $result->msg = 'آیتم های مورد نظر با موفقیت حذف شدند.';
                    $result->condition = true;
                }
            }
        }
        echo json_encode($result);
    }

    function publish($id = '') {
        $data = array(
            'publish' => '1'
        );

        $result = new stdClass();
        $result->csrf = $this->security->get_csrf_hash();
        $result->condition = false;
        $result->msg = 'موردی انتخاب نشده است.';

        $this->userHasPermission('faqs_edit', false, $result);

        $id = intval($id);
        if ($id > 0) {
            $this->faqs_m->update($data, $id);
            $result->msg = 'آیتم مورد نظر با موفقیت در وضعیت انتشار قرار گرفت.';
            $result->condition = true;
        } else {
            if ($checkb = $this->input->post('list_ids')) {
                $checkb = explode(',', $checkb);
                if (count($checkb)) {
                    foreach ($checkb as $id) {
                        $id = intval($id);
                        $this->faqs_m->update($data, $id);
                    }
                    $result->msg = 'آیتم های مورد نظر با موفقیت در وضعیت انتشار قرار گرفتند.';
                    $result->condition = true;
                }
            }
        }

        echo json_encode($result);
    }

    function un_publish($id = '') {
        $data = array(
            'publish' => '0'
        );

        $result = new stdClass();
        $result->csrf = $this->security->get_csrf_hash();
        $result->condition = false;
        $result->msg = 'موردی انتخاب نشده است.';

        $this->userHasPermission('faqs_edit', false, $result);

        $id = intval($id);
        if ($id > 0) {
            $this->faqs_m->update($data, $id);
            $result->msg = 'آیتم مورد نظر با موفقیت در وضعیت عدم انتشار قرار گرفت.';
            $result->condition = true;
        } else {
            if ($checkb = $this->input->post('list_ids')) {
                $checkb = explode(',', $checkb);
                if (count($checkb)) {
                    foreach ($checkb as $id) {
                        $id = intval($id);
                        $this->faqs_m->update($data, $id);
                    }
                    $result->msg = 'آیتم های مورد نظر با موفقیت در وضعیت عدم انتشار قرار گرفتند.';
                    $result->condition = true;
                }
            }
        }

        echo json_encode($result);
    }

    function ordering($id = '', $value = '') {

        $value = intval($value);
        $id = intval($id);
        $data = array(
            'ordering' => $value
        );

        $result = new stdClass();
        $result->csrf = $this->security->get_csrf_hash();
        $result->condition = false;
        $result->msg = 'خطای سیستمی';

        $this->userHasPermission('faqs_edit', false, $result);

        if ($id > 0) {
            // Get current order
            $faq = $this->faqs_m->get_by('id, ordering', ['id' => $id], TRUE);
            if ($faq) {
                if ($value == $faq->ordering) {
                    $result->msg = 'ترتیب نمایش تغییر نکرد.';
                } else {
                    $this->faqs_m->save($data, $id);
                    $result->msg = 'ترتیب با موفقیت تغییر کرد.';
                    $result->condition = true;
                }
            }
        }
        echo json_encode($result);
    }

    function edit($id = null) {
        $this->data['breadcrumb'] = 'سوالات متداول';

        // JS
        $js = array();
        array_push($js, 'assets/plugins/ckeditor-full/ckeditor.js');
        $this->data['js'] = $js;

        // Check exist
        $id  = intval($id);
        if ($id != 0) {
            $faq = $this->faqs_m->get($id, true);
            if (!$faq)
                $id = 0;
        }

        if ($id == 0) {
            // Add
            $this->userHasPermission('faqs_add');
            $faq = $this->faqs_m->getNew();
            $this->data['faq'] = $faq;
        } else {
            // Edit
            $this->userHasPermission('faqs_edit');
            $this->data['faq'] = $faq;
        }

        $this->data['subview'] = 'admin/faq/edit';
        $this->load->view('admin/_layout_main', $this->data);
    }

    // save 
    function save() {
        $result = new stdClass();
        $result->csrf = $this->security->get_csrf_hash();
        $result->condition = false;
        $result->msg = 'خطای سیستمی.';
        $id = intval($this->input->post('id'));

        // Check exist
        $id  = intval($id);
        if ($id != 0) {
            $faq = $this->faqs_m->get($id, true);
            if (!$faq)
                $id = 0;
        }
        
        $this->form_validation->set_rules('question', 'پرسش', "trim|required");
        $this->form_validation->set_rules('answer', 'پاسخ', "trim|required");
        $this->form_validation->set_rules('ordering', 'ترتیب', 'trim|required|numeric');


        $this->form_validation->set_message('required', 'وارد کردن فیلد %s الزامی است');
        $this->form_validation->set_message('numeric', '%s باید عدد باشد');

        if ($this->form_validation->run() != FALSE) {
            $data = array(
                'question' => $this->input->post('question'),
                'answer' => $this->input->post('answer'),
                'ordering' => $this->input->post('ordering'),
                'publish' => $this->input->post('publish') == 1 ? 1 : 0
            );

            if ($id) {
                // Edit
                $this->userHasPermission('faqs_edit', false, $result);
                $id = $this->faqs_m->save($data, $id);
            }
            else {
                // Add
                $this->userHasPermission('faqs_add', false, $result);
                $id = $this->faqs_m->save($data);
            }

            $result->msg = 'با موفقیت ثبت گردید';
            $this->session->set_flashdata('admin_success', $result->msg);
            $result->condition = true;
            $result->url = base_url('admin/faqs');
        } else {
            $result->msg = validation_errors();
            $result->condition = false;
        }

        echo json_encode($result);
    }
}
?>