<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class gifts extends Admin_Controller {

    function __construct() {
        parent::__construct();

        $this->load->model('gifts_m');
    }

    function index() {
        $this->userHasPermission('gifts');
        $this->data['breadcrumb'] = array('کارت هدیه');

        // CSS
        $css = array();
        array_push($css, 'assets/plugins/data-table/css/dataTables.bootstrap.css');
        $this->data['css'] = $css;

        // JS
        $js = array();
        array_push($js, 'assets/plugins/data-table/js/jquery.dataTables.min.js');
        array_push($js, 'assets/plugins/data-table/js/dataTables.bootstrap.js');
        $this->data['js'] = $js;


        $this->data['subview'] = 'admin/gift/index';
        $this->load->view('admin/_layout_main', $this->data);
    }

    function view() {
        $this->userHasPermission('gifts', false);
        echo $this->load->view('admin/gift/index', $this->data, true);
    }

    public function ajax_list() {
        $this->userHasPermission('gifts', false);

        $list = $this->gifts_m->get_datatables();
        $data = array();
        $no = $_POST['start'];
        $base_url = trim(base_url(), '/');
        foreach ($list as $item) {
            $actions = "";
            if (in_array('gifts_edit', $this->user_permissions)){
                if ($item->publish == 1) {
                    $btn_class = 'success';
                    $title = 'انتشار';
                    $url = "$base_url/admin/gifts/un_publish/$item->id";
                } else {
                    $btn_class = 'danger';
                    $title = 'عدم انتشار';
                    $url = "$base_url/admin/gifts/publish/$item->id";
                }
                $actions .= "<a title=\"ویرایش\" class=\"btn btn-warning btn-round btn-icon has-tooltip\" href=\"$base_url/admin/gifts/edit/$item->id\"><i class=\"icon-pencil\"></i></a>";
                $actions .= "<a title=\"$title\" class=\"btn btn-$btn_class btn-round btn-icon has-tooltip\" href=\"javascript: void(0)\" onclick=\"insert('$url', '#frm-main', '$base_url/admin/gifts/view', '#res', '#msg', false, true, 'noty' )\"><i class=\"icon-eye\"></i></a>";
            }
            
            if (in_array('gifts_delete', $this->user_permissions)){
                $actions .= "<a title=\"حذف\" class=\"btn btn-danger btn-round btn-icon has-tooltip\" href=\"javascript: void(0)\" onclick=\"deleteRow('$base_url/admin/gifts/delete/$item->id','#frm-main','$base_url/admin/gifts/view','#res','delete')\"><i class=\"icon-trash\"></i></a>";
            }

            $no++;
            $row = array();
            $row['checkbox'] = '<input type="checkbox" value="' . $item->id . '">';
            $row['id'] = $item->id;
            $row['row'] = $no;
            $row['title'] = $item->title;
            $row['code'] = $item->code;
            $row['amount'] = number_format($item->amount);
            $row['count'] = $item->count;
            $row['start_date'] = $this->pdate->date('Y/m/d',strtotime($item->start_date));
            $row['end_date'] = $this->pdate->date('Y/m/d',strtotime($item->end_date));
            $row['actions'] = $actions;

            $data[] = $row;
        }

        $output = array(
            "draw" => $_POST['draw'],
            "recordsTotal" => $this->gifts_m->count_all(),
            "recordsFiltered" => $this->gifts_m->count_filtered(),
            "data" => $data,
            "csrf" => $this->security->get_csrf_hash()
        );
        //output to json format
        echo json_encode($output);
    }

    // Add and edit
    function edit($id = null) {
        //$this->data['meta_title'] = '';
        $this->data['breadcrumb'] = array('کارت هدیه');

        //css
        $css = array();
        array_push($css, 'assets/plugins/persian-datepicker/css/persian-datepicker.css?1');
        $this->data['css'] = $css;

        //js
        $js = array();
        array_push($js, 'assets/plugins/persian-date/persian-date.js?1');
        array_push($js, 'assets/plugins/persian-datepicker/js/persian-datepicker.js?1');
        $this->data['js'] = $js;

        // check exist
        if ($id != null) {
            $gift = $this->gifts_m->get($id, true);
            if (!$gift)
                $id = null;
        }

        if ($id == null) {
            // add
            $this->userHasPermission('gifts_add');
            $gift = $this->gifts_m->getNew();
            $this->data['gift'] = $gift;
        } else {
            // edit
            $this->userHasPermission('gifts_edit');
            $this->load->library('pdate');
            $gift->start_date = date('Y/m/d',strtotime($gift->start_date));
            $gift->end_date = date('Y/m/d',strtotime($gift->end_date));

            $this->data['gift'] = $gift;
        }

        $this->data['subview'] = 'admin/gift/edit';
        $this->load->view('admin/_layout_main', $this->data);
    }

    // Save
    function save() {
        $result = new stdClass();
        $result->condition = false;
        $result->msg = 'خطای سیستمی.';
        $result->csrf = $this->security->get_csrf_hash();

        $id = intval($this->input->post('id'));

        $is_unique =  '|is_unique[gifts.code]';
        if($id != 0){
            $original_value = $this->gifts_m->get_by('code',array('id'=>$id),true);
            if($original_value && $original_value->code == $this->input->post('code')){
                $is_unique =  '';
            }
        }

        $_POST['amount'] = str_replace(',', '', $this->input->post('amount'));
        $_POST['start_date'] = englishNumber($this->input->post('start_date'));
        $_POST['end_date'] = englishNumber($this->input->post('end_date'));

        $this->form_validation->set_rules('title', 'عنوان', 'trim|required');
        $this->form_validation->set_rules('code', 'کد کوپن', 'trim|required'.$is_unique);
        $this->form_validation->set_rules('amount', 'مقدار', 'trim|required|numeric|greater_than[0]');
        $this->form_validation->set_rules('count', 'تعداد', 'trim|required|numeric|greater_than[0]');
        $this->form_validation->set_rules('start_date', 'شروع', ['trim', 'required', 'regex_match[/^1(3|4)(\d{2})\/(0?[1-9]|1[012])\/(0?[1-9]|[12][0-9]|3[01])$/]']);
        $this->form_validation->set_rules('end_date', 'پایان', ['trim', 'required', 'regex_match[/^1(3|4)(\d{2})\/(0?[1-9]|1[012])\/(0?[1-9]|[12][0-9]|3[01])$/]']);

        $this->form_validation->set_message('required', 'وارد کردن فیلد %s الزامی است');
        $this->form_validation->set_message('numeric', '%s را به درستی وارد نمائید');
        $this->form_validation->set_message('regex_match', 'لطفا %s را صحیح وارد کنید');
        $this->form_validation->set_message('greater_than', 'لطفا %s را صحیح وارد کنید');
        $this->form_validation->set_message('is_unique', 'لطفا %s دیگری را وارد کنید');

        if ($this->form_validation->run() != FALSE) {

            $this->load->library('pdate');

            // Start date
            [$year, $month, $day] = explode('/', $this->input->post('start_date'));
            $stamp = $this->pdate->mktime(0, 0, 0, $month, $day, $year);
            $start_date = $this->pdate->date("Y-m-d", $stamp, false, false);
           
            // End date
            [$year, $month, $day] = explode('/', $this->input->post('end_date'));
            $stamp = $this->pdate->mktime(0, 0, 0, $month, $day, $year);
            $end_date = $this->pdate->date("Y-m-d", $stamp, false, false);


            $data = array(
                'title' => $this->input->post('title'),
                'code' => $this->input->post('code'),
                'amount' => $this->input->post('amount'),
                'publish' => ($this->input->post('publish') == 1) ? 1 : 0,
                'count' => $this->input->post('count'),
                'start_date' => $start_date,
                'end_date' => $end_date,
            );

            // Edit
            if ($id > 0) {
                $this->userHasPermission('gifts_edit', false, $result);
                $id = $this->gifts_m->save($data, $id);
            }
            // Add
            else {
                $this->userHasPermission('gifts_add', false, $result);
                $id = $this->gifts_m->save($data);
            }

            if($id){
                $result->msg = 'با موفقیت ثبت گردید.';
                $this->session->set_flashdata('admin_success', $result->msg);
                $result->condition = true;
                $result->url = base_url('admin/gifts');
            }
        } else {
            $result->msg = validation_errors();
        }

        echo json_encode($result);
    }

    function publish($id = '') {
        $result = new stdClass();
        $result->condition = false;
        $result->msg = 'موردی انتخاب نشده است.';

        $this->userHasPermission('gifts_edit', false, $result);

        $ids = [];
        if ($id) {
            $ids[] = intval($id);
        } else {
            if ($checkb = $this->input->post('list_ids')) {
                $checkb = explode(',', $checkb);
                if ($checkb) {
                    foreach ($checkb as $id) {
                        $ids[] = intval($id);
                    }
                }
            }
        }

        if($ids){
            $str_ids = implode(',', $ids);
            $this->gifts_m->update_by(['publish' => '1'], ["id IN ($str_ids)" => null]);
            if(count($ids) == 1){
                $result->msg = 'کارت هدیه مورد نظر با موفقیت در وضعیت انتشار قرار گرفت.';
            } else {
                $result->msg = 'کارت هدیه‌های مورد نظر با موفقیت در وضعیت انتشار قرار گرفتند.';
            }
            $result->condition = true;
        }

        echo json_encode($result);
    }

    function un_publish($id = '') {
        $result = new stdClass();
        $result->condition = false;
        $result->msg = 'موردی انتخاب نشده است.';

        $this->userHasPermission('gifts_edit', false, $result);

        $ids = [];
        if ($id) {
            $ids[] = intval($id);
        } else {
            if ($checkb = $this->input->post('list_ids')) {
                $checkb = explode(',', $checkb);
                if ($checkb) {
                    foreach ($checkb as $id) {
                        $ids[] = intval($id);
                    }
                }
            }
        }

        if($ids){
            $str_ids = implode(',', $ids);
            $this->gifts_m->update_by(['publish' => '0'], ["id IN ($str_ids)" => null]);
            if(count($ids) == 1){
                $result->msg = 'کارت هدیه مورد نظر با موفقیت در وضعیت عدم انتشار قرار گرفت.';
            } else {
                $result->msg = 'کارت هدیه‌های مورد نظر با موفقیت در وضعیت عدم انتشار قرار گرفتند.';
            }
            $result->condition = true;
        }

        echo json_encode($result);
    }

    function delete($id = '') {
        $result = new stdClass();
        $result->condition = false;
        $result->msg = 'موردی انتخاب نشده است.';
        
        $this->userHasPermission('gifts_delete', false, $result);

        $ids = [];
        if ($id) {
            $ids[] = intval($id);
        } else {
            if ($checkb = $this->input->post('list_ids')) {
                $checkb = explode(',', $checkb);
                if ($checkb) {
                    foreach ($checkb as $id) {
                        $ids[] = intval($id);
                    }
                }
            }
        }

        if($ids){
            $str_ids = implode(',', $ids);
            $this->gifts_m->delete_by(["id IN ($str_ids)" => null]);
            if(count($ids) == 1){
                $result->msg = 'کارت هدیه مورد نظر با موفقیت حذف شد.';
            } else {
                $result->msg = 'کارت هدیه‌های مورد نظر با موفقیت حذف شدند.';
            }
            $result->condition = true;
        }

        echo json_encode($result);
    }

}

?>
