<?php

/**
* @author Rayanik.com
*/
if (!defined('BASEPATH'))
exit('No direct script access allowed');

class Orders extends Admin_Controller {

    function __construct() {
        parent::__construct();

        $this->load->model('orders_m');
    }

    // load orders list
    function index($user_id = null) {
        $this->userHasPermission('orders');
        $this->data['breadcrumb'] = array('مدیریت سفارشات');

        //css
        $css = array();
        array_push($css, 'assets/plugins/data-table/css/dataTables.bootstrap.css');
        $this->data['css'] = $css;

        //js
        $js = array();
        array_push($js, 'assets/plugins/data-table/js/jquery.dataTables.min.js');
        array_push($js, 'assets/plugins/data-table/js/dataTables.bootstrap.js');
        $this->data['js'] = $js;

        // User
        $user_id = intval($user_id);
        $user = null;
        if($user_id){
            $user = $this->users_m->get_by("id, CONCAT(first_name, ' ', last_name) AS full_name, cell_phone", ['id' => $user_id, 'type' => 'customer', 'deleted' => 0], true);
        }
        $this->data['user'] = $user;


        $this->data['subview'] = 'admin/order/index';
        $this->load->view('admin/_layout_main', $this->data);
    }

    function view($user_id = null) {
        $this->userHasPermission('orders', false);

        // User
        $user_id = intval($user_id);
        $user = null;
        if($user_id){
            $user = $this->users_m->get_by("id, CONCAT(first_name, ' ', last_name) AS full_name, cell_phone", ['id' => $user_id, 'type' => 'customer', 'deleted' => 0], true);
        }
        $this->data['user'] = $user;

        echo $this->load->view('admin/order/index', $this->data, true);
    }

    public function ajax_list($user_id = null) {
        $this->userHasPermission('orders', false);
        $user_id = intval($user_id);
        if($user_id){
            $this->orders_m->filter = ['user_id' => $user_id];
        }

        if (isset($_POST['columns']) && is_array($_POST['columns'])) {
            foreach ($_POST['columns'] as $key => $column) {
                if($column['data'] == 'card2card' && $column['search']['value'] == 'online'){
                    $_POST['columns'][$key]['search']['value'] = '';
                    $this->orders_m->filter = array('card2card' => '');
                    break;
                }
            }
        }

        $list = $this->orders_m->get_datatables();
        $data = array();
        $no = $_POST['start'];
        $base_url = trim(base_url(), '/');
        foreach ($list as $item) {
            $user_id_with_slash = ($user_id) ? "/$user_id" : '';
            $actions = "<a title=\"مشاهده\" class=\"btn btn-primary btn-round btn-icon has-tooltip\" href=\"$base_url/admin/orders/detail/{$item->id}{$user_id_with_slash}\"><i class=\"icon-list fa-flip-horizontal\"></i></a> ";
            if (!$item->paid && !$item->pending && in_array("orders_delete", $this->user_permissions)) {
                $actions .= "<a title=\"حذف\" class=\"btn btn-danger btn-round btn-icon has-tooltip\" href=\"javascript: void(0)\" onclick=\"deleteRow('$base_url/admin/orders/delete/$item->id','#frm-main','$base_url/admin/orders/view{$user_id_with_slash}','#res','delete')\"><i class=\"icon-trash\"></i></a>";
            }

            $card2card = '';
            switch ($item->card2card) {
                case 'pending':
                    $card2card = '<p class="text-center"><span class="text-warning has-tooltip" title="کارت به کارت(در دست بررسی)"><i class="icon-credit-card"></i></span></p>';
                    break;
                case 'accept':
                    $card2card = '<p class="text-center"><span class="text-success has-tooltip" title="کارت به کارت(تایید شده)"><i class="icon-credit-card"></i></span></p>';
                    break;
                case 'reject':
                    $card2card = '<p class="text-center"><span class="text-danger has-tooltip" title="کارت به کارت(لغو شده)"><i class="icon-credit-card"></i></span></p>';
                    break;
                default:
                    $card2card = '<p class="text-center"><span class="text-primary has-tooltip" title="پرداخت آنلاین"><i class="icon-feed"></i></span></p>';
                    break;
            }

            if ($item->paid) {
                $paid = '<p class="text-center"><span class="text-success has-tooltip" title="پرداخت شده"><i class="icon-paypal"></i></span></p>';
            } else {
                $paid = '<p class="text-center"><span class="text-danger has-tooltip" title="پرداخت نشده"><i class="icon-paypal"></i></span></p>';
            }
            if ($item->pending) {
                $pending = '<p class="text-center"><span class="text-warning has-tooltip" title="درانتظار"><i class="icon-options"></i></span></p>';
            } else {
                $pending = '<p class="text-center"><span class="text-success has-tooltip" title="تمام شده"><i class="icon-check"></i></span></p>';
            }

            $viewed = '';
            if (!$item->reading) {
                $viewed = ' <i class="icon-eye has-tooltip text-danger" title="مشاهده نشده"></i>';
            }

            $no++;
            $row = array();
            $row['row'] = $no . $viewed;
            $row['id'] = $item->id;
            $row['tracking_code'] = $item->tracking_code;
            $row['email'] = '<p class="ellipsis ltr" style="width:120px;" title="' . html_escape($item->email) . '">' . html_escape($item->email) . '</p>';
            $row['cell_phone'] = $item->cell_phone;
            $row['price'] = number_format($item->price);
            $row['coupon_code'] = $item->coupon_code;
            $row['card2card'] = $card2card;
            $row['paid'] = $paid;
            $row['pending'] = $pending;
            $row['jalali_created'] = $item->jalali_created;
            $row['actions'] = $actions;

            $data[] = $row;
        }

        $output = array(
            "draw" => $_POST['draw'],
            "recordsTotal" => $this->orders_m->count_all(),
            "recordsFiltered" => $this->orders_m->count_filtered(),
            "data" => $data,
            "csrf" => $this->security->get_csrf_hash()
        );
        //output to json format
        echo json_encode($output);
    }

    // View order detail
    function detail($id = 0, $user_id = null) {
        $this->userHasPermission('orders');
        $this->data['breadcrumb'] = array('مشاهده سفارش ثبت شده');

        $id = intval($id);
        $order = $this->orders_m->get_by(null, array('id' => $id), true);

        // check exist
        if (!$order) {
            $this->session->set_flashdata('error', 'سفارش مورد نظر یافت نشد!');
            redirect('admin');
        }

        $order->fields = orderFields($order->fields);

        $this->load->model('cards_m');
        $this->load->model('order_cards_m');
        $this->load->model('transactions_m');

        //اگر قبلا مشاهده نشده بود وضعیت آن را به مشاهده تغییر می دهیم
        if ($order->reading == 0) {
            $this->orders_m->save(array('reading' => 1), $id);
        }

        //اطلاعات پرداخت در صورت پرداخت آنلاین
        $transactions = $this->transactions_m->get_by(null, [
            "(completed = 1 OR gateway = 'card2card')" => null, 
            'order_id' => $order->id,
        ], false, 'id ASC');
        if($transactions){  
            // gatewayes
            $this->load->model('gateways_m');
            $db_gatewayes = $this->gateways_m->get_by('title_en, title_fa, image');
            $gatewayes = [];
            if($db_gatewayes){
                foreach ($db_gatewayes as $gateway) {
                    $gatewayes[$gateway->title_en] = (object)[
                        'title' => $gateway->title_fa,
                        'image' => $gateway->image,
                    ];
                }
            }
            foreach ($transactions as $transaction) {
                $this->load->library('pdate');
                $transaction->created = $this->pdate->date('Y/m/d H:i:s', strtotime($transaction->created));

                $transaction->gateway_title = $transaction->gateway_image = '';
                if(isset($gatewayes[$transaction->gateway])){
                    $transaction->gateway_title = $gatewayes[$transaction->gateway]->title;
                    $transaction->gateway_image = $gatewayes[$transaction->gateway]->image;
                }
            }
        }

        // اطلاعات کارت ها
        $cards = null;
        if ($order->paid || $order->card2card) {
            $card_ids = $this->order_cards_m->get_by('card_id', array('order_id' => $order->id));
            if ($card_ids) {
                //array_column($card_ids, 'card_id')
                $cards_arr = array_map(function($element) {
                    return $element->card_id;
                }, $card_ids);
                $cards = $this->cards_m->getCardsInfo($cards_arr);
            }
        }

        // get Category fields
        if ($cards) {
            $product_id = $cards[0]->product_id;
            $this->load->model('products_m');
            $where = array('id' => $product_id, 'publish' => 1, 'deleted' => 0);
            $product = $this->products_m->get_by('category_id', $where, true);
            $this->load->model('categories_m');
            $where = array('id' => $product->category_id, 'publish' => 1, 'deleted' => 0);
            $category_fileds = $this->categories_m->get_by('field1_title, field2_title, field3_title', $where, true);
            $this->data['category_fileds'] = $category_fileds;

            // Get card price when sold
            $this->load->model('order_cards_m');
            $order_card = $this->order_cards_m->get_by(null, array('order_id' => $order->id), true);
            foreach($cards as $card){
                // قیمت همه کارتها یکی است و سبد خرید نداریم پس
                $card->sell_price = $order_card->sell_price;
                $card->currency_sell_price = $order_card->currency_sell_price;
                $card->currency_rate = $order_card->currency_rate;
                $card->currency = $order_card->currency;
            }
        }

        // User
        $this->data['user'] = $this->users_m->get_by('id, status, cell_phone', ['id' => $order->user_id], true);

        $this->data['order'] = $order;
        $this->data['transactions'] = $transactions;
        $this->data['cards'] = $cards;

        if($order->card2card && $order->card2card == 'pending'){
            // موضوعات تیکت
            $this->load->model('categories_m');
            $this->data['ticket_categories'] = $this->categories_m->get_by('id , title_fa as title', array('type' => 'ticket', 'publish' => 1, 'deleted' => 0), false, 'ordering');
        }


        $this->data['not_reading_order'] = $this->orders_m->get_by('count(id) as not_reading', array('reading' => '0'), true)->not_reading;
        $this->data['show_education_manual_product_modal'] = true;
        $this->data['user_id'] = intval($user_id);
        
        $this->data['subview'] = 'admin/order/detail';
        $this->load->view('admin/_layout_main', $this->data);
    }

    function delete($id = '') {
        $this->load->model('order_cards_m');
        $this->load->model('cards_m');
        $this->load->model('transactions_m');

        $result = new stdClass();
        $result->condition = false;
        $result->msg = 'موردی انتخاب نشده است.';

        $this->userHasPermission('orders_delete', false, $result);

        $id = intval($id);
        $order = $this->orders_m->get_by('id, ', [
            'id' => $id, 
            'paid' => 0, 
            'card2card <>' => 'pending',
        ], true);
        if ($order) {

            // Transactions
            $this->transactions_m->update_by(['order_id' => 0], ['order_id' => $id]);

            // کارت ها را از حالت فروخته شده دربیار
            // $card_ids = $this->order_cards_m->get_by('card_id', array('order_id' => $id));
            // foreach($card_ids as $card_id){
            //     $dataCard =  array(
            //         'order_id' => 0,
            //         'sold' => 0,
            //         'deactive_date' => '',
            //     );
            //     $this->cards_m->save($dataCard, $card_id->card_id);
            // }

            // کارت های این سفارش را پاک کن
            $this->order_cards_m->delete_by(array('order_id' => $id));

            $this->orders_m->delete($id);
            $result->msg = 'سفارش مورد نظر با موفقیت حذف شد.';
            $result->condition = true;
        } 
        echo json_encode($result);
    }

    function exportEmails() {
        $this->userHasPermission('orders_email');

        $orders = $this->orders_m->getEmails();
        if(!$orders){
            $this->session->set_flashdata('error', 'سفارشی وجود ندارد که با ایمیل ثبت شده باشد.');
            redirect('admin/orders');
        }

        $spreadsheet = new \PhpOffice\PhpSpreadsheet\Spreadsheet();
        $sheet = $spreadsheet->getActiveSheet();
        $sheet->setTitle('ایمیل ها');
        $sheet->setCellValue('A1', 'ایمیل');

        foreach ($orders as $index => $item) {
            $sheet->setCellValue('A' . strval($index + 2), $item->email);
        }

        try {
            // درست کردن نام فایل
            $filename =  'emails-' . $this->pdate->date('Y-m-d') . '.xlsx';

            $writer = new \PhpOffice\PhpSpreadsheet\Writer\Xlsx($spreadsheet);

            header('Content-Type: application/vnd.ms-excel');
            header('Content-Disposition: attachment;filename="'. $filename .'"'); 
            header('Cache-Control: max-age=0');
            
            $writer->save('php://output'); // download file 
        } catch (\Exception $e) {
            // exit($e->getMessage());
            $this->session->set_flashdata('error', 'اکسل شما دانلود نشد!');
            redirect('admin/orders');
        }

    }

    function exportCellPhones() {
        $this->userHasPermission('orders_phone');

        $orders = $this->orders_m->getCellPhones();
        if(!$orders){
            $this->session->set_flashdata('error', 'سفارشی وجود ندارد که با شماره همراه ثبت شده باشد.');
            redirect('admin/orders');
        }
   
        $spreadsheet = new \PhpOffice\PhpSpreadsheet\Spreadsheet();
        $sheet = $spreadsheet->getActiveSheet();
        $sheet->setTitle('شماره همراه ها');
        $sheet->setCellValue('A1', 'شماره همراه');

        foreach ($orders as $index => $item) {
            $sheet->setCellValue('A' . strval($index + 2), "$item->cell_phone");
        }

        try {
            // درست کردن نام فایل
            $filename =  'cell-phones-' . $this->pdate->date('Y-m-d') . '.xlsx';

            $writer = new \PhpOffice\PhpSpreadsheet\Writer\Xlsx($spreadsheet);

            header('Content-Type: application/vnd.ms-excel');
            header('Content-Disposition: attachment;filename="'. $filename .'"'); 
            header('Cache-Control: max-age=0');
            
            $writer->save('php://output'); // download file 
        } catch (\Exception $e) {
            // exit($e->getMessage());
            $this->session->set_flashdata('error', 'اکسل شما دانلود نشد!');
            redirect('admin/orders');
        }
    }

    function saveStatus($send = null) {
        $this->load->model('transactions_m');
        $this->load->model('order_cards_m');
        $this->load->model('cards_m');
        $this->load->model('categories_m');
        $this->load->model('settings_m');

        $send = ($send == 1) ? true : false;
        $result = new stdClass();
        $result->condition = false;
        $result->msg = 'خطای سیستمی';
        $result->csrf = $this->security->get_csrf_hash();

        $this->userHasPermission('orders_edit', false, $result);

        $id = intval($this->input->post('id'));
        $order = $this->orders_m->get_by(null, array('id' => $id), true);
        if (!$order) {
            echo json_encode($result);
            die();
        }

        if($order->card2card == 'reject'){
            $result->msg = 'کارت به کارت تایید نشده است.';
            echo json_encode($result);
            die();
        }

        $card2card = ($order->card2card) ? $this->input->post('card2card') : '';
        $pending = ($this->input->post('pending')== 1) ? 1 : 0;

        $data = [];

        if($order->card2card == 'pending'){
            if(!in_array($card2card, ['accept', 'reject'])){
                $result->msg = 'وضعیت کارت به کارت صحیح نیست.';
                echo json_encode($result);
                die();
            }

            if($card2card == 'accept'){
                $data['card2card'] = 'accept';
                $data['paid'] = 1;
            } else {
                $pending = 0;
                $data['card2card'] = 'reject';
            }

            $data['pending'] = $pending;

        } elseif($order->card2card == 'accept' || $order->card2card == ''){
            $card2card = $order->card2card;
            $data['pending'] = $pending;
        } 
        
        if(!$data){
            $result->msg = 'داده ای ارسال نشده است.';
            echo json_encode($result);
            die();
        }
        
        // Check create ticket
        if(
            isset($data['card2card']) && 
            $data['card2card'] == 'reject' && 
            $order->user_id && 
            $this->input->post('ticket[send]') &&
            in_array('tickets_add', $this->user_permissions)
        ){
            $this->form_validation->set_rules('ticket[title]', 'عنوان تیکت', "trim|required");
            $this->form_validation->set_rules('ticket[category_id]', 'بخش تیکت', "trim|required|integer");
            $this->form_validation->set_rules('ticket[priority]', 'فوریت تیکت', "trim|required|in_list[low,normal,high]");
            $this->form_validation->set_rules('ticket[text]', 'متن', "trim|required");
            
            $this->form_validation->set_message('required', 'وارد کردن فیلد %s الزامی است');
            $this->form_validation->set_message('integer', 'لطفا %s را صحیح انتخاب کنید');
            $this->form_validation->set_message('in_list', 'لطفا %s را صحیح انتخاب کنید');

            if ($this->form_validation->run() != FALSE) {
                $this->load->model('tickets_m');
                $this->load->model('messages_m');

                // Save Ticket
                $ticket_data =[
                    'user_id' => $order->user_id,
                    'category_id' => $this->input->post('ticket[category_id]'),
                    'title' => $this->security->xss_clean($this->input->post('ticket[title]')),
                    'priority' => $this->input->post('ticket[priority]'),
                    'status' => 'open',
                    'updated' => date('Y-m-d H:i:s'),
                ];

                $ticket_id = $this->tickets_m->save($ticket_data);

                // Save message
                $message_data = [
                    'ticket_id' => $ticket_id,
                    'user_id' => $this->user_login->id,
                    'text' => $this->security->xss_clean($this->input->post('ticket[text]')),
                    'reading' => 0,
                ];

                $this->messages_m->save($message_data);
                $this->tickets_m->updateUnreadAndLastMessage($ticket_id, 'customer');

            } else {
                $result->msg = validation_errors();
                echo json_encode($result);
                die();
            }
        }

        // Save order
        $this->orders_m->save($data, $order->id);

        if(isset($data['card2card'])){
            $card2card_transaction = $this->transactions_m->get_by('id, amount',[
                'order_id' => $order->id, 
                'gateway' => 'card2card', 
                'completed' => 0,
                'reject' => 0,
            ], true);
            if($card2card_transaction){
                if($data['card2card'] == 'accept'){
                    // Accept card2card transaction
                    $this->transactions_m->update(['completed' => 1], $card2card_transaction->id);
    
                    // ثبت تراکنش منفی
                    $this->transactions_m->save([
                        'user_id' => $order->user_id,
                        'order_id' => $order->id,
                        'amount' => $card2card_transaction->amount * -1,
                        'type' => 'order_payment',
                        'completed' => 1
                    ]);
                } else {
                    // Reject card2card transaction
                    $this->transactions_m->update(['reject' => 1], $card2card_transaction->id);
    
                    // اگر پولی از کیف  پول برای این سفارش کم شده بود آن را برمی‌گردانیم
                    $block_transaction = $this->transactions_m->get_by('amount', [
                        'order_id' => $order->id,
                        'type' => 'order_payment',
                        'gateway' => '',
                        'completed' => 1
                    ], true);
                    if($block_transaction){
                        $this->transactions_m->save([
                            'user_id' => $order->user_id,
                            'order_id' => $order->id,
                            'amount' => abs($block_transaction->amount),
                            'type' => 'refund',
                            'completed' => 1
                        ]);
                    }
    
                    // کارت ها را از حالت فروخته شده دربیار
                    $card_ids = $this->order_cards_m->get_by('card_id', array('order_id' => $order->id));
                    foreach($card_ids as $card_id){
                        $dataCard =  array(
                            'order_id' => 0,
                            'sold' => 0,
                            'deactive_date' => '',
                        );
                        $this->cards_m->save($dataCard, $card_id->card_id);
                    }
                    
                    //کارت های این سفارش را پاک کن
                    $this->order_cards_m->delete_by(['order_id' => $order->id]);
                }
            }
        }

        $order->pending = $pending; // new status pending
        $order->card2card = $card2card; // new status card2card

        $result->msg = 'با موفقیت ثبت گردید';
        $result->condition = true;
        $this->session->set_flashdata('admin_success', $result->msg);
        $result->url = base_url("admin/orders/detail/$order->id");



        if ($send) {
            if($card2card == 'reject' || ($pending && $card2card == 'accept')){
                if(isset($card2card_transaction) && $card2card_transaction && $order->cell_phone){
                    // یا فقط کارت به کارت را رد کرده یا تایید کرده 
                    // فعلا تمی خواد اطلاعات کارت را در اختیار کاربر قرار بده
                    $sms = $this->settings_m->getSingle('sms');
                    $sms = json_decode($sms);
                    if($card2card == 'accept'){
                        $pattern = isset($sms->patterns->card2card_accept) ? $sms->patterns->card2card_accept : '';
                    } else {
                        $pattern = isset($sms->patterns->card2card_reject) ? $sms->patterns->card2card_reject : '';
                    }
                    if($sms->active && $sms->api_key && $pattern){
                        $this->load->library($sms->active, null, 'sms');
                        $sms_status = $this->sms->send_by_token($sms->api_key, $sms->from, $order->cell_phone, $pattern, number_format($card2card_transaction->amount));
                    }
                }
            } elseif(!$pending && ($card2card == 'accept' || $card2card == '')) {
                $card_ids = $this->order_cards_m->get_by('card_id', array('order_id' => $order->id));
                if ($card_ids) {
                    //array_column($card_ids, 'card_id')
                    $cards_arr = array_map(function($element) {
                        return $element->card_id;
                    }, $card_ids);
                    $cards = $this->cards_m->getCardsInfo($cards_arr);

                    $category_id = $cards[0]->category_id;
                    $where = array('id' => $category_id);
                    $category_fileds = $this->categories_m->get_by('title_fa, field1_title, field2_title, field3_title', $where, true);

                    //ارسال اطلاعات سفارش و کد پیگیری
                    $this->data['category_fields'] = $category_fileds;

                    // Send email
                    if ($order->email) {
                        try {
                            $this->sendEmail($order, $cards, $category_fileds);
                        } catch (Exception $ex) {
                            $this->data['message'] = $ex->getMessage();
                        }
                    }

                    // Send sms
                    if($order->cell_phone){
                        $this->sendSms($order, $cards, $category_fileds);
                    }
                }

                $result->msg = 'با موفقیت ثبت و درخواست ارسال صادر شد.';
            } else {
                $result->msg = 'با موفقیت ثبت گردید اما امکان ارسال اطلاعات سفارشهای در انتظار ممکن نیست';
            }
        }


        echo json_encode($result);
    }

    private function sendEmail($order, $cards, $category_fileds) {
        $fields = array(
            'admin_email',
            'send_admin_invoice',
            'site_name',
            'site_name_en',
            'logo',
        );
        $settings = $this->settings_m->getSettings($fields);

        $email = $order->email;

        $subject = 'فاکتور';
        $arguments = array(
            'order' => $order,
            'order_cards' => $cards,
            'category_fileds' => $category_fileds,
            'admin_pending' => true
        );
        $message = $this->load->view('email/invoice', $arguments, true);
        //dd($cards);
        //dd($message);
        $admin_email = ($settings->send_admin_invoice) ? $settings->admin_email : null;

        $this->load->library('frontend_general');
        $this->frontend_general->sendEmail($email, $message, null, $subject, $settings->site_name, $settings->site_name_en, $settings->logo, null, $admin_email);
    }

    private function sendSms($order, $cards, $category_fileds)
    {
        $settings = $this->settings_m->getSettings([
            'sms', 
            'notification_cell_phone', 
            'site_name',
        ]);
        $settings->sms = json_decode($settings->sms);
        if($settings->sms->active && $settings->sms->api_key){
            $this->load->library($settings->sms->active, null, 'sms');
            if($settings->sms->after_buy != 'no' && !$order->pending){
                if($settings->sms->after_buy == 'codes'){
                    // باید کد ها یا رمز ها یا سریال ها را برای کاربر پیامک کنیم
                    $message = "اطلاعات خرید شما:";
                    $card_number = 1;
                    foreach ($cards as $card) {
                        $message .= "\n";
                        if (count($cards) > 1) {
                            $message .= $card_number . ". ";
                        }
                        $message .= "$category_fileds->field1_title" . ": " . $card->code;
                        if ($card->code2)
                            $message .= "\n" . "$category_fileds->field2_title" . ": " . $card->code2;
                        if ($card->code3)
                            $message .= "\n" . "$category_fileds->field3_title" . ": " . $card->code3;
                        $card_number++;
                    }
                    $sms_status = $this->sms->send($settings->sms->api_key, $settings->sms->from, $order->cell_phone, $message);
    
                } elseif($settings->sms->after_buy == 'successful') {
                    // پیام موفقیت آمیز برای کاربر باید ارسال کنیم
                    if($settings->sms->patterns->successful_buy){
                        // چون الگو را وارد کرده با الگو ارسال می کنیم
                        $sms_status = $this->sms->send_by_token($settings->sms->api_key, $settings->sms->from, $order->cell_phone, $settings->sms->patterns->successful_buy, $order->tracking_code);
                    } else {
                        // الگو را وارد نکرده بنابراین به صورت عادی ارسال می کنیم
                        $message = "اطلاعات خرید شما در لینک زیر قرار گرفت:";
                        $message .= "\n" . base_url("buy/" . $order->tracking_code);
                        $message .= "\n" . $settings->site_name;
                        $sms_status = $this->sms->send($settings->sms->api_key, $settings->sms->from, $order->cell_phone, $message);
                    }
                }
            }
        }
    }

}
?>
