<?php

defined('BASEPATH') OR exit('No direct script access allowed');

class Permissions extends Admin_Controller {

    public function __construct() {
        parent::__construct();

        $this->load->model('roles_m');
        $this->load->model('permissions_m');
    }

    public function index() {
        $this->userHasPermission('permissions');
        $this->data['meta_title'] = 'سطوح دسترسی';
        $this->data['breadcrumb'] = array(' سطوح دسترسی');
        //$this->data['sub_title'] = '';

        //css
        $css = array();
        array_push($css, 'assets/plugins/data-table/css/dataTables.bootstrap.css');
        $this->data['css'] = $css;

        //js
        $js = array();
        array_push($js, 'assets/plugins/data-table/js/jquery.dataTables.min.js');
        array_push($js, 'assets/plugins/data-table/js/dataTables.bootstrap.js');
        $this->data['js'] = $js;

        $this->data['roles'] = $this->roles_m->get_by(NULL, array('for_user' => 'admin'));

        $this->data['subview'] = 'admin/permission/index';
        $this->load->view('admin/_layout_main', $this->data);
    }

    public function edit($id = NULL) {
        $id = intval($id);

        // Check exists
        if($id != 0){
            $role = $this->roles_m->get_by(NULL, array('id' => $id), true);
            if(!$role){
                $id = 0;
            }
        }

        if ($id) {
            $this->userHasPermission('permissions_edit');
        } else {
            $this->userHasPermission('permissions_add');
            $role = $this->roles_m->getNew();
        }

        $this->data['role'] = $role;

        $this->data['permissions'] = $this->getPermissions();

        $this->data['subview'] = 'admin/permission/edit';
        $this->load->view('admin/_layout_main', $this->data);
    }

    public function view() {
        $this->userHasPermission('permissions', false);
        $this->data['roles'] = $this->roles_m->get_by(NULL, array('for_user' => 'admin'));

        echo $this->load->view('admin/permission/index', $this->data, true);
    }

    public function save() {

        $result = new stdClass();
        $result->csrf = $this->security->get_csrf_hash();
        $result->condition = false;

        $this->form_validation->set_rules('title', 'عنوان', 'trim|required');
        $this->form_validation->set_message('required', 'وارد کردن فیلد %s الزامی است');

        if ($this->form_validation->run() != FALSE) {
            $title = $this->input->post('title');
            $permissions = json_encode($this->input->post('permission'));
            $id = intval($this->input->post('id'));

            $data = array(
                'title' => $title,
                'permissions' => $permissions,
                'for_user' => 'admin'
            );

            if ($id > 0) {
                // Edit
                $this->userHasPermission('permissions_edit', false, $result);
                $this->roles_m->save($data, $id);
            } else {
                // Add
                $this->userHasPermission('permissions_add', false, $result);
                $this->roles_m->save($data);
            }

            $result->msg = 'با موفقیت ثبت گردید';
            $this->session->set_flashdata('admin_success', $result->msg);
            $result->condition = true;
            $result->url = base_url('admin/permissions');
        } else {
            $result->msg = validation_errors();
        }

        echo json_encode($result);
    }

    function delete($id = NULL) {
        $result = new stdClass();
        $result->condition = false;
        $result->msg = 'خطا امنیتی.';

        $this->userHasPermission('permissions_delete', false, $result);

        $id = intval($id);
        $where = array(
            'for_user' => 'admin',
            'default' => 0,
            'id' => $id
        );
        $role = $this->roles_m->get_by(NULL, $where, TRUE);
        if ($role) {

            //تمام کاربرانی که این نقش را داشتند نقش پیش فرض به آن ها تعلق می گیرد
            //به دست آوردن نقش پیش فرض
            $where = array(
                'for_user' => 'admin',
                'default' => 1
            );
            $default = $this->roles_m->get_by(NULL, $where, TRUE);
            if ($default) {
                $data = array(
                    'role_id' => $default->id
                );
                $where = array(
                    'role_id' => $id,
                    'type' => 'admin'
                );
                $this->users_m->update_by($data, $where);

                $this->roles_m->delete($id);
                $result->msg = 'نقش مورد نظر با موفقیت حذف شد.';
                $result->condition = true;
            }
        }
        echo json_encode($result);
    }

    //پیش فرض
    function defaultRole($id = NULL) {
        $result = new stdClass();
        $result->csrf = $this->security->get_csrf_hash();
        $result->condition = false;
        $result->msg = 'خطا امنیتی.';

        $this->userHasPermission('permissions_edit', false, $result);

        $id = intval($id);
        $where = array(
            'for_user' => 'admin',
            'id' => $id
        );
        $role = $this->roles_m->get_by(NULL, $where, TRUE);
        if ($role) {

            $data = array(
                'default' => '0'
            );
            $this->roles_m->update_by($data, array('for_user' => 'admin'));

            $data = array(
                'default' => '1'
            );
            $this->roles_m->update($data, $id);

            $result->msg = 'نقش مورد نظر با موفقیت در وضعیت پیش فرض قرار گرفت شد.';
            $result->condition = true;
        }
        echo json_encode($result);
    }

    //به دست آوردن سطوح دسترسی به صورت درختی
    private function getPermissions() {
        $refs = array();
        $list = array();

        $permissions = $this->permissions_m->get_by(null, array('publish' => 1), FALSE, 'parent, ordering');

        foreach ($permissions as $permission) {
            $ref = & $refs[$permission->en];

            $ref['parent'] = $permission->parent;
            $ref['id'] = $permission->id;
            $ref['fa'] = $permission->fa;
            $ref['en'] = $permission->en;

            if ($permission->parent == '') {
                $list[$permission->en] = & $ref;
            } else {
                $refs[$permission->parent]['children'][$permission->en] = & $ref;
            }
        }
        return $list;
    }


}
