<?php

/**
 * @author Rayanik.com
 */
if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Products extends Admin_Controller {

    function __construct() {
        parent::__construct();

        $this->load->model('products_m');
        $this->load->library('tree');
    }

    // load products list
    function index() {
        $this->userHasPermission('products');
        //$this->data['meta_title'] = '';
        $this->data['breadcrumb'] = array('محصولات');

        //css
        $css = array();
        array_push($css, 'assets/plugins/data-table/css/dataTables.bootstrap.css');
        $this->data['css'] = $css;

        //js
        $js = array();
        array_push($js, 'assets/plugins/data-table/js/jquery.dataTables.min.js');
        array_push($js, 'assets/plugins/data-table/js/dataTables.bootstrap.js');
        $this->data['js'] = $js;

        $this->data['products'] = $this->products_m->getProductsWithNumberOfCardsForAdmin();
        
        $this->data['subview'] = 'admin/product/index';
        $this->load->view('admin/_layout_main', $this->data);
    }

    function view() {
        $this->userHasPermission('products', false);
        $this->data['products'] = $this->products_m->getProductsWithNumberOfCardsForAdmin();
        echo $this->load->view('admin/product/index', $this->data, true);
    }

    function delete($id = NULL) {
        $data = array(
            'image' => '',
            'deleted' => '1'
        );
        $result = new stdClass();
        $result->csrf = $this->security->get_csrf_hash();
        $result->condition = false;
        $result->msg = 'موردی انتخاب نشده است.';

        $this->userHasPermission('products_delete', false, $result);

        $id = intval($id);
        if ($id > 0) {
            $this->deleteProductFiles($id);
            $this->products_m->update($data, $id);
            $result->msg = 'محصول مورد نظر با موفقیت حذف شد.';
            $result->condition = true;
        } else {
            if ($checkb = $this->input->post('list_ids')) {
                $checkb = explode(',', $checkb);
                if (count($checkb)) {
                    foreach ($checkb as $id) {
                        $id = intval($id);
                        $this->deleteProductFiles($id);
                        $this->products_m->update($data, $id);
                    }
                    $result->msg = 'محصول های مورد نظر با موفقیت حذف شدند.';
                    $result->condition = true;
                }
            }
        }
        echo json_encode($result);
    }

    function publish($id = NULL) {
        $data = array(
            'publish' => '1'
        );

        $result = new stdClass();
        $result->csrf = $this->security->get_csrf_hash();
        $result->condition = false;
        $result->msg = 'موردی انتخاب نشده است.';

        $this->userHasPermission('products_edit', false, $result);

        $id = intval($id);
        if ($id > 0) {
            $this->products_m->update($data, $id);
            $result->msg = 'محصول مورد نظر با موفقیت در وضعیت انتشار قرار گرفت.';
            $result->condition = true;
        } else {
            if ($checkb = $this->input->post('list_ids')) {
                $checkb = explode(',', $checkb);
                if (count($checkb)) {
                    foreach ($checkb as $id) {
                        $id = intval($id);
                        $this->products_m->update($data, $id);
                    }
                    $result->msg = 'محصول های مورد نظر با موفقیت در وضعیت انتشار قرار گرفتند.';
                    $result->condition = true;
                }
            }
        }

        echo json_encode($result);
    }

    function un_publish($id = NULL) {
        $data = array(
            'publish' => '0'
        );

        $result = new stdClass();
        $result->csrf = $this->security->get_csrf_hash();
        $result->condition = false;
        $result->msg = 'موردی انتخاب نشده است.';

        $this->userHasPermission('products_edit', false, $result);

        $id = intval($id);
        if ($id > 0) {
            $this->products_m->update($data, $id);
            $result->msg = 'محصول مورد نظر با موفقیت در وضعیت عدم انتشار قرار گرفت.';
            $result->condition = true;
        } else {
            if ($checkb = $this->input->post('list_ids')) {
                $checkb = explode(',', $checkb);
                if (count($checkb)) {
                    foreach ($checkb as $id) {
                        $id = intval($id);
                        $this->products_m->update($data, $id);
                    }
                    $result->msg = 'محصول های مورد نظر با موفقیت در وضعیت عدم انتشار قرار گرفتند.';
                    $result->condition = true;
                }
            }
        }

        echo json_encode($result);
    }

    function onExist($id = null) {
        $id = intval($id);

        $data = array(
            'is_exists' => '0'
        );

        $result = new stdClass();
        $result->condition = false;
        $result->msg = 'موردی انتخاب نشده است.';

        $this->userHasPermission('products_edit', false, $result);

        if ($id > 0) {
            $this->products_m->update($data, $id);
            $result->msg = 'محصول مورد نظر با موفقیت در وضعیت ناموجود قرار گرفت.';
            $result->condition = true;
        }

        echo json_encode($result);
    }

    function exist($product_id = null) {
        $product_id = intval($product_id);

        $data = array(
            'is_exists' => '1'
        );

        $result = new stdClass();
        $result->condition = false;
        $result->msg = 'موردی انتخاب نشده است.';

        $this->userHasPermission('products_edit', false, $result);

        if ($product_id > 0) {
            $where = array(
                'product_id' => $product_id,
                'is_exists' => 1
            );

            $this->products_m->save($data, $product_id);
            $result->msg = 'محصول مورد نظر با موفقیت در وضعیت موجود قرار گرفت.';
            $result->condition = true;
        }

        echo json_encode($result);
    }

    // Add and edit
    function edit($id = null) {
        //js
        $js = array();
        array_push($js, 'assets/plugins/ckeditor-full/ckeditor.js');
        $this->data['js'] = $js;

        //$this->data['meta_title'] = '';
        $this->data['breadcrumb'] = array('محصولات');

        // check exist
        if ($id != null) {
            $product = $this->products_m->get_by(NULL, array('id' => $id, 'deleted' => '0'), true);
            if (!$product)
                $id = null;
        }

        if ($id == null) {
            // add 
            $this->userHasPermission('products_add');
            $this->data['action'] = 'add';
            $product = $this->products_m->getNew();
            $this->data['product'] = $product;
        } else {
            // edit 
            $this->userHasPermission('products_edit');
            $this->data['action'] = 'edit';
            $this->data['product'] = $product;
        }

        // قیمت ها
        $this->load->model('prices_m');
        $prices = $this->prices_m->get_by(null, array('product_id' => $id));
        $this->data['prices'] = $prices;

        // دسته بندی
        $this->load->model('categories_m');
        $this->load->library('tree');
        $categories = $this->categories_m->get_by(null, array('type' => 'product', 'publish' => 1, 'deleted' => 0));
        $this->data['categories'] = $categories;

        $this->data['show_education_manual_product_modal'] = true;
        $this->data['show_educarion_ui_modal'] = true;
        $this->data['subview'] = 'admin/product/edit';
        $this->load->view('admin/_layout_main', $this->data);
    }

    // Save
    function save() {
        $result = new stdClass();
        $result->csrf = $this->security->get_csrf_hash();
        $result->msg = 'خطا سیستمی.';
        $result->condition = false;

        $data_main = $this->input->post();
        $data = $data_main['product'];
        $data['id'] = intval($this->input->post('product[id]'));
        $product_id = $data['id'];

        // Check exists
        if($product_id){
            $product = $this->products_m->get_by(null, array('id' => $product_id), true);
            if(!$product){
                $product_id = 0;
            }
        } else{
            $product = null;
        }

        $this->form_validation->set_rules('product[title]', 'عنوان فارسی', "trim|required");
        $this->form_validation->set_rules('product[category_id]', 'دسته بندی', 'trim|required|integer');
        $this->form_validation->set_rules('min_qty', 'حداقل تعداد', 'trim|required|numeric|greater_than_equal_to[1]');
        $this->form_validation->set_rules('ordering', 'ترتیب نمایش', 'numeric|required');
        $this->form_validation->set_rules('product[currency]', 'ارز', 'trim|required|in_list[tooman,dollar,dirham,euro,pound,lira]');
        $this->form_validation->set_rules('product[manual]', 'وضعیت نمایش کارت', 'trim|required|in_list[0,1,2]');

        $this->form_validation->set_message('greater_than_equal_to', '‌%s باید بزرگتر یا مساوی ‌%s باشد.');
        $this->form_validation->set_message('required', 'وارد کردن فیلد %s الزامی است');
        $this->form_validation->set_message('integer', '%s باید عدد عدد صحیح باشد');
        $this->form_validation->set_message('in_list', ' %s را صحیح انتخاب کنید');

        if ($this->form_validation->run() != FALSE) {
            // Unique slug
            $slug = trim($this->security->xss_clean($this->input->post('product[slug]')));
            $slug = create_slug($slug);
            if($slug && (!$product || ($product && $product->slug != $slug))){
                $exists = $this->products_m->get_by('COUNT(id) AS number', [
                    'deleted' => 0,
                    'slug' => $slug,
                ], true)->number;
                if($exists){
                    $result->msg = 'Slug وارد شده تکراری است.';
                    echo json_encode($result);
                    die();
                }
            }

            $this->load->model('prices_m');
            $data['title'] = trim($data['title']);
            $data['ordering'] = $data_main['ordering'];
            $data['front_description'] = trim($data['front_description']);
            $data['max_qty'] = intval($data_main['max_qty']);
            $data['min_qty'] = intval($this->input->post('min_qty'));
            $data['slug'] = $slug;
            $data['meta_title'] = $this->security->xss_clean($this->input->post('meta_title'));
            $data['meta_description'] = $this->security->xss_clean($this->input->post('meta_description'));
            $data['manual'] = intval($this->input->post('product[manual]'));

            if($data['max_qty'] && $data['min_qty'] > $data['max_qty']){
                $result->msg = 'حداقل تعداد نمی‌تواند بزرگتر از حداکثر تعداد باشد.';
                echo json_encode($result);
                die();
            }

            // Image
            $image_result = $this->uploadImage('image');
            if ($image_result->condition) {
                $source_image = $image_result->file_path;
                list($width, $height, $type, $attr) = getimagesize($source_image);

                if ($width != 80 || $height != 80) {
                    //در این حالت نیاز به برش و تغییر اندازه داریم 
                    $this->load->library('image_lib');
                    $config['source_image'] = $source_image;
                    $config['new_image'] = $source_image;
                    $config['maintain_ratio'] = FALSE;
                    $config['width'] = 80;
                    $config['height'] = 80;

                    $this->image_lib->set_enlarge(TRUE);
                    $this->image_lib->thumb($config);
                }
                $data['image'] = $source_image;
            }

            // Large image
            $image_result = $this->uploadImage('large_image');
            if ($image_result->condition) {
                $source_image = $image_result->file_path;
                list($width, $height, $type, $attr) = getimagesize($source_image);

                if ($width != 480 || $height != 360) {
                    //در این حالت نیاز به برش و تغییر اندازه داریم 
                    $this->load->library('image_lib');
                    $config['source_image'] = $source_image;
                    $config['new_image'] = $source_image;
                    $config['maintain_ratio'] = FALSE;
                    $config['width'] = 480;
                    $config['height'] = 360;

                    $this->image_lib->set_enlarge(TRUE);
                    $this->image_lib->thumb($config);
                }

                $data['large_image'] = $source_image;
            }


            $is_changed = false;
            $from_qtys = $data_main['from_qty'];
            $to_qtys = $data_main['to_qty'];
            $sell_prices = $data_main['sell_price'];
            $prices = $data_main['price'];

            //edit
            if ($data['id'] > 0) {
                $this->userHasPermission('products_edit', false, $result);
                $id = $this->products_m->save($data, $data['id']);
                $action = 'edit';

                $old_prices = $this->prices_m->get_by(null, array('product_id' => $id));

                // محصول را برای تغییر قیمت هایش چک می کنیم
                $c = 0;
                if (count($prices) == count($old_prices)) {
                    foreach ($old_prices as $old_price) {
                        $row_changed = $old_price->from_qty != $from_qtys[$c] || $old_price->to_qty != $to_qtys[$c] || $old_price->sell_price != floatval(str_replace(',', '', $sell_prices[$c])) || $old_price->price != floatval(str_replace(',', '', $prices[$c]));
                        if ($row_changed) {
                            $is_changed = true;
                            break;
                        }
                        $c++;
                    }
                } else {
                    $is_changed = true;
                }

                if ($is_changed) {
                    // حذف قیمت های قبلی
                    $this->prices_m->delete_by(array('product_id' => $id));
                }
            }
            //add
            else {
                // ذخیره محصول
                $this->userHasPermission('products_add', false, $result);
                $id = $this->products_m->save($data);
                $action = 'add';
            }

            // ذخیره قیمت محصول
            if ($action == 'add' || ($action == 'edit' && $is_changed)) {
                $c = 0;
                foreach ($sell_prices as $sell_price) {
                    $price_data = array();
                    $price_data['product_id'] = $id;
                    $price_data['from_qty'] = $from_qtys[$c];
                    $price_data['to_qty'] = $to_qtys[$c];
                    $price_data['price'] = floatval(str_replace(',', '', $prices[$c]));
                    $price_data['sell_price'] = floatval(str_replace(',', '', $sell_prices[$c]));

                    $this->prices_m->save($price_data);
                    $c++;
                }
            }

            if ($id) {
                $result->msg = 'با موفقیت ثبت گردید';
                $this->session->set_flashdata('admin_success', $result->msg);
                $result->condition = true;
                $result->url = base_url('admin/products');
            }
        } else {
            $result->msg = validation_errors();
        }



        echo json_encode($result);
    }

    // Callback_text validation
    function text($value) {
        return true;
    }

    // Uplaod product image
    private function uploadImage($name = NULL, $path = '') {
        $result = new stdClass();
        $result->condition = FALSE;
        if ($name) {

            $this->load->library('upload');

            $output_dir = 'media/products/';
            if ($path) {
                $output_dir = $path;
            }
            $file_extension = pathinfo($_FILES[$name]['name'], PATHINFO_EXTENSION);
            $fileName = date('Ymd-His') . '-' . rand(1000, 9999) . '.' . $file_extension;
            $config['upload_path'] = $output_dir;
            $config['file_name'] = $fileName;
            $config['allowed_types'] = 'gif|jpg|png|webp';
            $config['max_size'] = 2048; //(in kilobyte) 2 MB = 2048 KB


            $this->upload->initialize($config);

            if (!$this->upload->do_upload($name)) {
                $result->error = array('error' => $this->upload->display_errors());
            //if (!move_uploaded_file($_FILES[$name]['tmp_name'], $output_dir . $fileName)) {
            //    $result->error = 'Error in uploading.';
            } else {
                $result->condition = TRUE;
                $result->file_name = $fileName;
                $result->file_path = $output_dir . $fileName;
            }
        }
        return $result;
    }

    // Remove image
    public function removeImage($id = 0) {
        $this->userHasPermission('products_edit', false);

        $result = new stdClass();
        $result->condition = FALSE;
        $id = intval($id);
        $product = $this->products_m->get_by('id, image', ['id' => $id], TRUE);
        if ($product) {
            if ($product->image && file_exists($product->image)) {
                unlink($product->image);
                $this->products_m->save(['image' => ''], $id);
            }
            $result->condition = TRUE;
        }

        echo json_encode($result);
    }

    // Remove large image
    public function removeLargeImage($id = 0) {
        $this->userHasPermission('products_edit', false);
        
        $result = new stdClass();
        $result->condition = FALSE;
        $id = intval($id);
        $product = $this->products_m->get_by('id, large_image', ['id' => $id], TRUE);
        if ($product) {
            if ($product->large_image && file_exists($product->large_image)) {
                unlink($product->large_image);
                $this->products_m->save(['large_image' => ''], $id);
            }
            $result->condition = TRUE;
        }

        echo json_encode($result);
    }

    // ِDelete product images and files from server
    private function deleteProductFiles($id) {
        $product = $this->products_m->get($id, TRUE);
        if ($product) {
            // حذف عکس کوچک
            if ($product->image != '' && file_exists($product->image)) {
                unlink($product->image);
            }
        }
    }

}

?>
