<?php
/**
 * @author Rayanik.com
 */
if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Profile extends Admin_Controller {

    function __construct() {
        parent::__construct();
    }

    function index() {
        $user = $this->users_m->get_by(NULL, array('id' => $this->user_login->id), TRUE);
        if ($user) {
            $this->data['user'] = $user;

            $this->data['meta_title'] = '';
            $this->data['breadcrumb'] = array('مشاهده و ویرایش مشخصات کاربری');
            $this->data['sub_title'] = '';

            $this->data['subview'] = 'admin/profile/index';
            $this->load->view('admin/_layout_main', $this->data);
        } else {
            redirect(base_url('admin/dashboard'));
        }
    }

    function save() {
        $result = new stdClass();
        $result->condition = false;
        $result->message = 'خطای امنیتی';

        $user = $this->users_m->get_by(NULL, array('id' => $this->user_login->id), TRUE);
        //اطمینان حاصل شود که پروفایل کاربری باشد که لاگین کرده است
        if ($user) {
            //general validation
            $this->form_validation->set_rules('first_name', 'نام', 'trim|required');
            $this->form_validation->set_rules('last_name', 'نام خانوادگی', 'trim|required');
            $this->form_validation->set_rules('email', 'ایمیل', 'valid_email');
            $this->form_validation->set_rules('cell_phone', 'تلفن همراه', 'exact_length[10]|regex_match[/^9\d{9}$/]');

            $this->form_validation->set_message('required', 'وارد کردن %s الزامی است');
            $this->form_validation->set_message('valid_email', 'لطفا %s را صحیح وارد کنید.');
            $this->form_validation->set_message('regex_match', 'لطفا %s را صحیح وارد کنید.');
            $this->form_validation->set_message('exact_length', 'فرمت تلفن همراه صحیح نیست. قالب صحیح : 9123456789');

            if ($this->form_validation->run() != FALSE) {
                //edit

                $data = array(
                    'first_name' => $this->security->xss_clean($this->input->post('first_name')),
                    'last_name' => $this->security->xss_clean($this->input->post('last_name')),
                    'cell_phone' => $this->input->post('cell_phone'),
                    'email' => $this->input->post('email'),
                );
                $this->users_m->save($data, $this->user_login->id);

                $result->msg = 'با موفقیت ثبت گردید';
                $this->session->set_flashdata('admin_success', $result->msg);
                $result->condition = true;
                $result->url = base_url('admin/dashboard');
            } else {
                $result->msg = validation_errors();
            }
        }

        echo json_encode($result);
    }

    public function changePasswordEdit() {
        $this->data['meta_title'] = '';
        $this->data['breadcrumb'] = array('تغییر رمز عبور');
        $this->data['sub_title'] = '';

        $this->data['subview'] = 'admin/profile/change_password';
        $this->load->view('admin/_layout_main', $this->data);
    }

    public function changePasswordSave() {

        $result = new stdClass();
        $result->condition = false;
        $result->message = 'خطای امنیتی';

        $this->form_validation->set_rules('old_password', 'رمز عبور قدیم', 'required');
        $this->form_validation->set_rules('password', 'رمز عبور جدید', 'required|matches[cf_password]|min_length[5]');
        $this->form_validation->set_rules('cf_password', 'تکرار رمز عبور جدید', 'required');

        $this->form_validation->set_message('required', 'وارد کردن فیلد %s الزامی است');
        $this->form_validation->set_message('min_length', '%s حداقل باید 5 کاراکتر باشد');
        $this->form_validation->set_message('matches', '%s با تکرارش باید برابر باشد');

        if ($this->form_validation->run() != FALSE) {
            $user_id = $this->user_login->id;

            $db_data = $this->users_m->get_by('password, username', array('id' => $user_id), true);
            $db_password = $db_data->password;

            $old_pass = $this->users_m->hash($this->input->post('old_password') . $db_data->username);

            if ($db_password == $old_pass) {
                $data['password'] = $this->users_m->hash($this->input->post('password') . $db_data->username);

                $this->users_m->save($data, $user_id);

                $result->msg = 'رمز عبور جدید شما ثبت گردید';
                $result->condition = true;
                $result->url = base_url('admin/dashboard');
            } else {
                $result->msg = 'رمز عبور قدیم صحیح نیست';
            }
        } else {
            $result->msg = validation_errors();
        }
        echo json_encode($result);
    }

}

?>