<?php

/**
 * @author Rayanik.com
 */
if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Sliders extends Admin_Controller
{

    function __construct()
    {
        parent::__construct();

        $this->load->model('sliders_m');
        $this->load->model('slider_items_m');
    }

    // load list sliders
    function index()
    {
        $this->userHasPermission('sliders');
        //$this->data['meta_title'] = '';
        $this->data['breadcrumb'] = array('اسلایدر');

        //css
        $css = array();
        array_push($css, 'assets/plugins/data-table/css/dataTables.bootstrap.css');
        $this->data['css'] = $css;

        //js
        $js = array();
        array_push($js, 'assets/plugins/data-table/js/jquery.dataTables.min.js');
        array_push($js, 'assets/plugins/data-table/js/dataTables.bootstrap.js');
        $this->data['js'] = $js;


        //sliders
        $this->data['sliders'] = $this->sliders_m->get();

        $this->data['subview'] = 'admin/slider/index';

        $this->load->view('admin/_layout_main', $this->data);
    }

    function view()
    {
        $this->userHasPermission('sliders', false);
        //sliders
        $this->data['sliders'] = $this->sliders_m->get();

        echo $this->load->view('admin/slider/index', $this->data, true);
    }

    //ordering
    function ordering($id = null, $value = null)
    {
        $value = intval($value);
        $id = intval($id);
        $data = array(
            'ordering' => $value
        );

        $result = new stdClass();
        $result->condition = false;
        $result->msg = 'خطا';

        $this->userHasPermission('sliders_edit', false, $result);

        if ($id > 0) {
            //به دست آوردن ترتیب فعلی این آیتم
            $slider = $this->sliders_m->get($id, TRUE);
            if ($slider) {
                //اگر تغییری نکرده بود
                if ($value == $slider->ordering) {
                    $result->msg = 'ترتیب نمایش تغییر نکرد.';
                } else {
                    $this->sliders_m->save($data, $id);
                    $result->msg = 'ترتیب با موفقیت تغییر کرد.';
                    $result->condition = true;
                }
            }
        }

        echo json_encode($result);
    }


    // Add and edit
    function edit($id = null)
    {
        $id = intval($id);
        $this->data['breadcrumb'] = 'اسلایدر';

        //css
        $css = array();
        array_push($css, 'assets/plugins/select2/dist/css/select2.min.css');
        $this->data['css'] = $css;

        //js
        $js = array();
        array_push($js, 'assets/plugins/select2/dist/js/select2.full.min.js');
        array_push($js, 'assets/plugins/select2/dist/js/i18n/fa.js');
        $this->data['js'] = $js;

        // Check exist
        if ($id != 0) {
            $slider = $this->sliders_m->get_by(null, ['id' => $id], true);
            if (!$slider)
                $id = 0;
        }

        // Slider items
        $slider_items = (object)[
            'category_ids' => [],
            'page_ids' => [],
            'statics' => [],
        ];

        if ($id) {
            // Edit 
            $this->userHasPermission('sliders_edit');
            
            $items = $this->slider_items_m->get_by(null, ['slider_id' => $id]);
            if($items){
                foreach ($items as $item) {
                    if($item->type == 'category'){
                        $slider_items->category_ids[] = $item->item_id;
                    } elseif($item->type == 'page'){
                        $slider_items->page_ids[] = $item->item_id;
                    } else {
                        $slider_items->statics[] = $item->type;
                    }
                }
            }

        } else {
            // Add 
            $this->userHasPermission('sliders_add');
            $slider = $this->sliders_m->getNew();
        }

        $this->data['slider'] = $slider;
        $this->data['slider_items'] = $slider_items;

        // Categories
        $this->load->model('categories_m');
        $categories = $this->categories_m->get_by('id, title_fa AS title', ['type' => 'product', 'deleted' => 0], false, 'ordering');
        $this->data['categories'] = ($categories) ? $categories : [];

        // Pages
        $this->load->model('pages_m');
        $pages = $this->pages_m->get_by('id, title', null, false, 'title');
        $this->data['pages'] = ($pages) ? $pages : [];

        // Statics
        $this->data['statics'] = [
            (object)['key' => 'home_page',  'title' => 'صفحه اصلی'],
            (object)['key' => 'contact_us', 'title' => 'تماس با ما'],
            (object)['key' => 'faqs',       'title' => 'سوالات متداول'],
        ];

        $this->data['subview'] = 'admin/slider/edit';
        $this->load->view('admin/_layout_main', $this->data);
    }

    // save 
    function save()
    {
        $result = new stdClass();
        $result->condition = false;
        $result->msg = 'خطای سیستمی.';
        $result->csrf = $this->security->get_csrf_hash();

        $id = intval($this->input->post('id'));

        //$this->form_validation->set_rules('title', 'عنوان اسلایدر', 'trim|required');
        $this->form_validation->set_rules('ordering', 'ترتیب نمایش', 'numeric|required');

        $this->form_validation->set_message('required', 'وارد کردن فیلد %s الزامی است');
        $this->form_validation->set_message('numeric', '%s باید عدد باشد');

        if ($this->form_validation->run() != FALSE) {

            $data = array(
                'title'    => $this->security->xss_clean($this->input->post('title')),
                'second_title'    => $this->security->xss_clean($this->input->post('second_title')),
                'btn_title'    => $this->security->xss_clean($this->input->post('btn_title')),
                'link'    => $this->security->xss_clean($this->input->post('link')),
                'ordering' => $this->input->post('ordering'),
                'publish'  => $this->input->post('publish') == 1 ? 1 : 0
            );

            // Image
            $image_result = $this->uploadImage('image');
            if ($image_result->condition) {
                $source_image = $image_result->file_path;
                /*
                list($width, $height, $type, $attr) = getimagesize($source_image);

                if ($width != 1300 || $height != 440) {
                    //در این حالت نیاز به برش و تغییر اندازه داریم 
                    $this->load->library('image_lib');
                    $config['source_image'] = $source_image;
                    $config['new_image'] = $source_image;
                    $config['maintain_ratio'] = FALSE;
                    $config['width'] = 1300;
                    $config['height'] = 440;

                    $this->image_lib->set_enlarge(TRUE);
                    $this->image_lib->thumb($config);
                }*/

                $data['image'] = $source_image;
            }

            // Image xs
            $result = $this->uploadImage('image_xs');
            if ($result->condition) {
                $source_image = $result->file_path;
                /*
                list($width, $height, $type, $attr) = getimagesize($source_image);
                if ($width !== 767 || $height !== 500) {
                    //در این حالت نیاز به برش و تغییر اندازه داریم 
                    $this->load->library('image_lib');
                    $config['source_image'] = $source_image;
                    $config['new_image'] = $source_image;
                    $config['maintain_ratio'] = FALSE;
                    $config['width'] = 767;
                    $config['height'] = 500;

                    $this->image_lib->set_enlarge(TRUE);
                    $this->image_lib->thumb($config);
                }*/

                $data['image_xs'] = $source_image;
            }

            //edit
            if ($id > 0) {
                $this->userHasPermission('sliders_edit', false, $result);
                $id = $this->sliders_m->save($data, $id);
            }
            //add
            else {
                $this->userHasPermission('sliders_add', false, $result);
                $id = $this->sliders_m->save($data);
            }

            if($id){
                // Slider items start
                // Posted items
                $posted_items = (object)[
                    'category_ids' => [],
                    'page_ids' => [],
                    'statics' => [],
                ];

                // Category
                $category_ids = $this->input->post('category_ids');
                if($category_ids && is_array($category_ids)){
                    $category_ids = array_unique($category_ids);
                    foreach ($category_ids as $category_id) {
                        $category_id = intval($category_id);
                        if($category_id > 0){
                            $posted_items->category_ids[] = $category_id;
                        }
                    }
                }

                // Page
                $page_ids = $this->input->post('page_ids');
                if($page_ids && is_array($page_ids)){
                    $page_ids = array_unique($page_ids);
                    foreach ($page_ids as $page_id) {
                        $page_id = intval($page_id);
                        if($page_id > 0){
                            $posted_items->page_ids[] = $page_id;
                        }
                    }
                }

                // Statics
                $statics = $this->input->post('statics');
                if($statics && is_array($statics)){
                    $statics = array_unique($statics);
                    foreach ($statics as $page) {
                        if(in_array($page, ['home_page', 'contact_us', 'faqs'])){
                            $posted_items->statics[] = $page;
                        }
                    }
                }

                // DB items
                $db_items = $this->slider_items_m->get_by(null, ['slider_id' => $id]);

                if($db_items){
                    foreach ($db_items as $db_key => $db_item) {
                        // Category
                        if($db_item->type == 'category' && in_array($db_item->item_id, $posted_items->category_ids)){
                            unset($db_items[$db_key]);
                            $posted_items->category_ids = array_diff($posted_items->category_ids, [$db_item->item_id]);
                        }

                        // Page
                        elseif($db_item->type == 'page' && in_array($db_item->item_id, $posted_items->page_ids)){
                            unset($db_items[$db_key]);
                            $posted_items->page_ids = array_diff($posted_items->page_ids, [$db_item->item_id]);
                        }

                        // Statics
                        elseif(in_array($db_item->type, $posted_items->statics)){
                            unset($db_items[$db_key]);
                            $posted_items->statics = array_diff($posted_items->statics, [$db_item->type]);
                        }
                    }
                }

                // Delete
                if($db_items){
                    $ids = array_map(function($item){
                        return $item->id;
                    }, $db_items);

                    $str_ids = implode(',', $ids);
                    $this->slider_items_m->delete_by(["id IN ($str_ids)" => null]);
                }

                // Insert
                $data_insert = [];

                // Category
                if($posted_items->category_ids){
                    foreach ($posted_items->category_ids as $category_id) {
                        $data_insert[] = [
                            'slider_id' => $id,
                            'type' => 'category',
                            'item_id' => $category_id,
                        ];
                    }
                }

                // Page
                if($posted_items->page_ids){
                    foreach ($posted_items->page_ids as $page_id) {
                        $data_insert[] = [
                            'slider_id' => $id,
                            'type' => 'page',
                            'item_id' => $page_id,
                        ];
                    }
                }

                // statics
                if($posted_items->statics){
                    foreach ($posted_items->statics as $page) {
                        $data_insert[] = [
                            'slider_id' => $id,
                            'type' => $page,
                            'item_id' => 0,
                        ];
                    }
                }

                if($data_insert){
                    $this->slider_items_m->insert_batch( $data_insert);
                }

                // Slider items end


                $result->msg = 'با موفقیت ثبت گردید.';
                $this->session->set_flashdata('admin_success', $result->msg);
                $result->condition = true;
                $result->url = base_url('admin/sliders');
            }

        } else {
            $result->msg = validation_errors();
        }

        echo json_encode($result);
    }

    function publish($id = '')
    {
        $data = array(
            'publish' => '1'
        );

        $result = new stdClass();
        $result->condition = false;
        $result->msg = 'موردی انتخاب نشده است.';

        $this->userHasPermission('sliders_edit', false, $result);

        $id = intval($id);
        if ($id > 0) {
            $this->sliders_m->update($data, $id);
            $result->msg = 'اسلایدر مورد نظر با موفقیت در وضعیت انتشار قرار گرفت.';
            $result->condition = true;
        } else {
            if ($checkb = $this->input->post('list_ids')) {
                $checkb = explode(',', $checkb);
                if (count($checkb)) {
                    foreach ($checkb as $id) {
                        $id = intval($id);
                        $this->sliders_m->update($data, $id);
                    }
                    $result->msg = 'اسلایدر های مورد نظر با موفقیت در وضعیت انتشار قرار گرفتند.';
                    $result->condition = true;
                }
            }
        }

        echo json_encode($result);
    }

    function un_publish($id = '')
    {
        $data = array(
            'publish' => '0'
        );

        $result = new stdClass();
        $result->condition = false;
        $result->msg = 'موردی انتخاب نشده است.';

        $this->userHasPermission('sliders_edit', false, $result);

        $id = intval($id);
        if ($id > 0) {
            $this->sliders_m->update($data, $id);
            $result->msg = 'اسلایدر مورد نظر با موفقیت در وضعیت عدم انتشار قرار گرفت.';
            $result->condition = true;
        } else {
            if ($checkb = $this->input->post('list_ids')) {
                $checkb = explode(',', $checkb);
                if (count($checkb)) {
                    foreach ($checkb as $id) {
                        $id = intval($id);
                        $this->sliders_m->update($data, $id);
                    }
                    $result->msg = 'اسلایدر های مورد نظر با موفقیت در وضعیت عدم انتشار قرار گرفتند.';
                    $result->condition = true;
                }
            }
        }

        echo json_encode($result);
    }

    function delete($id = '')
    {
        $result = new stdClass();
        $result->condition = false;
        $result->msg = 'موردی انتخاب نشده است.';

        $this->userHasPermission('sliders_delete', false, $result);


        $result->csrf = $this->security->get_csrf_hash();
        $ids = [];
        $id = intval($id);
        if ($id > 0) {
            $ids[] = $id;
        } else {
            if ($checkb = $this->input->post('list_ids')) {
                $checkb = explode(',', $checkb);
                if (count($checkb)) {
                    foreach ($checkb as $id) {
                        $id = intval($id);
                        $ids[] = $id;
                    }
                    
                }
            }
        }

        if($ids){
            $str_ids = implode(',', $ids);
            $items = $this->sliders_m->get_by('id, image, image_xs', ["id IN ($str_ids)" => null]);
            if($items){
                foreach ($items as $item) {
                    if ($item->image && file_exists($item->image)) {
                        unlink($item->image);
                    }
                    if ($item->image_xs && file_exists($item->image_xs)) {
                        unlink($item->image_xs);
                    }
                }

                $this->sliders_m->delete_by(["id IN ($str_ids)" => null]);
                $this->slider_items_m->delete_by(["slider_id IN ($str_ids)" => null]);

                if(count($items) == 1){
                    $result->msg = 'اسلایدر مورد نظر با موفقیت حذف شد.';
                }else{
                    $result->msg = 'اسلایدر های مورد نظر با موفقیت حذف شدند.';
                }

                $result->condition = true;
            }
        }

        echo json_encode($result, JSON_UNESCAPED_UNICODE);
    }

    // Upload image without crop and resize
    private function uploadImage($name = NULL, $path = '')
    {
        $result = new stdClass();
        $result->condition = FALSE;
        if ($name) {

            $this->load->library('upload');
            $output_dir = "media/sliders/";
            if (!file_exists($output_dir)) {
                mkdir($output_dir, 0755, true);
            }

            if ($path) {
                $output_dir = $path;
            }
            $file_extension = pathinfo($_FILES[$name]['name'], PATHINFO_EXTENSION);
            $fileName = date('Ymd-His') . '-' . rand(1000, 9999) . '.' . $file_extension;
            $config['upload_path'] = $output_dir;
            $config['file_name'] = $fileName;
            $config['allowed_types'] = 'gif|jpg|png';
            $config['max_size'] = 5120; //(in kilobyte) 5 MB = 5120 KB


            $this->upload->initialize($config);

            if (!$this->upload->do_upload($name)) {
                $result->error = array('error' => $this->upload->display_errors());
                //if (!move_uploaded_file($_FILES[$name]['tmp_name'], $output_dir.$fileName)) {
                //     $result->error = 'Error in uploading.';
            } else {
                $result->condition = TRUE;
                $result->file_name = $fileName;
                $result->file_path = $output_dir . $fileName;
            }
        }
        return $result;
    }

    // Remove image
    public function removeImage($id = 0, $type = null)
    {
        $result = new stdClass();
        $result->condition = FALSE;

        $this->userHasPermission('sliders_edit', false, $result);
        
        $id = intval($id);
        if ($id != 0) {
            $where = array(
                'id' => $id
            );
            $slider = $this->sliders_m->get_by(NULL, $where, TRUE);
            if ($slider) {
                if ($type == 'xs') {
                    if ($slider->image_xs && file_exists($slider->image_xs)) {
                        unlink($slider->image_xs);
                        $this->sliders_m->save(array('image_xs' => ''), $id);
                    }
                } else {
                    if ($slider->image && file_exists($slider->image)) {
                        unlink($slider->image);
                        $this->sliders_m->save(array('image' => ''), $id);
                    }
                }
                $result->condition = TRUE;
            }
        }

        echo json_encode($result);
    }
}
