<?php
/**
 * @author Rayanik.com
 */
if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Tree_categories extends Admin_Controller {

    private $allowed_list = array('product');

    function __construct() {
        parent::__construct();

        // چک کردن دسترسی با توجه به دسته مورد نظر
        $this->type = $this->uri->segment(4);
        if (!in_array($this->type, $this->allowed_list)) {
            redirect('admin/dashboard');
        }

        $this->load->model('categories_m');
        $this->load->library('tree');
    }

    //صفحه اصلی
    function index($type = 'product') {
        $this->userHasPermission("{$type}_categories");
        if (!in_array($type, $this->allowed_list)) {
            redirect('error/404');
        }

        //css
        $css = array();
        array_push($css, 'assets/plugins/nestable/nestable.css');
        $this->data['css'] = $css;

        //js
        $js = array();
        array_push($js, 'assets/plugins/nestable/jquery.nestable.js');
        array_push($js, 'assets/plugins/mark-js/jquery.mark.js');
        $this->data['js'] = $js;

        if ($type == 'product') {
            //$this->data['meta_title'] = '';
            $this->data['breadcrumb'] = array('دسته بندی محصولات');
            //$this->data['sub_title'] = '';
        }


        $this->data['type'] = $type;

        $this->data['subview'] = 'admin/tree_category/index';

        $this->load->view('admin/_layout_main', $this->data);
    }

    //view
    function view($type = 'product') {
        $this->userHasPermission("{$type}_categories", false);
        $this->data['type'] = $type;
        echo $this->load->view('admin/tree_category/index', $this->data, true);
    }

    //رسم
    function nestable($type = 'product') {
        $this->userHasPermission("{$type}_categories", false);
        $this->data['categories'] = NULL;
        if (in_array($type, $this->allowed_list)) {
            //tree_categories
            $categories = $this->categories_m->get_by(null, array('type' => $type));
            $this->data['categories'] = $categories;
        }

        $this->data['type'] = $type;
        echo $this->load->view('admin/tree_category/nestable', $this->data, true);
    }

    //edit
    function edit($type = 'product', $id = 0) {
        //js
        $js = array();
        array_push($js, 'assets/plugins/ckeditor-full/ckeditor.js');
        $this->data['js'] = $js;
        
        $this->data['breadcrumb'] = array(' دسته بندی');
        $id = intval($id);

        $category = $this->categories_m->get_by(null, array('id' => $id), true);
        
        if ($category) {
            $this->userHasPermission("{$type}_categories_edit");
        } else {
            $this->userHasPermission("{$type}_categories_add");
            $category = $this->categories_m->getNew();
            $category->type = $type;
        }

        // Order fields start

        $category->fields = ($category->fields) ? json_decode($category->fields) : [];
        
        // فیلد های ثابتی که داریم
        $statics = [];
        $statics_list = staticsFields();
        foreach ($statics_list as $key => $statics_options) {
            $statics[$key] = (object)[
                'statics_key' => $key,
                'title' =>  $statics_options->title,
                'ltr' =>  $statics_options->ltr,
                'use' => 0, 
                'required' => 0, 
                'ordering' => '' 
            ];
        }
        
        // لیست فیلد های ثابتی که قبلا برای این دسته ثبت شده است را جایگزین می‌کنیم و آن ها را از لیست حذف می کینم
        foreach ($category->fields as $key => $item) {
            if($item->statics_key){
                $statics[$item->statics_key]->use      = $item->use;
                $statics[$item->statics_key]->required = $item->required;
                $statics[$item->statics_key]->ordering = $item->ordering;
                unset($category->fields[$key]);
            }
        }
        
        $category->fields = array_merge(array_values($statics), $category->fields);

        // افزودن یک ردیف خالی به ته لیست
        $category->fields[] = (object)['statics_key' => '', 'title' => '', 'use' => 0, 'required' => 0, 'ltr' => 0, 'ordering' => '' ];
        // Order fields end


        $this->data['category'] = $category;
        $this->data['show_educarion_ui_modal'] = true;
        $this->data['subview'] = 'admin/tree_category/edit';
        $this->load->view('admin/_layout_main', $this->data);
    }

    //حذف آیتم مورد نظر و فرزندانش
    function delete($type = '', $id = '') {
        $data = array('deleted' => '1');

        $result = new stdClass();
        $result->condition = false;
        $result->msg = 'خطا سیستمی';
        
        $this->userHasPermission("{$type}_categories_delete", false, $result);

        $id = intval($id);
        if ($id > 0 && in_array($type, $this->allowed_list)) {
            $category = $this->categories_m->get_by('id', array('id' => $id, 'type' => $type), true);
            if ($category) {
                $this->categories_m->save($data, $id);
            }

            $result->msg = 'دسته ی مورد نظر با موفقیت حذف شد.';
            $result->condition = true;
        }
        echo json_encode($result);
    }

    function publish($type = '', $id = '') {
        $result = new stdClass();
        $result->condition = false;
        $result->msg = 'خطای سیستمی';

        $this->userHasPermission("{$type}_categories_edit", false, $result);

        $id = intval($id);
        if ($id > 0 && in_array($type, $this->allowed_list)) {

            $category = $this->categories_m->get_by('publish,id', array('id' => $id, 'type' => $type), true);
            if ($category) {
                if ($category->publish == 1) {
                    $data = array(
                        'publish' => '0'
                    );
                } else {
                    $data = array(
                        'publish' => '1'
                    );
                }

                $this->categories_m->save($data, $id);
            }

            $result->msg = 'با موفقیت ثبت گردید.';
            $result->condition = true;
        }

        echo json_encode($result);
    }

    // update
    function saveEdit($type = 'product') {
        $result = new stdClass();
        $result->csrf = $this->security->get_csrf_hash();
        $result->msg = '<div class="alert alert-danger">خطای سیستمی.</div>';
        $result->condition = false;
        $id = intval($this->input->post('id'));

        $category = $this->categories_m->get_by(null, array('id' => $id), true);
        if(!$category){
            $id = 0;
        }else{
            $type = $category->type;
        }

        if (in_array($type, $this->allowed_list)) {
            $this->form_validation->set_rules('title_fa', 'عنوان فارسی', 'trim|required');
            $this->form_validation->set_rules('field1_title', 'عنوان رمز اول', 'trim|required');
            $this->form_validation->set_rules('ordering', 'ترتیب نمایش', 'numeric|required');

            $this->form_validation->set_message('required', 'وارد کردن فیلد %s الزامی است');
            $this->form_validation->set_message('numeric', '%s باید مقداری صحیح و عدد باشد');


            if ($this->form_validation->run() != FALSE) {
                // Unique slug
                $slug = trim($this->security->xss_clean($this->input->post('slug')));
                $slug =  create_slug($slug);
                if($slug && (!$category || ($category && $category->slug != $slug))){
                    $exists = $this->categories_m->get_by('COUNT(id) AS number', [
                        'deleted' => 0,
                        'type' => 'product',
                        'slug' => $slug,
                    ], true)->number;
                    if($exists){
                        $result->msg = 'Slug وارد شده تکراری است.';
                        echo json_encode($result);
                        die();
                    }
                }

                // Order fields
                $fields = [];
                $posted_fields = $this->input->post('fields');
                foreach ($posted_fields as $key => $item) {
                    $statics_key = $this->input->post("fields[$key][statics_key]");
                    $title = trim($this->input->post("fields[$key][title]"));
                    if($statics_key || $title){
                        
                        $field = [
                            'statics_key' => $statics_key,
                            'use' => $this->input->post("fields[$key][use]") ? 1 : 0,
                            'required' => $this->input->post("fields[$key][required]") ? 1 : 0,
                            'ordering' => intval($this->input->post("fields[$key][ordering]")),
                        ];
                        
                        if(!$statics_key){
                            $field['title'] = $title;
                            $field['ltr'] = $this->input->post("fields[$key][ltr]") ? 1 : 0;
                        }
                        
                        $fields[] = $field;
                    }

                }


                $data = array(
                    'title_fa' => $this->security->xss_clean($this->input->post('title_fa')),
                    'title_en' => $this->security->xss_clean($this->input->post('title_en')),
                    'field1_title' => $this->security->xss_clean($this->input->post('field1_title')),
                    'field2_title' => $this->security->xss_clean($this->input->post('field2_title')),
                    'field3_title' => $this->security->xss_clean($this->input->post('field3_title')),
                    //'image' => $this->input->post('image'),
                    'type' => $type,
                    'ordering' => intval($this->input->post('ordering')),
                    'slug' => $slug,
                    'meta_title' => $this->security->xss_clean($this->input->post('meta_title')),
                    'meta_description' => $this->security->xss_clean($this->input->post('meta_description')),
                    'description' => $this->input->post('description'),
                    'fields' => json_encode($fields),
                );

                // Image
                $image_result = $this->uploadImage('image');
                if ($image_result->condition) {
                    $source_image = $image_result->file_path;
                    list($width, $height, $image_type, $attr) = getimagesize($source_image);

                    if ($width != 80 || $height != 80) {
                        //در این حالت نیاز به برش و تغییر اندازه داریم
                        $this->load->library('image_lib');
                        $config['source_image'] = $source_image;
                        $config['new_image'] = $source_image;
                        $config['maintain_ratio'] = FALSE;
                        $config['width'] = 80;
                        $config['height'] = 80;

                        $this->image_lib->set_enlarge(TRUE);
                        $this->image_lib->thumb($config);
                    }
                    $data['image'] = $source_image;
                }

                // Large image
                $image_result = $this->uploadImage('large_image');
                if ($image_result->condition) {
                    $source_image = $image_result->file_path;
                    list($width, $height, $image_type, $attr) = getimagesize($source_image);

                    if ($width != 480 || $height != 360) {
                        //در این حالت نیاز به برش و تغییر اندازه داریم
                        $this->load->library('image_lib');
                        $config['source_image'] = $source_image;
                        $config['new_image'] = $source_image;
                        $config['maintain_ratio'] = FALSE;
                        $config['width'] = 480;
                        $config['height'] = 360;

                        $this->image_lib->set_enlarge(TRUE);
                        $this->image_lib->thumb($config);
                    }
                    $data['large_image'] = $source_image;
                }

                if($id){
                    // تنظیم ترتیب نمایش قبلی ها
                    $this->userHasPermission("{$type}_categories_edit", false, $result);
                    $this->categories_m->updateOrdering($data['ordering'], $category->ordering);

                    $this->categories_m->save($data, $id);
                }else{
                    // تنظیم ترتیب نمایش قبلی ها
                    $this->userHasPermission("{$type}_categories_add", false, $result);
                    $this->categories_m->updateOrderingInInsert($data['ordering']);

                    $id = $this->categories_m->save($data);
                }



                $result->msg = 'با موفقیت ثبت گردید.';
                $this->session->set_flashdata('admin_success', $result->msg);
                $result->condition = true;
                $result->url = base_url("admin/tree_categories/index/$type");
            } else {
                $result->msg = validation_errors();
            }
        }

        echo json_encode($result);
    }

    // save
    function saveSort($type = 'product') {

        $result = new stdClass();
        $result->csrf = $this->security->get_csrf_hash();
        $result->condition = false;
        
        $this->userHasPermission("{$type}_categories_edit", false, $result);

        $data = $this->input->post();

        $this->form_validation->set_rules('list', 'لیست', 'trim|required');
        $this->form_validation->set_message('required', 'وارد کردن فیلد %s الزامی است');

        if ($this->form_validation->run() != FALSE) {
            $list = json_decode($data['list'], true);

            if (count($list)) {
                $this->saveList($list);
            }

            $result->msg = 'با موفقیت ثبت گردید';
            $result->condition = true;
        } else {
            $result->msg = validation_errors();
        }

        echo json_encode($result);
    }

    //ذخیره کل دسته بندی
    function saveList($list, $parent_id = 0, &$m_order = 0) {
        foreach ($list as $item) {
            $m_order++;

            $data = array(
                'parent_id' => $parent_id,
                'ordering' => $m_order
            );

            $this->categories_m->save($data, $item['id']);
        }
    }


    private function uploadImage($name = NULL) {
        $result = new stdClass();
        $result->condition = FALSE;
        if ($name) {

            $this->load->library('upload');
            $output_dir = 'media/categories/';
            if (!file_exists($output_dir)) {
                mkdir($output_dir, 0755, true);
            }
            $file_extension = pathinfo($_FILES[$name]['name'], PATHINFO_EXTENSION);
            $fileName = date('Ymd-His') . '-' . rand(1000, 9999) . '.' . $file_extension;
            $config['upload_path'] = $output_dir;
            $config['file_name'] = $fileName;
            $config['allowed_types'] = 'gif|jpg|png|webp';
            $config['max_size'] = 2048; //(in kilobyte) 2 MB = 2048 KB


            $this->upload->initialize($config);

            if (!$this->upload->do_upload($name)) {
                $result->error = array('error' => $this->upload->display_errors());
            //if (!move_uploaded_file($_FILES[$name]['tmp_name'], $output_dir.$fileName)) {
            //     $result->error = 'Error in uploading.';
            } else {
                $result->condition = TRUE;
                $result->file_name = $fileName;
                $result->file_path = $output_dir . $fileName;
            }
        }
        return $result;
    }


    // Remove image
    public function removeImage($type='',$id = 0) {
        $result = new stdClass();
        $result->condition = FALSE;

        $this->userHasPermission("{$type}_categories_edit", false, $result);


        $id = intval($id);
        $category = $this->categories_m->get_by('id, image', ['id' => $id], TRUE);
        if ($category) {
            if ($category->image && file_exists($category->image)) {
                unlink($category->image);
                $this->categories_m->save(['image' => ''], $id);
            }
            $result->condition = TRUE;
        }

        echo json_encode($result);
    }

    // Remove large image
    public function removeLargeImage($type='',$id = 0) {
        $result = new stdClass();
        $result->condition = FALSE;

        $this->userHasPermission("{$type}_categories_edit", false, $result);

        $id = intval($id);
        $category = $this->categories_m->get_by('id, large_image', ['id' => $id], TRUE);
        if ($category) {
            if ($category->large_image && file_exists($category->large_image)) {
                unlink($category->large_image);
                $this->categories_m->save(['large_image' => ''], $id);
            }
            $result->condition = TRUE;
        }

        echo json_encode($result);
    }
}
?>
