<?php
/**
 * @author Rayanik.com
 */
if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Admin_Controller extends MY_Controller {

    public $user_login = FALSE;
    public $login_name_session = 'karta_user_login';

    function __construct() {
        parent::__construct();
        $CI = get_instance();

        $this->load->database();
        $this->load->helper('genaral_helper');
        $this->load->helper('form');
        $this->load->model('users_m');
        $this->load->model('settings_m');
        $this->load->library('session');
        $this->load->library('pdate');
        $this->load->library('form_validation');
        $this->load->library('admin_general');

        date_default_timezone_set('Asia/Tehran');

        $shamsi_date = $this->pdate->date('l، Y/m/j');
        $this->data['date'] = $shamsi_date;

        // Settings
        $this->settings = $this->settings_m->getSettings(['version', 'admin_key', 'font', 'smart_block']);
        $this->data['access_to_smart_block'] = isset($this->settings->smart_block->active) ? true : false;

        // Login check - مسیرهایی که بدون دسترسی بازند
        $exception_uris = array(
            'admin/users/logout',
            // 'admin/users/remember_password'
        );
        $exception_uris[] = ($this->settings->admin_key) ? 'admin-'.$this->settings->admin_key : 'admin/users/login';

        if (!in_array(uri_string(), $exception_uris)) {
            $user = $this->session->userdata($this->login_name_session);
            if (!$user) {
                if($this->settings->admin_key){
                    redirect('errors/error404');
                } else {
                    redirect('admin/users/login');
                }
            } else {
                //اگر کاربر لاگین بود اطلاعاتش را می گیریم
                $this->data['user_login'] = FALSE;
                $user_login = $this->checkLogin();
                if ($user_login) {
                    $this->data['user_login'] = $user_login;
                    $this->user_login = $user_login;
                } else {
                    redirect('admin/users/logout');
                }
            }
            
            if(uri_string() !== 'admin/update'){

                //permission
                if($this->settings->version && version_compare($this->settings->version, '4.10.0') == -1){
                    $permissions = [];
                } else {
                    $permissions = $this->users_m->userAllPermission();
                }
                if($permissions){
                    $user_permissions = json_decode($permissions->permissions, TRUE);
                    if(!$user_permissions){
                        $user_permissions = [];
                    }
                    $this->data['user_permissions'] = $user_permissions;
                    $this->user_permissions = $user_permissions;
                }else{
                    $this->user_permissions = $this->data['user_permissions']= array();
                }
    
                // load admin menu types
                $this->load->model('menu_types_m');
                $this->data['menu_types'] = $this->menu_types_m->get();
    
                //تعداد سفارشات دیده نشده
                if(in_array('orders', $this->user_permissions)){
                    $this->load->model('orders_m');
                    $order = $this->orders_m->get_by('COUNT(id) as orders_count', null, true);
                    $not_reading_orders = $this->orders_m->get_by('count(id) as not_reading', array('reading' => '0'), true);
                    $this->data['orders_count'] = $order->orders_count;
                    $this->data['not_reading_order'] = $not_reading_orders->not_reading;
                }
    
    
                //تعداد پیام های خوانده نشده مدیر
                if(in_array('contacts', $this->user_permissions)){
                    $this->load->model('contacts_m');
                    $new_contact = $this->contacts_m->get_by('count(id) as new_contact', array('is_read' => '0'), true);
                    $this->data['new_contact'] = $new_contact->new_contact;
                }
    
                // تعداد پیام های تیکت خوانده نشده
                if(in_array('tickets', $this->user_permissions)){
                    $this->data['number_of_message'] = null;
                    if($this->settings->version && version_compare($this->settings->version, '4.6.0') == 1){
                        $this->load->model('tickets_m');
                        $this->data['number_of_message'] = $this->tickets_m->getUnreadMessagesByAdmin();
                    }
                }

                // تعداد تراکنش های کارت به کارت در انتظار تایید
                if(in_array('transactions', $this->user_permissions)){
                    $this->load->model('transactions_m');
                    $this->data['number_of_transaction'] = $this->transactions_m->get_by('COUNT(id) AS number', ['completed' => 0, 'reject' => 0, 'gateway' => 'card2card'], true)->number;
                }
            }
        }

        // Current version
        $this->data['current_version'] = $this->settings->version;
        
        // Admin font
        $this->data['font'] = json_decode($this->settings->font);
    }

    //check login
    function checkLogin() {

        $user = $this->session->userdata($this->login_name_session);

        if ($user) {
            $where = array(
                'id' => intval($user->id),
                'activation' => 1,
                'deleted' => 0
            );
            $user = $this->users_m->get_by('id, first_name, last_name, username, email, cell_phone, image, type', $where, TRUE);
            if ($user && ($user->type == 'admin')) {
                // کاربر رو در سشن بریز
                $data = array(
                    'id' => $user->id,
                    'first_name' => $user->first_name,
                    'last_name' => $user->last_name,
                    'user_name' => $user->username,
                    'email' => $user->email,
                    'cell_phone' => $user->cell_phone,
                    'type' => $user->type,
                    'image' => $user->image,
                    'loggedin' => TRUE
                );
                return json_decode(json_encode($data));
            }
        }

        return false;
    }

    // Get user permission
    public function userHasPermission($control, $redirect = true, $object = null) {
        if (!in_array($control, $this->user_permissions)) {
            if ($redirect === true) {
                $this->session->set_flashdata('error', 'شما مجوز دسترسی به این بخش را ندارید');
                redirect('admin/dashboard');
            } else {
                // return false;
                if($object){
                    $object->msg = 'شما مجوز دسترسی به این بخش را ندارید';
                    echo json_encode($object, JSON_UNESCAPED_UNICODE);
                    die();
                } else {
                    echo 'شما مجوز دسترسی به این بخش را ندارید';
                    die();
                }
            }
        }

        return true;
    }
}
