<?php
if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Kavenegar {
    private $err;

    public function get_error()
    {
        return strval($this->err);
    }

    public function send_by_token($api, $from, $receptor, $template, $token='', $token2='', $token3='') {
        $path = "http://api.kavenegar.com/v1/$api/verify/lookup.json";

        $token = trim($token);
        $token2 = trim($token2);
        $token3 = trim($token3);

        $params = array(
            "receptor" => $receptor,
            "token" => $token,
            "token2" => $token2,
            "token3" => $token3,
            "template" => $template,
            // "type" => $type
        );
        // if(func_num_args()>5){
        //     $arg_list = func_get_args();
        //     if(isset($arg_list[6]))
        //         $params["token10"]=$arg_list[6];
        //     if(isset($arg_list[7]))
        //         $params["token20"]=$arg_list[7];
        // } 
        return $this->execute($path, $params); 
    }

    public function send($api, $sender, $receptor, $message, $date = null, $type = null, $localid = null)
    {
        if (is_array($receptor)) {
            $receptor = implode(",", $receptor);
        }
        if (is_array($localid)) {
            $localid = implode(",", $localid);
        }
        $path   = "http://api.kavenegar.com/v1/$api/sms/send.json";;
        $params = array(
            "receptor" => $receptor,
            "sender" => $sender,
            "message" => $message,
            "date" => $date,
            "type" => $type,
            "localid" => $localid
        );
        return $this->execute($path, $params);
    }

    protected function execute($url, $data = null)
    {        
        $headers       = array(
            'Accept: application/json',
            'Content-Type: application/x-www-form-urlencoded',
            'charset: utf-8'
        );
        $fields_string = "";
        if (!is_null($data)) {
            $fields_string = http_build_query($data);
        }
        $handle = curl_init();
        curl_setopt($handle, CURLOPT_URL, $url);
        curl_setopt($handle, CURLOPT_HTTPHEADER, $headers);
        curl_setopt($handle, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($handle, CURLOPT_SSL_VERIFYHOST, false);
        curl_setopt($handle, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($handle, CURLOPT_POST, true);
        curl_setopt($handle, CURLOPT_POSTFIELDS, $fields_string);
        
        $response     = curl_exec($handle);
        //dd($response );

        $code         = curl_getinfo($handle, CURLINFO_HTTP_CODE);
        $content_type = curl_getinfo($handle, CURLINFO_CONTENT_TYPE);
        $curl_errno   = curl_errno($handle);
        $curl_error   = curl_error($handle);
        if ($curl_errno) {
            // throw new HttpException($curl_error, $curl_errno);
            $this->err = $curl_error;
            return false;
        }
        $json_response = json_decode($response);
        
        if ($code != 200 && is_null($json_response)) {
            // throw new HttpException("Request have errors", $code);
            $this->err = "Request have errors {$code}";
            return false;
        } else {
            $json_return = $json_response->return;
            if ($json_return->status != 200) {
                // throw new ApiException($json_return->message, $json_return->status);
                //dd( $json_return->message);
                $this->err = $json_return->message;
                return false;
            }
            // return $json_response->entries;
            return true;
        }
        
    }
}