<?php

defined('BASEPATH') or exit('No direct script access allowed');

/*
 * CodeIgniter Mellat gateway library
 *
 * @author    Mohammad Delavari Kashkoli (http://www.Rayanik.com)
 */

if (!class_exists('nusoap_client')) {
    require_once 'nusoap.php';
}

class Mellat {

    private $ERR;
    private $refId;
    private $terminalId = '';
    private $userName = '';
    private $userPassword = '';
    
    public function init($terminal, $username, $password) {
        $this->terminalId = $terminal;
        $this->userName = $username;
       $this->userPassword = $password;
    }

    public function request($orderId, $amount, $call_back) {
        $client = new nusoap_client('https://bpm.shaparak.ir/pgwchannel/services/pgw?wsdl', 'wsdl');
        $client->soap_defencoding = 'UTF-8';

        $parameters = array(
            'terminalId' => $this->terminalId,
            'userName' => $this->userName,
            'userPassword' => $this->userPassword,
            'orderId' => $orderId,
            'amount' => $amount,
            'localDate' => date('Ymd'),
            'localTime' => date('His'),
            'additionalData' => NULL,
            'callBackUrl' => $call_back,
            'payerId' => 0
        );

        $namespace = 'http://interfaces.core.sw.bps.com/';
        $result = $client->call('bpPayRequest', $parameters, $namespace);

        // Check for a fault
        if ($client->fault) {
            $this->ERR = $result;
        } else {
            // Check for errors
            $resultStr = $result['return'];
            $err = $client->getError();
            if ($err) {
                // Display the error
                $this->ERR = $err;
            } else {
                // Display the result
                $res = explode(',', $resultStr);

                $ResCode = $res[0];

                if ($ResCode == "0") {
                    $this->refId = $res[1];
                    return true;
                } else {
                    // log error in app
                    // Update table, log the error
                    // Show proper message to user
                }
            }// end Display the result
        }// end Check for errors

        return false;
    }

    public function redirect() {
        $CI = &get_instance();
        if (!function_exists('redirect')) {
            $CI->load->helper('url');
        }

        $html = '';
        $html .= '<html>';
        $html .= '<body>';
        $html .= '<script language="javascript">';
        $html .= 'var form = document.createElement("form");';
        $html .= 'form.setAttribute("method", "POST");';
        $html .= 'form.setAttribute("action", "https://bpm.shaparak.ir/pgwchannel/startpay.mellat");';
        $html .= 'form.setAttribute("target", "_self");';
        $html .= 'var hiddenField = document.createElement("input");';
        $html .= 'hiddenField.setAttribute("name", "RefId");';
        $html .= 'hiddenField.setAttribute("value", "' . $this->refId . '");';
        $html .= 'form.appendChild(hiddenField);';

        $html .= 'document.body.appendChild(form);';
        $html .= 'form.submit();';
        $html .= 'document.body.removeChild(form);';
        $html .= '</script>';
        $html .= '</body>';
        $html .= '</html>';
        echo $html;
    }

    public function get_error() {
        return $this->ERR;
    }

    public function get_refId() {
        return $this->refId;
    }

    public function verify($saleOrderId, $saleReferenceId) {
        $client = new nusoap_client('https://bpm.shaparak.ir/pgwchannel/services/pgw?wsdl', 'wsdl');
        $client->soap_defencoding = 'UTF-8';


        $parameters = array(
            'terminalId' => $this->terminalId,
            'userName' => $this->userName,
            'userPassword' => $this->userPassword,
            'orderId' => $saleOrderId,
            'saleOrderId' => $saleOrderId,
            'saleReferenceId' => $saleReferenceId
        );

        $namespace = 'http://interfaces.core.sw.bps.com/';
        $result = $client->call('bpVerifyRequest', $parameters, $namespace);
        
        if ($client->fault) {
            $this->ERR = $result;
        } else {

            
            $resultStr = $result['return'];

            $err = $client->getError();
            if ($err) {
                $this->ERR = $err;
            } else {
                if($resultStr == '0'){
                    return true;
                }
            }// end Display the result
        }// end Check for errors

        return false;
    }
    
    public function settle($saleOrderId, $saleReferenceId) {
        $client = new nusoap_client('https://bpm.shaparak.ir/pgwchannel/services/pgw?wsdl', 'wsdl');
        $client->soap_defencoding = 'UTF-8';


        $parameters = array(
            'terminalId' => $this->terminalId,
            'userName' => $this->userName,
            'userPassword' => $this->userPassword,
            'orderId' => $saleOrderId,
            'saleOrderId' => $saleOrderId,
            'saleReferenceId' => $saleReferenceId
        );
        

        $namespace = 'http://interfaces.core.sw.bps.com/';
        $result = $client->call('bpSettleRequest', $parameters, $namespace);
        
        if ($client->fault) {
            $this->ERR = $result;
        } else {

            
            $resultStr = $result['return'];

            $err = $client->getError();
            if ($err) {
                $this->ERR = $err;
            } else {
                if($resultStr == '0'){
                    return true;
                }
            }// end Display the result
        }// end Check for errors

        return false;
    }

    public function get_ref_id() {
        return $this->refid;
    }

}
