<?php

defined('BASEPATH') or exit('No direct script access allowed');

/*
 * CodeIgniter Parsian getway library
 *
 * @author              Rayanik (http://rayanik.com)
 * @package             Parsian
 */



class Saman
{
    //private $MID = '';
    //private $username = '';
    //private $password = '';
    
    private $RedirectURL;
    private $ERR;
    private $token;

    public function request($username, $amount, $order_id, $site_call_back_url)
    {
        try{
            ini_set ( "soap.wsdl_cache_enabled", "0" );
            $wsdl_url = "https://sep.shaparak.ir/payments/initpayment.asmx?WSDL";
            $client = new SoapClient ( $wsdl_url );
            
            $result = $client->RequestToken($username, $order_id, $amount);
            if(is_string($result) && !empty($result) && intval($result) >= 0){
                $this->token = $result;
                $this->RedirectURL = $site_call_back_url;
                return TRUE;
            }else{
                //اگر عدد منفی بود
                $this->ERR = "پاسخی از سمت بانک ارسال نشد.";
                return FALSE;
            }
        } catch (\Throwable $th) {
            // $th->getCode()
            return FALSE;
        }
        
    }

    public function redirect()
    {
        
        $form = "
                    <form style='display:none;' id='myForm' Method='post' Action='https://sep.shaparak.ir/payment.aspx'>
                        Token<input type='text' name='Token' value='$this->token' /><br />
                        RedirectURL<input type='text' name='RedirectURL' value='$this->RedirectURL' /><br />
                    </form>
                    <script language='javascript'>document.getElementById('myForm').submit();</script>
                ";
        echo $form;
        die();
    }

    public function getError()
    {
        return $this->ERR;
    }

    public function getToken()
    {
        return $this->token;
    }

    public function verify($username, $RefNum)
    {
        try{
            $wsdl_url = "https://verify.sep.ir/payments/referencepayment.asmx?WSDL";
            $client = new SoapClient ( $wsdl_url );
            $result = $client->VerifyTransaction($RefNum, $username);
            return $result;
        } catch (\Throwable $th) {
            // $th->getCode()
            return FALSE;
        }
    }
    
    public function reverseTransaction($username, $password, $RefNum)
    {
        try{
            $wsdl_url = "https://verify.sep.ir/payments/referencepayment.asmx?WSDL";
            $client = new SoapClient ( $wsdl_url );
            $result = $client->reverseTransaction($RefNum, $username, $username, $$password);
            //$result = $client->reverseTransaction($RefNum, $this->MID, $this->username, $this->$password);
            return $result;
        } catch (\Throwable $th) {
            // $th->getCode()
            return FALSE;
        }
    }

}
