<?php

defined('BASEPATH') or exit('No direct script access allowed');

class Zarinpal
{
    private $ERR;
    private $authority;
    private $url;
    private $refid;
    private $card_hash;

    public function get_authority()
    {
        return $this->authority;
    }

    public function get_error()
    {
        return $this->ERR;
    }

    public function get_ref_id()
    {
        return $this->refid;
    }

	public function redirect()
	{
        header('Location: '.$this->url);
        exit;
	}

	public function request($merchant_id, $amount, $description, $email="", $mobile="", $callback_url, $card_pan="")
	{
        $redirect_url = 'https://payment.zarinpal.com/pg/StartPay/';
		try{
            $curl = curl_init();

            $payment_data = [
                'merchant_id'  => $merchant_id, // Required
                'amount'       => $amount, // Required
                'callback_url' => $callback_url, // Required
                'description'  => $description, // Required
                'currency'     => 'IRT', // IRR or IRT
            ];

            $metadata = [];
            // if($order_id) $metadata['order_id'] = $order_id;
            if($mobile) $metadata['mobile'] = $mobile;
            if($email) $metadata['email'] = $email;
            if($card_pan) $metadata['card_pan'] = $card_pan;

            if($metadata) $payment_data['metadata'] = $metadata;
            

            $data_json = json_encode($payment_data);

            curl_setopt_array($curl, [
                CURLOPT_URL => 'https://payment.zarinpal.com/pg/v4/payment/request.json',
                CURLOPT_RETURNTRANSFER => true,
                CURLOPT_ENCODING => '',
                CURLOPT_MAXREDIRS => 10,
                CURLOPT_TIMEOUT => 0,
                CURLOPT_FOLLOWLOCATION => true,
                CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                CURLOPT_CUSTOMREQUEST => 'POST',
                CURLOPT_POSTFIELDS => $data_json,
                CURLOPT_HTTPHEADER => [
                    'Content-Type: application/json',
                    'Accept: application/json'
                ],
            ]);

            $response = json_decode(curl_exec($curl));
            curl_close($curl);
           
            if(isset($response->data->code) && $response->data->code === 100){
                $this->authority = $response->data->authority;
                $this->url = $redirect_url . $response->data->authority;
                return true;
            } elseif(isset($response->errors->code)) {
                // $this->ERR = $this->error_message($response->errors->code);
                $this->ERR = $response->errors->message . "(code:" . $response->errors->code. ")" ;
                return false;
            } else {
                // $this->ERR = $this->error_message();
                $this->ERR = isset($response->message) ? $response->message : 'Not found error message';
                return false;
            }
        } catch (\Throwable $th) {
            // $th->getCode()
            return false;
        }
	}

	public function verify($MerchantID, $Amount)
	{

        try{
            $data_json = json_encode([
                'merchant_id'  => $MerchantID,
                'amount'       => $Amount,
                'authority'    => (isset($_GET['Authority'])) ? $_GET['Authority'] : "",
                
            ]);

            $curl = curl_init();

            curl_setopt_array($curl, [
                CURLOPT_URL => 'https://payment.zarinpal.com/pg/v4/payment/verify.json',
                CURLOPT_RETURNTRANSFER => true,
                CURLOPT_ENCODING => '',
                CURLOPT_MAXREDIRS => 10,
                CURLOPT_TIMEOUT => 0,
                CURLOPT_FOLLOWLOCATION => true,
                CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                CURLOPT_CUSTOMREQUEST => 'POST',
                CURLOPT_POSTFIELDS => $data_json,
                CURLOPT_HTTPHEADER => [
                    'Content-Type: application/json',
                    'Accept: application/json'
                ],
            ]);

            $response = json_decode(curl_exec($curl));
            curl_close($curl);
            
            if(isset($response->data->code) && $response->data->code === 100){
                $this->card_hash = $response->data->card_hash;
                $this->refid = $response->data->ref_id;
                return true;
            } elseif(isset($response->errors->code)) {
                // $this->ERR = $this->error_message($response->errors->code);
                $this->ERR = $response->errors->message . "(code:" . $response->errors->code. ")" ;
                return false;
            } else {
                // $this->ERR = $this->error_message();
                $this->ERR = isset($response->message) ? $response->message : 'Not found error message';
                return false;
            }
        } catch (\Throwable $th) {
            // $th->getCode()
            return false;
        }
	} 
}
