<?php

defined('BASEPATH') or exit('No direct script access allowed');


class Zibal
{
    private $authority;
    private $errorCode;
    private $errorMessage;
    private $url;
    private $paid_amount;
    private $trans_id;

    function request($merchant_id, $amount, $call_back, $order_id = null, $mobile = null, $card_pan = null)
    {
        try {
            $parameters = [
                "merchant" => $merchant_id, //required
                "callbackUrl" => $call_back, //required
                "amount" => $amount, //required

                "orderId" => $order_id, //optional
                "mobile" => $mobile, //optional for mpg
            ];

            if($card_pan){
                $parameters['allowedCards'] = [$card_pan];
            }

            $ch = curl_init();
            curl_setopt($ch, CURLOPT_URL,'https://gateway.zibal.ir/v1/request');
            curl_setopt($ch, CURLOPT_HTTPHEADER, array('Content-Type: application/json'));
            curl_setopt($ch, CURLOPT_POST, 1);
            curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($parameters));
            // curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            $response  = curl_exec($ch);
            curl_close($ch);
            $response = json_decode($response);

            if ($response->result == 100) {
                $this->authority = $response->trackId;
                $this->url = "https://gateway.zibal.ir/start/" . $response->trackId;

                return true;
            } else {
                $this->errorCode = $response->result;
                $this->errorMessage = $response->message;

                return false;
            }
        } catch (\Throwable $th) {
            // $th->getCode()
            return false;
        }
    }

    function verify($merchant_id, $track_id)
    {
        try {
            $parameters = array(
                "merchant" => $merchant_id,//required
                "trackId" => $track_id,//required
            );

            $ch = curl_init();
            curl_setopt($ch, CURLOPT_URL,'https://gateway.zibal.ir/v1/verify');
            curl_setopt($ch, CURLOPT_HTTPHEADER, array('Content-Type: application/json'));
            curl_setopt($ch, CURLOPT_POST, 1);
            curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($parameters));
            // curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            $response  = curl_exec($ch);
            curl_close($ch);
            $response = json_decode($response);
            
            if ($response->result == 100) {
                $this->paid_amount = $response->amount;
                $this->trans_id = $response->refNumber;

                return true;
            } else {
                $this->errorCode = $response->result;
                $this->errorMessage = $response->message;

                return false;
            }
        } catch (\Throwable $th) {
            // $th->getCode()
            return false;
        }
    }

    public function get_authority()
    {
        return $this->authority;
    }

    public function redirect()
    {
        $CI = &get_instance();
        if (!function_exists('redirect')) {
            $CI->load->helper('url');
        }
        redirect($this->url);
    }

    public function get_error()
    {
        switch ($this->errorCode) {
            case '102':
                $error_message = 'merchant یافت نشد.';
                break;
            case '103':
                $error_message = 'merchant غیرفعال';
                break;
            case '104':
                $error_message = 'merchant نامعتبر';
                break;
            case '105':
                $error_message = 'مبلغ بایستی بزرگتر از 1,000 ریال باشد.';
                break;
            case '106':
                $error_message = 'callbackUrl نامعتبر می‌باشد. (شروع با http و یا https)';
                break;
            case '113':
                $error_message = 'مبلغ تراکنش از سقف میزان تراکنش بیشتر است.';
                break;
            case '201':
                $error_message = 'قبلا تایید شده.';
                break;
            case '202':
                $error_message = 'سفارش پرداخت نشده یا ناموفق بوده است.';
                break;
            case '203':
                $error_message = 'trackId نامعتبر می‌باشد';
                break;
            default:
                $error_message = $this->errorMessage;
        }
        
        return $error_message;
    }

    public function get_paid_amount()
    {
        return $this->paid_amount;
    }

    public function get_trans_id()
    {
        return $this->trans_id;
    }
}
