<?php
/**
 * @author Rayanik.com
 */
defined('BASEPATH') or exit('No direct script access allowed');

class Migration_Add_user_id_field_to_orders_table extends CI_Migration
{

    public function up()
    {
        $fields = array(
            'user_id' => array(
                'type' => 'INT',
                'constraint' => 11,
                'after' => 'id',
                'default' => 0,
            ),
        );
        $this->dbforge->add_column('orders', $fields);
        $this->db->query("ALTER TABLE {$this->db->dbprefix}orders ADD INDEX(user_id);");

        $this->load->model('orders_m');
        $this->load->model('users_m');
        
        // اول مشتریان را حذف می کنیم
        $this->users_m->delete_by(['type' => 'customer']);
        
        // به دست آوردن لیست نمام شماره همراه های که سفارش ثبت کرده اند
        // و آن ها را در دیتابیس ثبت می کنیم
        $cell_phones = $this->orders_m->getCellPhones();
        if($cell_phones){
            $data = [];
            $now = date('Y-m-d H:i:s');
            foreach ($cell_phones as $item) {
                $data[] = [
                    'username' => $item->cell_phone,
                    'cell_phone' => $item->cell_phone,
                    'type' => 'customer',
                    'deleted' => 0,
                    'block' => 0,
                    'activation' => 0,
                    'created' => $now,
                ];
            }
            $this->users_m->insert_batch($data);

            // حالا سفارشات را به کاربر ها وصل می کنیم
            $prefix = $this->db->dbprefix;
            $this->db->query("
                UPDATE {$prefix}orders orders
                INNER JOIN (
                    SELECT 
                        {$prefix}orders.id, 
                        {$prefix}users.id AS user_id
                    FROM {$prefix}orders 
                    JOIN {$prefix}users ON {$prefix}orders.cell_phone = {$prefix}users.cell_phone AND {$prefix}users.type = 'customer' AND {$prefix}users.deleted = 0 
                ) t_orders ON orders.id = t_orders.id
                SET orders.user_id = t_orders.user_id
            ");
        }
    }

    public function down()
    {
        // اول مشتریان را حذف می کنیم
        $this->load->model('users_m');
        $this->users_m->delete_by(['type' => 'customer']);

        $this->db->query("ALTER TABLE {$this->db->dbprefix}orders DROP INDEX user_id;");
        $this->dbforge->drop_column('orders', 'user_id');
    }
}
