<?php
/**
 * @author Rayanik.com
 */
defined('BASEPATH') or exit('No direct script access allowed');

class Migration_Insert_gateways extends CI_Migration
{

    public function up()
    {
        $dbprefix = $this->db->dbprefix;
        $this->load->model('transactions_m');
        $this->load->model('gateways_m');
        $this->gateways_m->_filter = [];

        // Lowercase title_en in gateways
        $this->db->query("UPDATE `{$dbprefix}gateways` SET title_en = LOWER(title_en)");

        // Lowercase gateway in transactions
        $this->db->query("UPDATE `{$dbprefix}transactions` SET gateway = LOWER(gateway)");

        // ابتدا لیست تمام درگاه های موجود را به دست می آوریم
        $db_gateways = $this->gateways_m->get();
        
        $gateways = [
            (object)['title_en' => 'zarinpal', 'title_fa' => 'زرین پال',],
            (object)['title_en' => 'mellat',   'title_fa' => 'ملت',     ],
            (object)['title_en' => 'saman',    'title_fa' => 'سامان',   ],
            (object)['title_en' => 'parsian',  'title_fa' => 'پارسیان', ],
            (object)['title_en' => 'saderat',  'title_fa' => 'صادرات',  ],
            (object)['title_en' => 'vandar',   'title_fa' => 'وندار',   ],
            (object)['title_en' => 'sepal',    'title_fa' => 'سپال',    ],
            (object)['title_en' => 'zibal',    'title_fa' => 'زیبال',   ],
            (object)['title_en' => 'idpay',    'title_fa' => 'آیدی پی', ],
            (object)['title_en' => 'nextpay',  'title_fa' => 'نکست پی', ],
            (object)['title_en' => 'bitpay',   'title_fa' => 'بیت پی',  ],
            // (object)['title_en' => 'vanda',    'title_fa' => 'وندا پرداخت'],
            // (object)['title_en' => 'payir',    'title_fa' => 'Pay.ir'],
        ];

        // مشترک ها را پیدا می کنیم
        if($db_gateways){
            foreach ($db_gateways as $db_key => $db_gateway) {
                foreach ($gateways as $key => $gateway) {
                    if($db_gateway->title_en == $gateway->title_en){
                        if($db_gateway->deleted == '1'){
                            $deleted_ids[] = $db_gateway->id;
                            $this->gateways_m->save([
                                'deleted' => 0, 
                                'publish' => 0,
                                'image' => "media/gateways/$gateway->title_en.png"
                            ], $db_gateway->id);
                        }
                        unset($gateways[$key]);
                        break;
                    }
                }
            }
        }

        // بریم سراغ جدید ها
        if($gateways){
            $data = [];
            foreach ($gateways as $key => $gateway) {
                $data[] = [
                    'title_en' => $gateway->title_en,
                    'title_fa' => $gateway->title_fa,
                    'image' => "media/gateways/$gateway->title_en.png",
                    'sandbox' => 0,
                    'is_default' => 0,
                    'ordering' => 0,
                    'publish' => 0,
                    'deleted' => 0,
                ];
            }
            $this->gateways_m->insert_batch($data);
        }
    }

    public function down()
    {
    }
}