<?php

defined('BASEPATH') or exit('No direct script access allowed');

class Migration_Add_tickets extends CI_Migration
{

    public function up()
    {
        $this->dbforge->add_field(array(
            'id' => array(
                'type' => 'INT',
                'constraint' => 11,
                'unsigned' => TRUE,
                'auto_increment' => TRUE
            ),
            'category_id' => array(
                'type' => 'INT',
                'constraint' => 11,
            ),
            'user_id' => array(
                'type' => 'INT',
                'constraint' => 11,
            ),
            'last_message_id' => array(
                'type' => 'INT',
                'constraint' => 11,
            ),
            'priority' => array(
                'type' => 'VARCHAR',
                'constraint' => 15,
                'comment' => 'low, normal, high'
            ),
            'status' => array(
                'type' => 'VARCHAR',
                'constraint' => 15,
                'comment' => 'open, close'
            ),
            'title' => array(
                'type' => 'VARCHAR',
                'constraint' => 127,
            ),
            'unread_admin' => array(
                'type' => 'INT',
                'constraint' => 11,
                'comment' => 'تعداد پیام های که ادمین مشاهده نکرده است',
            ),
            'unread_user' => array(
                'type' => 'INT',
                'constraint' => 11,
                'comment' => 'تعداد پیام های که کاربر مشاهده نکرده است',
            ),
            'updated' => array(
                'type' => 'VARCHAR',
                'constraint' => 20,
                'comment' => 'زمان آخرین پیام مشتری',
            ),
            'created' => array(
                'type' => 'VARCHAR',
                'constraint' => 20,
            ),
        ));
        $this->dbforge->add_key('id', TRUE);
        $this->dbforge->create_table('tickets');

        $this->db->query("ALTER TABLE {$this->db->dbprefix}tickets ADD INDEX(user_id);");

        // Insert default subjects
        $this->load->model('categories_m');
        $this->categories_m->insert_batch([
            ['type' => 'ticket', 'publish' => 1, 'deleted' => 0, 'ordering' => 1, 'title_fa' => 'فروش'],
            ['type' => 'ticket', 'publish' => 1, 'deleted' => 0, 'ordering' => 2, 'title_fa' => 'فنی'],
            ['type' => 'ticket', 'publish' => 1, 'deleted' => 0, 'ordering' => 3, 'title_fa' => 'سایر'],
        ]);
    }

    public function down()
    {
        $this->dbforge->drop_table('tickets');
    }
}
