<?php

defined('BASEPATH') or exit('No direct script access allowed');

class Migration_Add_messages extends CI_Migration
{

    public function up()
    {
        $this->dbforge->add_field(array(
            'id' => array(
                'type' => 'INT',
                'constraint' => 11,
                'unsigned' => TRUE,
                'auto_increment' => TRUE
            ),
            'ticket_id' => array(
                'type' => 'INT',
                'constraint' => 11,
            ),
            'user_id' => array(
                'type' => 'INT',
                'constraint' => 11,
            ),
            'text' => array(
                'type' => 'VARCHAR',
                'constraint' => 1023,
            ),
            'attach' => array(
                'type' => 'VARCHAR',
                'constraint' => 255,
            ),
            'reading' => array(
                'type' => 'INT',
                'constraint' => 1,
            ),
            'created' => array(
                'type' => 'VARCHAR',
                'constraint' => 20,
            ),
        ));
        $this->dbforge->add_key('id', TRUE);
        $this->dbforge->create_table('messages');

        $this->db->query("ALTER TABLE {$this->db->dbprefix}messages ADD INDEX(ticket_id);");
        $this->db->query("ALTER TABLE {$this->db->dbprefix}messages ADD INDEX(user_id);");
    }

    public function down()
    {
        $this->dbforge->drop_table('messages');
    }
}
