<?php
/**
 * @author Rayanik.com
 */
defined('BASEPATH') or exit('No direct script access allowed');

class Migration_Add_card2card_to_orders_table extends CI_Migration
{

    public function up()
    {
        if (!$this->db->field_exists('card2card', 'orders')){
            $fields = array(
                'card2card' => array(
                    'type' => 'VARCHAR',
                    'constraint' => 15,
                    'after' => 'pending',
                    'default' => '',
                    'comment' => 'empty for no card 2 card, pending, accept, reject',
                ),
            );
            $this->dbforge->add_column('orders', $fields);
        }
    }

    public function down()
    {
        if ($this->db->field_exists('card2card', 'orders')){
            $this->dbforge->drop_column('orders', 'card2card');
        }
    }
}
