<?php

defined('BASEPATH') or exit('No direct script access allowed');

class Migration_Add_transactions_new extends CI_Migration
{

    public function up()
    {
        $this->dbforge->add_field([
            'id' => [
                'type' => 'INT',
                'constraint' => 11,
                'unsigned' => TRUE,
                'auto_increment' => TRUE
            ],
            'order_id' => [
                'type' => 'INT',
                'constraint' => 11,
            ],
            'amount' => [
                'type' => 'BIGINT',
                'constraint' => 20,
            ],
            'type' => [
                'type' => 'VARCHAR',
                'constraint' => 31,
            ],
            'completed' => [
                'type' => 'TINYINT',
                'constraint' => 1,
            ],
            'reject' => [
                'type' => 'TINYINT',
                'constraint' => 1,
                'default' => 0,
                'comment' => 'اگر یک بود یعنی کارت به کارت رد شده است.',
            ],
            'gateway' => [
                'type' => 'VARCHAR',
                'constraint' => 31,
            ],
            'reference' => [
                'type' => 'VARCHAR',
                'constraint' => 127,
            ],
            'authority' => [
                'type' => 'VARCHAR',
                'constraint' => 127,
            ],
            'description' => [
                'type' => 'VARCHAR',
                'constraint' => 511,
            ],
            'detail' => [
                'type' => 'VARCHAR',
                'constraint' => 1023,
            ],
            'created' => [
                'type' => 'VARCHAR',
                'constraint' => 20,
            ],
        ]);
        $this->dbforge->add_key('id', TRUE);
        $this->dbforge->create_table('transactions_new');

        $this->db->query("ALTER TABLE {$this->db->dbprefix}transactions_new ADD INDEX(order_id);");
        $this->db->query("ALTER TABLE {$this->db->dbprefix}transactions_new ADD INDEX(completed);");
        $this->db->query("ALTER TABLE {$this->db->dbprefix}transactions_new ADD INDEX(type);");
    }

    public function down()
    {
        $this->dbforge->drop_table('transactions_new');
    }
}
