<?php
/**
 * @author Rayanik.com
 */
defined('BASEPATH') or exit('No direct script access allowed');

class Migration_Add_user_id_field_to_transactions_new extends CI_Migration
{

    public function up()
    {
        $fields = array(
            'user_id' => array(
                'type' => 'INT',
                'constraint' => 11,
                'after' => 'id',
                'default' => 0,
            ),
        );
        $this->dbforge->add_column('transactions_new', $fields);
        $this->db->query("ALTER TABLE {$this->db->dbprefix}transactions_new ADD INDEX(user_id);");

        // حالا تراکنش ها را به کاربر ها وصل می کنیم
        $prefix = $this->db->dbprefix;
        $this->db->query("
            UPDATE {$prefix}transactions_new transactions_new
            INNER JOIN (
                SELECT 
                    {$prefix}transactions_new.id, 
                    {$prefix}orders.user_id AS user_id
                FROM {$prefix}transactions_new 
                JOIN {$prefix}orders ON {$prefix}transactions_new.order_id = {$prefix}orders.id
            ) t_transactions_new ON transactions_new.id = t_transactions_new.id
            SET transactions_new.user_id = t_transactions_new.user_id
        ");
        
    }

    public function down()
    {
        $this->db->query("ALTER TABLE {$this->db->dbprefix}transactions_new DROP INDEX user_id;");
        $this->dbforge->drop_column('transactions_new', 'user_id');
    }
}
