<?php
/**
 * @author Rayanik.com
 */
defined('BASEPATH') or exit('No direct script access allowed');

class Migration_Add_min_qty_field_to_products extends CI_Migration
{

    public function up()
    {
        if (!$this->db->field_exists('min_qty', 'products')){
            $fields = array(
                'min_qty' => array(
                    'type' => 'INT',
                    'constraint' => 11,
                    'after' => 'max_qty',
                    'default' => 1,
                    'comment' => 'حداقل تعداد خرید کارت‌های محصول در یک سفارش',
                ),
            );
            $this->dbforge->add_column('products', $fields);
        }
    }

    public function down()
    {
        if ($this->db->field_exists('min_qty', 'products')){
            $this->dbforge->drop_column('products', 'min_qty');
        }
    }
}
