<?php
/**
 * @author Rayanik.com
 */
defined('BASEPATH') or exit('No direct script access allowed');

class Migration_Add_check_card_to_gateways extends CI_Migration
{

    public function up()
    {
        if (!$this->db->field_exists('check_card', 'gateways')){
            $fields = [
                'check_card' => [
                    'type' => 'VARCHAR',
                    'constraint' => 15,
                    'after' => 'token',
                    'default' => '',
                    'comment' => 'درگاه قابلیت چک کردن شماره کارت را دارد شامل مقادیر in_request, after_verify and empty',
                ],
            ];
            $this->dbforge->add_column('gateways', $fields);

            $this->load->model('gateways_m');
            $this->gateways_m->update_by(['check_card' => 'in_request'], ["title_en IN ('zibal', 'zarinpal')" => null]);
        }
    }

    public function down()
    {
        if ($this->db->field_exists('check_card', 'gateways')){
            $this->dbforge->drop_column('gateways', 'check_card');
        }
    }
}
