<?php

defined('BASEPATH') or exit('No direct script access allowed');

class Migration_Add_bank_cards_table extends CI_Migration
{

    public function up()
    {
        $this->dbforge->add_field([
            'id' => [
                'type' => 'INT',
                'constraint' => 11,
                'unsigned' => TRUE,
                'auto_increment' => TRUE
            ],
            'user_id' => [
                'type' => 'INT',
                'constraint' => 11,
            ],
            'card_number' => [
                'type' => 'VARCHAR',
                'constraint' => 16,
            ],
            'priority' => [
                'type' => 'TINYINT',
                'constraint' => 1,
            ],
            'deleted' => [
                'type' => 'TINYINT',
                'constraint' => 1,
            ],
            'created' => [
                'type' => 'VARCHAR',
                'constraint' => 20,
            ],
        ]);
        $this->dbforge->add_key('id', TRUE);
        $this->dbforge->create_table('bank_cards');

        $this->db->query("ALTER TABLE {$this->db->dbprefix}bank_cards ADD INDEX(user_id);");
        $this->db->query("ALTER TABLE {$this->db->dbprefix}bank_cards ADD INDEX(card_number);");

    }

    public function down()
    {
        $this->dbforge->drop_table('bank_cards');
    }
}
