<?php
/**
 * @author Rayanik.com
 */
defined('BASEPATH') OR exit('No direct script access allowed');

class Migration_Move_customer_upload extends CI_Migration {

    public function up()
    {
        $this->load->helper('file');

        $customer_upload = FCPATH . 'media/customer_upload/';
        $profiles        = FCPATH . 'media/profiles/';
        $tickets         = FCPATH . 'media/tickets/';

        // ساخت پوشه‌های جدید اگر وجود ندارن
        if (!is_dir($profiles)) mkdir($profiles, 0755, true);
        if (!is_dir($tickets)) mkdir($tickets, 0755, true);

        // --- نوشتن htaccess برای پوشه tickets ---
        $htaccess_content = <<<EOT
# جلوگیری از دسترسی مستقیم به فایل‌های تیکت
<Files "*">
    Order Allow,Deny
    Deny from all
</Files>

<IfModule mod_authz_core.c>
    Require all denied
</IfModule>
EOT;

        write_file($tickets . '.htaccess', $htaccess_content);

        // --- انتقال فایل‌ها ---
        if (is_dir($customer_upload)) {
            $files = scandir($customer_upload);

            foreach ($files as $file) {
                if ($file === '.' || $file === '..') continue;

                // فایل پروفایل: YYYYMMDD-HHMMSS-1234.jpg
                if (preg_match('/^\d{8}-\d{6}-\d{4}\./', $file)) {
                    $from = $customer_upload . $file;
                    $to = $profiles . $file;
                    if (!rename($from, $to)) {
                        if (copy($from, $to)) {
                            unlink($from);
                        } else {
                            // log_message('error', "Failed to move file: $file");
                        }
                    }
                }
                // فایل تیکت: YYYYMMDD-HHMMSS-abcde-abcdefghij.pdf
                elseif (preg_match('/^\d{8}-\d{6}-[a-zA-Z0-9]{5}-[a-zA-Z0-9]{10}\./', $file)) {
                    $from = $customer_upload . $file;
                    $to = $tickets . $file;
                    if (!rename($from, $to)) {
                        if (copy($from, $to)) {
                            unlink($from);
                        } else {
                            // log_message('error', "Failed to move file: $file");
                        }
                    }
                }
            }
        }

        $prefix = $this->db->dbprefix;

        // --- آپدیت دیتابیس: پروفایل‌ها ---
        $this->db->query("
            UPDATE {$prefix}users 
            SET image = REPLACE(image, 'media/customer_upload/', 'media/profiles/')
            WHERE image LIKE 'media/customer_upload/%'
        ");

        // --- آپدیت دیتابیس: اگر مسیر فایل‌های تیکت هم ذخیره میشه ---
        $this->db->query("
            UPDATE {$prefix}messages
            SET attach = REPLACE(attach, 'media/customer_upload/', 'media/tickets/')
            WHERE attach LIKE 'media/customer_upload/%'
        ");

        // --- حذف پوشه customer_upload اگر خالی شد ---
        if (is_dir($customer_upload)) {
            $remaining = scandir($customer_upload);
            if (count($remaining) <= 2) { // فقط "." و ".."
                rmdir($customer_upload);
            }
        }
    }

    public function down()
    {
        // Rollback معمولا برای این سناریو کاربرد نداره
    }
}
