<?php
/**
 * @author Rayanik.com
 */
defined('BASEPATH') OR exit('No direct script access allowed');

class Migration_Add_htaccess_in_cards_folder extends CI_Migration {

    public function up()
    {
        $this->load->helper('file');
        
        $cards = FCPATH . 'media/cards/';
       
        if (!is_dir($cards)) mkdir($cards, 0755, true);

        $htaccess_content = <<<EOT
# جلوگیری از دسترسی مستقیم به فایل‌های تیکت
<Files "*">
    Order Allow,Deny
    Deny from all
</Files>

<IfModule mod_authz_core.c>
    Require all denied
</IfModule>
EOT;

        write_file($cards . '.htaccess', $htaccess_content);

    }

    public function down()
    {
        
    }
}
