<?php
/**
 * @author Rayanik.com
 */
defined('BASEPATH') or exit('No direct script access allowed');

class Migration_Update_ticket_in_settings_for_allowed_user_files extends CI_Migration
{

    public function up()
    {
        $this->load->model('settings_m');
        $value = $this->settings_m->getSingle('ticket');
        $value = json_decode($value, true);
        $value['allowed_user_files'] = ['jpg', 'jpeg', 'png', 'docx', 'txt', 'pptx', 'ppt', 'pdf'];
        $new_value = json_encode($value, JSON_UNESCAPED_UNICODE);
        $this->settings_m->save(['value' => $new_value], 'ticket');
    }

    public function down()
    {
        $this->load->model('settings_m');
        $value = $this->settings_m->getSingle('ticket');
        $value = json_decode($value, true);
        unset($value['allowed_user_files']);
        $new_value = json_encode($value, JSON_UNESCAPED_UNICODE);
        $this->settings_m->save(['value' => $new_value], 'ticket');
    }
}