<?php
if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Coupons_m extends MY_Model {

    public $_table_name = 'coupons';
    public $_order_by = 'id DESC';
    public $_primary_key = 'id';
    public $_timestamps = false;

    //Begin coupons list ajax
    public $_table_ajax = 'coupons_view';
    var $column_order = array(null, null, 'title', 'code', 'amount', 'count', 'number_used', 'start_date', 'end_date', null); //set column field database for datatable orderable
    var $column_search = array('title', 'code', 'amount', 'count', 'number_used', 'start_date', 'end_date'); //set column field database for datatable searchable
    var $columns_search = array(); //set column field database for datatable searchable
    var $order = array('id' => 'DESC'); // default order
    var $filter = array(); // default filter
    //End coupons list ajax


    public function getNew() {
        $coupon = new stdClass();

        $coupon->id = '0';
        $coupon->title = '';
        $coupon->code = '';
        $coupon->amount = '';
        $coupon->discount_type = 'percent';
        $coupon->minimum = '';
        $coupon->publish = '1';
        $coupon->count = '';
        $coupon->start_date = '';
        $coupon->end_date = '';
        $coupon->used = '0';

        return $coupon;
    }

    public function getProducts($coupon_id){
        $prefix = $this->db->dbprefix;
        $this->db->select('products.id');
        //$this->db->select("CONCAT({$prefix}products.title, ' (',{$prefix}categories.title_fa,')') AS title");
        $this->db->select('products.title');
        $this->db->from('coupon_products');
        $this->db->join('products', "coupon_products.product_id = products.id AND coupon_products.coupon_id = '$coupon_id'");
        $this->db->join('categories', "products.category_id = categories.id");
        $this->db->where('products.deleted' , 0);
        $this->db->where('products.publish' , 1);
        $this->db->where('categories.deleted' , 0);
        $this->db->where('categories.publish' , 1);
        $this->db->order_by('categories.ordering, products.ordering');
        $query = $this->db->get();
        return $query->result();

    }
}
