<?php
/**
 * @author Rayanik.com
 */
if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Orders_m extends MY_Model {

    public $_table_name = 'orders';
    public $_order_by = 'id DESC';
    public $_primary_key = 'id';
    public $_timestamps = true;
    public $_filter=array();

    //BEGIN list ajax
    public $_table_ajax = 'orders_view';
    var $column_order = array(null, 'tracking_code', 'email', 'cell_phone', 'price', 'coupon_code', 'card2card', 'paid', 'pending', 'jalali_created', null); //set column field database for datatable orderable
    var $column_search = array('tracking_code', 'email', 'cell_phone', 'price', 'coupon_code', 'jalali_created'); //set column field database for datatable searchable
    var $columns_search = array('tracking_code', 'email', 'cell_phone', 'price', 'coupon_code', 'card2card', 'paid', 'pending','jalali_created'); //set column field database for datatable searchable
    var $filter = array(); // default filter
    var $order = array('id' => 'desc'); // default order
    //END list ajax
    
    
    function getStatistics($priod, $from_date=0){
        $date_length = ($priod=='month')?7:10;
        
        $this->db->select('SUM(price) AS total, COUNT(id) AS count, SUBSTR(jalali_created, 1, ' . $date_length . ') AS date_formatted');
        $this->db->from('orders');
        $this->db->where('jalali_created>', $from_date);
        $this->db->where('paid', 1);
        $this->db->group_by('date_formatted');
        $this->db->order_by('date_formatted DESC');
        
        $query = $this->db->get();
        return $query->result();
    }

    function getEmails(){
        $this->db->distinct('email');
        $this->db->select('email');
        $this->db->from('orders');
        $this->db->where('email <>', '');
        $this->db->order_by('email');
        $query = $this->db->get();
        return $query->result();
    }

    function getCellPhones(){
        $this->db->distinct('cell_phone');
        $this->db->select('cell_phone');
        $this->db->from('orders');
        $this->db->where('cell_phone <>', '');
        $this->db->order_by('cell_phone');
        $query = $this->db->get();
        return $query->result();
    }

    function saveWithTrans($data) {
        $user_id = $data['user_id'];
        $prefix = $this->db->dbprefix;

        // بررسی تعداد سفارش‌های کاربر در چند دقیقه گذشته
        $order_limit = 4; // حداکثر سفارش در بازه زمانی
        $order_time_limit = 300; // بازه زمانی سفارش به ثانیه
        $window_start_time = date('Y-m-d H:i:s', time() - $order_time_limit);

        $order_count = $this->db
            ->from('orders')
            ->where('user_id', $user_id)
            ->where('paid', 0)
            ->where('created >=', $window_start_time)
            ->count_all_results();

        if ($order_count >= $order_limit) {
            return (object)['status' => 'locked', 'message' => 'کاربر گرامی چند دقیقه دیگر سفارش خود را ثبت کنید.'];
        }
    
        $this->db->trans_start();
    
        try {
            // قفل‌گذاری روی آخرین سفارش کاربر
            $lastOrder = $this->db->query(
                "SELECT created FROM {$prefix}orders 
                 WHERE user_id = ? 
                 ORDER BY created DESC 
                 LIMIT 1 
                 FOR UPDATE", 
                [$user_id]
            )->row();

            if ($lastOrder) {
                $lastTime = strtotime($lastOrder->created);

                if (time() - $lastTime < 5) {
                    $this->db->trans_complete();
                    return (object)['status' => 'locked', 'message' => 'لطفاً چند لحظه صبر کنید.'];
                }
            }

            $data['created'] = date('Y-m-d H:i:s');
    
            // اگر قفل آزاد بود → سفارش ثبت کن
            if (!$this->db->insert('orders', $data)) {
                // خطای سیستمی هنگام insert
                $this->db->trans_complete();
                return (object)['status' => 'error', 'message' => 'خطای سیستمی هنگام ثبت سفارش.'];
            }
    
            $insert_id = $this->db->insert_id();
            $this->db->trans_complete();
    
            return (object)['status' => 'success', 'order_id' => $insert_id];
    
        } catch (Exception $e) {
            $this->db->trans_complete();
            return (object)['status' => 'error', 'message' => $e->getMessage()];
        }
    }
    
}
