<?php
/**
 * @author Rayanik.com
 */
if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Products_m extends MY_Model {

    public $_table_name = 'products';
    public $_order_by = 'id DESC';
    public $_primary_key = 'id';
    public $_timestamps = true;
    public $_filter=array('deleted' => '0');

    public function getNew() {
        $product = new stdClass();
        $product->id = 0;
        $product->category_id = 0;
        $product->title = '';
        $product->description = '';
        $product->deleted = 0;
        $product->publish = 1;
        $product->is_exists = 1;
        $product->is_special = 0;
        $product->ordering = '';
        $product->image = '';
        $product->large_image = '';
        $product->currency = 'tooman';
        $product->max_qty = '';
        $product->min_qty = '1';
        $product->manual = 0;
        $product->front_description = '';
        $product->slug = '';
        $product->meta_title = '';
        $product->meta_description = '';

        return $product;
    }

    public function getDetail($id = 0, $slug = '', $rate, $round_price){
        $slug =  trim($slug);
        if($id == 0 && $slug == ''){
            return null;
        }

        if($slug){
            $this->db->select('id');
            $this->db->from('products');
            $this->db->where('deleted', 0);
            $this->db->where('slug', $slug);
            
            $product = $this->db->get()->row();
            if(!$product){
                return null;
            }
            $id = $product->id;
        }

        return $this->getProducts((object)[
            'rate' => $rate,
            'round_price' => $round_price,
            'product_id' => $id,
        ]);

    }
    public function getProducts($params){
        $category_id = isset($params->category_id) ? $params->category_id : 0;
        $product_id = isset($params->product_id) ? $params->product_id : 0;
        $offset = isset($params->offset) ? intval($params->offset) : null;
        $limit = isset($params->limit) ? intval($params->limit) : null;
        $get_count = isset($params->get_count) ? $params->get_count : false;
    
        $prefix = $this->db->dbprefix;
        $now = $now = date('Y-m-d H:i:s');

        // به دست آوردن تعداد کارت های هر محصول
        if(!$get_count){
            $this->db->select("cards.product_id");
            $this->db->select("COUNT({$prefix}cards.id) AS max_qty");
            $this->db->from("cards");
            $this->db->where("cards.publish", 1);
            $this->db->where("cards.sold", 0);
            $this->db->where("cards.deactive_date <", $now);
            if($product_id){
                $this->db->where("cards.product_id", $product_id);
            }
            $this->db->group_by('cards.product_id');
            $sub_query = $this->db->get_compiled_select();
        }

        $where_category_id = ($category_id) ? " AND categories.id = '$category_id' " : '';
        $where_product_id = ($product_id) ? " AND products.id = '$product_id' " : '';

        $this->db->select("products.id AS id, products.title AS title, products.slug, products.image, products.large_image, products.is_exists, products.is_special, products.category_id, products.currency, products.min_qty");
        $this->db->select("prices.sell_price, prices.price, prices.from_qty, prices.to_qty");
        $this->db->select("categories.image AS category_image, categories.large_image AS category_large_image, categories.title_fa AS category_title");
        if($product_id){
            $this->db->select("products.meta_title, products.meta_description, products.front_description AS description");
            $this->db->select("categories.slug AS category_slug, categories.fields AS category_fields");
        }
        $this->db->select("
            IF(
                {$prefix}products.min_qty > t_cards.max_qty ,
                0,
                IF(
                    t_cards.max_qty AND {$prefix}products.max_qty,
                    LEAST(CONVERT(t_cards.max_qty, UNSIGNED), CONVERT({$prefix}products.max_qty, UNSIGNED)),
                    t_cards.max_qty
                ) 
            )
            AS max_qty
        ");
        $this->db->select("IF({$prefix}products.front_description <> '', 1, 0) AS has_description");
        $this->db->from("products");
        $this->db->join("categories","products.category_id=categories.id AND categories.deleted=0 AND categories.publish=1 AND products.publish=1 AND products.deleted=0 $where_category_id $where_product_id");
        $this->db->join("prices","products.id=prices.product_id AND prices.from_qty=1");

        if($get_count){
            return $this->db->count_all_results();
        }

        // Join with cards for inventory
        $this->db->join("($sub_query) t_cards","products.id = t_cards.product_id", 'left');


        // Order By
        $this->db->order_by('categories.ordering, products.ordering, products.id DESC');

        // Limit
        if($limit){
            $this->db->limit($limit, $offset);
        }

        
        $products = $this->db->get()->result();
        if($products){
            $rate = $params->rate;
            $round_price = $params->round_price;

            foreach ($products as $key => $product) {
                // Price
                if($product->currency == 'tooman'){
                    $product->price *= 1;
                    $product->sell_price *= 1;
                } else {
                    $currency = $product->currency;
                    $product->price = currency_to_tooman($product->price, $rate->$currency, $round_price);
                    $product->sell_price = currency_to_tooman($product->sell_price, $rate->$currency, $round_price);
                } 

                // Is exists?
                $product->max_qty = intval($product->max_qty);
                $product->is_exists = ($product->is_exists && $product->max_qty) ? 1 : 0;

                $products[$key] = $product;
            }

        }

        if($products && $product_id){
            return $products[0];
        }

        return $products;
    }

    public function getProductsWithNumberOfCardsForAdmin(){
        $prefix = $this->db->dbprefix;

        // به دست آوردن تعداد کارت های هر محصول
        $this->db->select("cards.product_id");
        $this->db->select("COUNT({$prefix}cards.id) AS max_qty");
        $this->db->from("cards");
        $this->db->where("cards.publish", 1);
        $this->db->where("cards.sold", 0);
        // $this->db->where("cards.deactive_date <", date('Y-m-d H:i:s'));
        $this->db->group_by('cards.product_id');
        $sub_query = $this->db->get_compiled_select();

        $this->db->select("products.id, products.category_id, products.title, products.is_exists,  products.publish");
        $this->db->select("categories.title_fa AS category_title");
        $this->db->select("IF(t_cards.max_qty, t_cards.max_qty, 0) AS number_of_cards");
        $this->db->from("products");
        $this->db->join("categories","products.category_id = categories.id AND categories.deleted = 0 AND products.deleted = 0");
        $this->db->join("($sub_query) t_cards","products.id = t_cards.product_id", 'left');
        $this->db->order_by('products.id DESC');

        $query = $this->db->get();
        return $query->result();
    }

    public function getProductsForAdmin(){
        $prefix = $this->db->dbprefix;
        $this->db->select("products.id AS id, products.title AS title");
        $this->db->select("categories.title_fa AS category_title");
        $this->db->from("products");
        $this->db->join("categories","products.category_id=categories.id AND categories.deleted=0  AND products.deleted=0");
        $this->db->order_by('categories.ordering, products.ordering');
        $query = $this->db->get();
        return $query->result();
    }

    // کارت های قابل فروش یک محصول خاص
    public function getProductCards($product_id, $limit=0){
        $prefix = $this->db->dbprefix;
        $now = $now = date('Y-m-d H:i:s');

        $this->db->from("cards");
        $this->db->where("product_id=$product_id AND publish=1");
        $this->db->where("sold=0 AND deactive_date<'{$now}'");
        if($limit){
            $this->db->limit($limit);
        }
        $query = $this->db->get();
        return $query->result();
    }

    public function getAllProductsPrices($product_id = 0){
        $where_product_id = ($product_id) ? " AND products.id = '$product_id' " : '';
        $this->db->select("prices.*, products.id AS product_id, products.currency AS product_currency");
        $this->db->from("prices");
        $this->db->join("products","prices.product_id=products.id $where_product_id");
        $this->db->where("products.publish=1 AND products.deleted=0");
        $query = $this->db->get();
        return $query->result();
    }

    public function getProductPrices($product_id){
        $this->db->from("prices");
        $this->db->where("product_id", $product_id);
        $query = $this->db->get();
        return $query->result();
    }

    public function getCountForDashboard(){
        $prefix = $this->db->dbprefix;
        $this->db->select("COUNT({$prefix}products.id) AS number");
        $this->db->from("products");
        $this->db->join("categories","products.category_id=categories.id AND categories.deleted=0  AND products.deleted=0");
        $query = $this->db->get();
        return $query->row()->number;
    }
}
