<?php
/**
 * @author Rayanik.com
 */
if (!defined('BASEPATH'))
    exit('No direct script access allowed');
?>

<div class="col-md-12">
    <div class="portlet box border shadow">
        <div class="portlet-heading">
            <div class="portlet-title">
                <h3 class="title">
                    <i class="icon-frane"></i>
                    <?= $sub_title ?>
                </h3>
            </div><!-- /.portlet-title -->
            <div class="buttons-box">
                <a class="btn btn-sm btn-default btn-round btn-collapse" rel="tooltip" title="کوچک کردن" href="#">
                    <i class="icon-arrow-up"></i>
                </a>
            </div><!-- /.buttons-box -->
        </div><!-- /.portlet-heading -->
        <div class="portlet-body">
            <div class="row">
                <div class="col col-md-12">
                    <?php if (in_array("{$type}_categories_add", $user_permissions)) : ?>
                        <a href="<?= base_url("admin/categories/edit/$type") ?>"  class="btn btn-primary has-tooltip btn-round btn-icon" title="جدید">
                            <i class="icon-plus"></i>
                        </a>
                    <?php endif; ?>
                    <?php if (in_array("{$type}_categories_edit", $user_permissions)) : ?>
                        <a href="javascript:void(0);"  onclick="insert('<?php echo base_url("admin/categories/publish/$type"); ?>', '#frm-main', '<?php echo base_url("admin/categories/view/$type"); ?>', '#res', '#msg', false, true, 'noty')" class="btn btn-success has-tooltip btn-round btn-icon" title="انتشار">
                            <i class="icon-eye"></i>
                        </a>
                        <a href="javascript:void(0);"  onclick="insert('<?php echo base_url("admin/categories/un_publish/$type"); ?>', '#frm-main', '<?php echo base_url("admin/categories/view/$type"); ?>', '#res', '#msg', false, true, 'noty')" class="btn btn-danger has-tooltip btn-round btn-icon" title="عدم انتشار">
                            <i class="icon-eye"></i>
                        </a>
                    <?php endif; ?>
                    <?php if (in_array("{$type}_categories_delete", $user_permissions)) : ?>
                        <a href="javascript:void(0);"  onclick="deleteRow('<?php echo base_url("admin/categories/delete/$type"); ?>', '#frm-main', '<?php echo base_url("admin/categories/view/$type"); ?>', '#res', 'delete', 'post')" class="btn btn-danger has-tooltip btn-round btn-icon" title="حذف">
                            <i class="icon-trash"></i>
                        </a>
                    <?php endif; ?>
                </div><!-- col -->
            </div><!-- row -->
            <div>
                <div id="lbl-ids"></div>
                <form method="post" id="frm-main">
                    <input type="hidden" name="<?php echo $this->security->get_csrf_token_name(); ?>" value="<?php echo $this->security->get_csrf_hash(); ?>">
                    <input type="hidden" id="txt-ids" name="list_ids"/>
                </form>
            </div>
            <br>
            <div class="table-responsive">
                <table class="table table-bordered table-hover table-striped" id="data-table">
                    <thead>
                        <tr>
                            <th><input type="checkbox" class="check-all"></th>
                            <th>#</th>
                            <th class="hidden">کد</th>
                            <th>عنوان</th>
                            <th class="center">عملیات</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php if ($categories): ?>
                            <?php foreach ($categories as $key => $category): ?>
                                <tr>
                                    <td><input type="checkbox" value="<?= $category->id ?>"></td>
                                    <td><?= $key + 1 ?></td>
                                    <td class="hide"><?= $category->id ?></td>
                                    <td><?= $category->title_fa ?></td>
                                    <td>
                                        <?php if (in_array("{$type}_categories_edit", $user_permissions)) : ?>
                                            <a class="btn btn-warning  btn-round btn-icon has-tooltip" title="ویرایش" href="<?= base_url("admin/categories/edit/$type/$category->id") ?>" ><i class="icon-pencil"></i></a>
                                            <?php if ($category->publish == 0): ?>
                                                <a class="btn btn-danger  btn-round btn-icon has-tooltip" title="عدم انتشار" href="javascript: void(0)" onclick="insert('<?= base_url("admin/categories/publish/$type/" . $category->id) ?>', '#frm-main', '<?= base_url("admin/categories/view/$type") ?>', '#res', '#msg', false, true, 'noty', 'GET')" ><i class="icon-eye"></i></a>
                                            <?php else: ?>
                                                <a class="btn btn-success  btn-round btn-icon has-tooltip" title="انتشار" href="javascript: void(0)" onclick="insert('<?= base_url("admin/categories/un_publish/$type/" . $category->id); ?>', '#frm-main', '<?= base_url("admin/categories/view/$type"); ?>', '#res', '#msg', false, true, 'noty', 'GET')"><i class="icon-eye"></i></a>
                                            <?php endif; ?>
                                        <?php endif; ?>
                                        <?php if (in_array("{$type}_categories_delete", $user_permissions)) : ?>
                                            <a class="btn btn-danger  btn-round btn-icon has-tooltip" title="حذف" href="javascript: void(0)" onclick="deleteRow('<?= base_url("admin/categories/delete/$type/" . $category->id); ?>', '#frm-main', '<?= base_url("admin/categories/view/$type"); ?>', '#res', 'delete', 'GET');"><i class="icon-trash"></i></a>
                                        <?php endif; ?>
                                    </td>
                                </tr>
                            <?php endforeach ?>
                        <?php endif ?>
                    </tbody>
                </table>
            </div><!-- /.table-responsive -->

        </div><!-- /.portlet-body -->
    </div><!-- /.portlet -->
</div><!-- /.col-md-12 -->

<script>
    $(document).ready(function() {
        var selectedMain = [];
        var tableMain = $('#data-table').DataTable({
            "pageLength": 25,
            "rowCallback": function(row, data) {
                //window.Modiran.initiCkeck();
            },
            "drawCallback": function( settings ) {
                chackAllStatus($('#data-table'));
            },
            "sPaginationType": "full_numbers",
            "columns": [
                {"data": "checkbox", "orderable": false, "class": "width-10 p-10"},
                {"data": "row", "orderable": false, "class": "width-10"},
                {"data": "DT_RowId"},
                {"data": "title"},
                {"data": "actions", "orderable": false}
            ],
            "order": []
        });

        // Select checkboxes
        $("#data-table tbody").on("ifChanged", "input", function (event) {
            var id = event.target.value;
            //var isChecked = event.target.checked;
            var index = $.inArray(id, selectedMain);
            if (index === -1) {
                selectedMain.push(id);
                $(this).closest("tr").addClass("selected");
            } else {
                selectedMain.splice(index, 1);
                $(this).closest("tr").removeClass("selected");
            }

            if (selectedMain.length == 0) {
                $("#lbl-ids").html("");
            } else {
                $("#lbl-ids").html(selectedMain.length + "مورد انتخاب شده است.");
            }

            $("#txt-ids").val(selectedMain);

            chackAllStatus($('#data-table'));
        });

        $(window).on('resize', function() {
            $('#data-table').css("width", "100%");
        });
    });
</script>
