<?php
$coupon->id = intval($coupon->id);
?>
<div class="col-md-8 col-md-offset-2" >
    <div class="portlet box border shadow">
        <div class="portlet-heading">
            <div class="portlet-title">
                <h3 class="title">
                    <i class="<?= $coupon->id == 0 ? 'icon-plus' : 'icon-note' ?>"></i>
                    <?= $coupon->id == 0 ? 'کوپن تخفیف جدید' : 'ویرایش کوپن تخفیف' ?>
                </h3>
            </div><!-- /.portlet-title -->
            <div class="buttons-box">
                <a class="btn btn-sm btn-default btn-round btn-collapse" rel="tooltip" title="کوچک کردن" href="#">
                    <i class="icon-arrow-up"></i>
                </a>
            </div><!-- /.buttons-box -->
        </div><!-- /.portlet-heading -->
        <div class="portlet-body">
            <div class="row">
                <div class="col-md-12 p-b-30">
                    <form id="form-data" role="form" method="POST">
                        <input type="hidden" name="<?= $this->security->get_csrf_token_name(); ?>" value="<?= $this->security->get_csrf_hash(); ?>">
                        <input type="hidden" value="<?= $coupon->id ?>" name="id">

                        <div class="form-body">
                            <div class="row">
                                <div class="col-sm-6">
                                    <div class="form-group">
                                        <label>عنوان</label>
                                        <input type="text" class="form-control" name="title" value="<?= $coupon->title ?>">
                                    </div><!-- /.form-group -->
                                </div><!-- /.col -->
                                <div class="col-sm-6">
                                    <div class="form-group">
                                        <label>کد کوپن</label>
                                        <input type="text" class="form-control ltr" name="code" value="<?= $coupon->code ?>">
                                    </div><!-- /.form-group -->
                                </div><!-- /.col -->
                                <div class="col-sm-6">
                                    <div class="form-group">
                                        <label>نوع تخفیف</label>
                                        <select  class="form-control" name="discount_type">
                                            <option value="percent" <?php if($coupon->discount_type == 'percent') echo 'selected';?> > درصد</option>
                                            <option value="price" <?php if($coupon->discount_type == 'price') echo 'selected';?> > مبلغ ثابت</option>
                                        </select>
                                    </div><!-- /.form-group -->
                                </div><!-- /.col -->
                                <div class="col-sm-6">
                                    <div class="form-group">
                                        <label>مقدار</label>
                                        <input type="text" class="form-control numeric separate ltr" name="amount" value="<?= (is_numeric($coupon->amount) ) ? number_format($coupon->amount) : ''; ?>">
                                    </div><!-- /.form-group -->
                                </div><!-- /.col -->
                                <div class="col-sm-6">
                                    <div class="form-group">
                                        <label>تعداد<span class="font-xs">(حداکثر تعداد سفارشی که می تواند از این کد استفاده کند)</span></label>
                                        <input type="text" class="form-control numeric ltr" name="count" value="<?= $coupon->count ?>">
                                    </div><!-- /.form-group -->
                                </div><!-- /.col -->
                                <div class="col-sm-6">
                                    <div class="form-group">
                                        <label>حداقل مبلغ سفارش(اختیاری)</label>
                                        <input type="text" class="form-control numeric separate ltr" name="minimum" value="<?= (is_numeric($coupon->minimum) && $coupon->minimum > 0) ? number_format($coupon->minimum) : ''; ?>">
                                    </div><!-- /.form-group -->
                                </div><!-- /.col -->
                                <div class="clearfix"></div>
                                <div class="col-sm-6">
                                    <div class="form-group">
                                        <label>تاریخ شروع</label>
                                        <input type="text"  class="form-control ltr" id="start-date" name="start_date" value="<?= $coupon->start_date ?>" autocomplete="off">
                                    </div><!-- /.form-group -->
                                </div><!-- /.col -->
                                <div class="col-sm-6">
                                    <div class="form-group">
                                        <label>تاریخ پایان</label>
                                        <input type="text"  class="form-control ltr" id="end-date" name="end_date" value="<?= $coupon->end_date ?>" autocomplete="off">
                                    </div><!-- /.form-group -->
                                </div><!-- /.col -->
                                <div class="col-sm-6">
                                    <div class="form-group">
                                        <label>برای</label>
                                        <select  class="form-control select2" multiple name="products[]" data-placeholder="همه">
                                            <option value=""></option>
                                            <?php if ($products): ?>
                                                <?php foreach ($products as $product): ?>
                                                    <?php $selected = in_array($product->id, $selected_products) ? 'selected' : ''; ?>
                                                    <option value="<?= $product->id ?>"  <?= $selected ?>  ><?= $product->title .'('. $product->category_title .')' ?></option>
                                                <?php endforeach; ?>
                                            <?php endif; ?>
                                        </select>
                                    </div><!-- /.form-group -->
                                </div><!-- /.col -->
                                <div class="col-sm-6">
                                    <div class="form-group">
                                        <label>وضعیت انتشار</label>
                                        <select  class="form-control" name="publish">
                                            <option value="1" <?php if($coupon->publish == 1) echo 'selected';?> > انتشار</option>
                                            <option value="0" <?php if($coupon->publish == 0) echo 'selected';?> > عدم انتشار</option>
                                        </select>
                                    </div><!-- /.form-group -->
                                </div><!-- /.col -->
                            </div><!-- /.row -->


                        </div><!-- /.form-body -->
                        <div class="form-actions">
                            <a class="btn btn-info btn-round btn-save" onclick="insert('<?= base_url('admin/coupons/save'); ?>', '#form-data', '', '', '#msg', false, true, 'sweetalert')" >
                                <i class="icon-check"></i>
                                ذخیره
                            </a>
                            <a href="<?= base_url('admin/coupons') ?>" class="btn btn-warning btn-round pull-left">
                                <i class="icon-close"></i>
                                بازگشت
                            </a>
                        </div><!-- /.form-actions -->
                    </form>
                </div><!-- /.col -->
            </div><!-- /.row -->
        </div><!-- /.portlet-body -->
    </div><!-- /.portlet -->
</div><!-- /.col-md-12 -->

<script>
    $(document).ready(function(){
        // datepicker config
        var datepicker = $("#start-date, #end-date").pDatepicker({
            format: "YYYY/MM/DD",
            observer: true,
            autoClose: true,
            toolbox: {
                calendarSwitch: {
                    enabled: false
                },
            },
            calendar:{
                persian: {
                    leapYearMode: 'astronomical'
                }
            }
        });

        $(".select2").select2({rtl: true});

    });
</script>
