<div class="col-md-12">
    <div class="portlet box border shadow">
        <div class="portlet-heading">
            <div class="portlet-title">
                <h3 class="title">   
                    <i class="icon-question"></i>
                    سوالات متداول
                </h3>
            </div><!-- /.portlet-title -->
            <div class="buttons-box">
                <a class="btn btn-sm btn-default btn-round btn-collapse" rel="tooltip" title="کوچک کردن" href="#">
                    <i class="icon-arrow-up"></i>
                </a>
            </div><!-- /.buttons-box -->
        </div><!-- /.portlet-heading -->
        <div class="portlet-body">
            <div class="row">
                <div class="col-md-12">
                    <?php if (in_array('faqs_add', $user_permissions)) : ?>
                        <a href="<?= base_url('admin/faqs/edit') ?>"  class="btn btn-primary has-tooltip btn-round btn-icon" title="جدید">
                            <i class="icon-plus"></i>                      
                        </a>
                    <?php endif; ?>
                    <?php if (in_array('faqs_edit', $user_permissions)) : ?>
                        <a href="javascript:void(0);"  onclick="insert('<?php echo base_url('admin/faqs/publish'); ?>', '#frm-main', '<?php echo base_url('admin/faqs/view'); ?>', '#res', '#msg', false, true, 'noty')" class="btn btn-success has-tooltip btn-round btn-icon" title="انتشار">
                            <i class="icon-eye"></i>                       
                        </a>
                        <a href="javascript:void(0);"  onclick="insert('<?php echo base_url('admin/faqs/un_publish'); ?>', '#frm-main', '<?php echo base_url('admin/faqs/view'); ?>', '#res', '#msg', false, true, 'noty')" class="btn btn-danger has-tooltip btn-round btn-icon" title="عدم انتشار">
                            <i class="icon-eye"></i>                       
                        </a>
                    <?php endif; ?>
                    <?php if (in_array('faqs_delete', $user_permissions)) : ?>
                        <a href="javascript:void(0);"  onclick="deleteRow('<?php echo base_url('admin/faqs/delete'); ?>', '#frm-main', '<?php echo base_url('/admin/faqs/view'); ?>', '#res', 'delete', 'post')" class="btn btn-danger has-tooltip btn-round btn-icon" title="حذف">
                            <i class="icon-trash"></i>                       
                        </a>
                    <?php endif; ?>
                </div><!-- /.col -->
                
                <div class="clearfix"></div>
                
                <div class="col-md-12">
                    <div>
                        <div id="lbl-ids"></div>
                        <form method="post" id="frm-main">
                            <input type="hidden" name="<?php echo $this->security->get_csrf_token_name(); ?>" value="<?php echo $this->security->get_csrf_hash(); ?>">
                            <input type="hidden" id="txt-ids" name="list_ids"/>
                        </form>
                    </div>
                    <br>
                    <div class="table-responsive">
                        <table class="table table-bordered table-hover table-striped" id="data-table">
                            <thead>
                                <tr>
                                    <th><input type="checkbox" class="check-all"></th>
                                    <th>#</th>
                                    <th class="hidden">کد</th>
                                    <th>عنوان</th>
                                    <th>ترتیب نمایش</th>
                                    <th style="min-width: 150px;">عملیات</th>
                                </tr>
                            </thead>
                            <tbody>	
                                <?php if ($faqs): ?>
                                    <?php foreach ($faqs as $key => $faq): ?>
                                        <tr>
                                            <td><input type="checkbox" value="<?= $faq->id ?>"></td>
                                            <td><?= $key+1 ?></td>
                                            <td><?= $faq->question ?></td>
                                            <td>
                                                <?php if (in_array('faqs_edit', $user_permissions)) : ?>
                                                    <input type="number" value="<?= $faq->ordering ?>" style="width:90px"  class="form-control has-tooltip numeric" data-min="1" onblur="insert('<?= base_url("admin/faqs/ordering/" . $faq->id ."/") ?>' + this.value, '#frm-main', '<?=base_url("admin/faqs/view")?>', '#res', '#msg', false, true, 'noty');" title="برای تغییر ترتیب نمایش بعد از اینکه آن را تغییر دادید ، خارج از جعبه متن کلیک کنید" >
                                                <?php else: ?>
                                                    <span><?= $faq->ordering ?></span>
                                                <?php endif; ?>
                                            </td>
                                            <td>
                                                <?php if (in_array('faqs_edit', $user_permissions)) : ?>
                                                    <a class="btn btn-warning  btn-round btn-icon has-tooltip" title="ویرایش" href="<?= base_url('admin/faqs/edit/' . $faq->id) ?>" ><i class="icon-pencil"></i></a>
                                                    <?php if ($faq->publish == 0) : ?>
                                                        <a class="btn btn-danger btn-round btn-icon has-tooltip" title="عدم انتشار" href="javascript: void(0)" onclick="insert('<?= base_url("admin/faqs/publish/" . $faq->id) ?>', '#frm-main', '<?= base_url("admin/faqs/view") ?>', '#res', '#msg', false, true, 'noty')" ><i class="icon-eye"></i></a>
                                                    <?php else: ?>
                                                        <a class="btn btn-success btn-round btn-icon has-tooltip" title="انتشار" href="javascript: void(0)" onclick="insert('<?php echo base_url('/admin/faqs/un_publish/') . $faq->id; ?>', '#frm-main', '<?php echo base_url('/admin/faqs/view'); ?>', '#res', '#msg', false, true, 'noty')"><i class="icon-eye"></i></a>
                                                    <?php endif; ?>
                                                <?php endif; ?>
                                                <?php if (in_array('faqs_delete', $user_permissions)) : ?>
                                                    <a class="btn btn-danger btn-round btn-icon has-tooltip" title="حذف" href="javascript: void(0)" onclick="deleteRow('<?php echo base_url('/admin/faqs/delete/') . $faq->id; ?>', '#frm-main', '<?php echo base_url('/admin/faqs/view'); ?>', '#res', 'delete');"><i class="icon-trash"></i></a>
                                                <?php endif; ?>
                                            </td>
                                        </tr>
                                    <?php endforeach; ?>
                                <?php endif; ?>
                            </tbody>
                        </table>
                    </div><!-- /.table-responsive -->
                </div><!-- /.col -->
            </div><!-- /.row -->
        </div><!-- /.portlet-body -->
    </div><!-- /.portlet -->
</div><!-- /.col-md-12 -->

<script>
    $(document).ready(function() {
        var selectedMain = [];
        var tableMain = $('#data-table').DataTable({
            "pageLength": 25,
            "sPaginationType": "full_numbers",
            "columns": [
                {"data": "checkbox", "orderable": false, "class": "width-10 p-10"},
                {"data": "row", "orderable": false, "class": "width-10"},
                {"data": "question"},
                {"data": "ordering"},
                {"data": "actions", "orderable": false}
            ],
            "rowCallback": function (row, data) {
            },
            "drawCallback": function( settings ) {
                chackAllStatus($('#data-table'));
            },
            "order": []
        });

         // Select checkboxes
        $('#data-table tbody').on('ifChanged', 'input', function (event) {

            var id = event.target.value;
            var index = $.inArray(id, selectedMain);
            if (index === -1) {
                selectedMain.push(id);
                $(this).closest("tr").addClass('selected');
            } else {
                selectedMain.splice(index, 1);
                $(this).closest("tr").removeClass('selected');
            }

            if (selectedMain.length == 0) {
                $("#lbl-ids").html("");
            } else {
                $("#lbl-ids").html(selectedMain.length + "مورد انتخاب شده است.");
            }

            $("#txt-ids").val(selectedMain);

            chackAllStatus($('#data-table'));
        });
        
        $(window).on('resize', function() {
            $('#data-table').css("width", "100%");
        });
    });
</script>


