<?php
$notice->id = intval($notice->id);
?>
<div class="col-md-10 col-md-offset-1" >
    <div class="portlet box border shadow">
        <div class="portlet-heading">
            <div class="portlet-title">
                <h3 class="title">
                    <i class="<?= $notice->id == 0 ? 'icon-plus' : 'icon-note' ?>"></i>
                    <?= $notice->id == 0 ? 'اطلاعیه جدید' : 'ویرایش اطلاعیه' ?>
                </h3>
            </div><!-- /.portlet-title -->
            <div class="buttons-box">
                <a class="btn btn-sm btn-default btn-round btn-collapse" rel="tooltip" title="کوچک کردن" href="#">
                    <i class="icon-arrow-up"></i>
                </a>
            </div><!-- /.buttons-box -->
        </div><!-- /.portlet-heading -->
        <div class="portlet-body">
            <div class="row">
                <div class="col-md-12 p-b-30">
                    <form id="form-data" role="form" method="POST">
                        <input type="hidden" name="<?= $this->security->get_csrf_token_name(); ?>" value="<?= $this->security->get_csrf_hash(); ?>">
                        <input type="hidden" value="<?= $notice->id ?>" name="id">

                        <div class="form-body">
                            <div class="row">
                                
                                <div class="col-sm-3">
                                    <div class="form-group">
                                        <label>تاریخ شروع <span class="text-danger">*</span></label>
                                        <input type="text"  class="form-control ltr" id="start-date" name="start_date" value="<?= $notice->start_date ?>" autocomplete="off">
                                    </div><!-- /.form-group -->
                                </div><!-- /.col -->
                                <div class="col-sm-3">
                                    <div class="form-group">
                                        <label>ساعت شروع <span class="text-danger">*</span></label>
                                        <input type="text"  class="form-control ltr" id="start-clock" name="start_clock" value="<?= $notice->start_clock ?>" autocomplete="off">
                                    </div><!-- /.form-group -->
                                </div><!-- /.col -->
                                <div class="col-sm-3">
                                    <div class="form-group">
                                        <label>تاریخ پایان <span class="text-danger">*</span></label>
                                        <input type="text"  class="form-control ltr" id="end-date" name="end_date" value="<?= $notice->end_date ?>" autocomplete="off">
                                    </div><!-- /.form-group -->
                                </div><!-- /.col -->
                                <div class="col-sm-3">
                                    <div class="form-group">
                                        <label>ساعت پایان <span class="text-danger">*</span></label>
                                        <input type="text"  class="form-control ltr" id="end-clock" name="end_clock" value="<?= $notice->end_clock ?>" autocomplete="off">
                                    </div><!-- /.form-group -->
                                </div><!-- /.col -->
                                
                                <div class="col-md-12">
                                    <div class="form-group">
                                        <label>عنوان <span class="text-danger">*</span></label>
                                        <input type="text" class="form-control" name="title" value="<?= $notice->title ?>">
                                    </div><!-- /.form-group -->
                                </div><!-- /.col -->
                                
                                <div class="col-sm-12">
                                    <div class="form-group">
                                        <label>متن اطلاعیه <span class="text-danger">*</span></label>
                                        <textarea class="form-control summernote" name="content" rows="10"><?= htmlspecialchars($notice->content) ?></textarea>
                                    </div>
                                </div><!-- /.col -->
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label>وضعیت انتشار <span class="text-danger">*</span></label>
                                        <select  class="form-control" name="publish">
                                            <option value="1" <?php if($notice->publish == 1) echo 'selected';?> > انتشار</option>
                                            <option value="0" <?php if($notice->publish == 0) echo 'selected';?> > عدم انتشار</option>
                                        </select>
                                    </div><!-- /.form-group -->
                                </div><!-- /.col -->
                            </div><!-- /.row -->
                        </div><!-- /.form-body -->
                        <div class="form-actions">
                            <a class="btn btn-info btn-round btn-save" onclick="insert('<?= base_url('admin/notices/save'); ?>', '#form-data', '', '', '#msg', false, true, 'sweetalert')" >
                                <i class="icon-check"></i>
                                ذخیره
                            </a>
                            <a href="<?= base_url('admin/notices') ?>" class="btn btn-warning btn-round pull-left">
                                <i class="icon-close"></i>
                                بازگشت
                            </a>
                        </div><!-- /.form-actions -->
                    </form>
                </div><!-- /.col -->
            </div><!-- /.row -->
        </div><!-- /.portlet-body -->
    </div><!-- /.portlet -->
</div><!-- /.col-md-12 -->

<script>
    function uploadImage(image, element) {
        var data = new FormData();
        data.append("image", image);
        $.ajax({
            data: data,
            type: "POST",
            url: baseUrl + "admin/notices/uploadImage",
            cache: false,
            contentType: false,
            processData: false,
            success: function(url) {
                //editor.insertImage(welEditable, url);
                var image = baseUrl + url;
                element.summernote("insertImage", image);
            }
        });
    }

    $(document).ready(function(){
        // Datepicker config
        let datepicker = $("#start-date, #end-date").pDatepicker({
            format: "YYYY/MM/DD",
            observer: true,
            autoClose: true,
            toolbox: {
                calendarSwitch: {
                    enabled: false
                },
            },
            calendar:{
                persian: {
                    leapYearMode: 'astronomical'
                }
            }
        });

        // Clockpicker config
        $('#start-clock, #end-clock').clockpicker({
            donetext: 'قبول',
            format: "HH:mm",
            twelvehour: false,
            autoclose: true,
            leadingZeroHours: true,
        });

        // Summernote
        $(".summernote").summernote({
            toolbar: [
                // ['style', ['style']],
                ['font', ['bold', 'italic', 'underline', 'clear']],
                // ['fontname', ['fontname']],
                ['color', ['color']],
                ['para', ['ul', 'ol', 'paragraph']],
                // ['height', ['height']],
                // ['table', ['table']],
                ['insert', ['link', 'picture', 'hr']],
                ['view', ['fullscreen', 'codeview']],
                ['help', ['help']]
            ],
            callbacks: {
                onImageUpload: function(image) {
                    uploadImage(image[0], $(this));
                },
                onPaste: function (e) {
                    var bufferText = ((e.originalEvent || e).clipboardData || window.clipboardData).getData('Text');
                    e.preventDefault();
                    document.execCommand('insertText', false, bufferText);
                }
            }
        });
        $('div.note-editable').css({ 'min-height': 200 + 'px'});
    });
</script>
