<?php
/**
 * @author Rayanik.com
 */
if (!defined('BASEPATH'))
    exit('No direct script access allowed');

$page->id = intval($page->id);
?>
<div class="col-md-12">
    <div class="portlet box border shadow">
        <div class="portlet-heading">
            <div class="portlet-title">
                <h3 class="title">                                        
                    <i class="<?= $page->id == 0 ? 'icon-plus' : 'icon-note' ?>"></i>
                    <?= $page->id == 0 ? 'صفحه جدید' : 'ویرایش صفحه' ?>
                </h3>
            </div><!-- /.portlet-title -->
            <div class="buttons-box">
                <a class="btn btn-sm btn-default btn-round btn-collapse" rel="tooltip" title="کوچک کردن" href="#">
                    <i class="icon-arrow-up"></i>
                </a>
            </div><!-- /.buttons-box -->
        </div><!-- /.portlet-heading -->
        <div class="portlet-body">
            <div class="row">
                <div class="col-md-12 p-b-30">
                    <form id="form-data" role="form" method="POST">
                        <input type="hidden" name="<?php echo $this->security->get_csrf_token_name(); ?>" value="<?php echo $this->security->get_csrf_hash(); ?>">
                        <input type="hidden" value="<?= $page->id ?>" name="id">

                        <div class="form-body">
                            <div class="row">                                
                                <div class="col-sm-6">                                
                                    <div class="form-group">
                                        <label>عنوان صفحه</label>
                                        <input type="text" class="form-control" name="title" value="<?= $page->title ?>">
                                    </div><!-- /.form-group -->
                                </div><!-- /.col -->
                                <div class="col-sm-6">                                
                                    <label>Slug (فاصله ها با - جایگزین خواهند شد)</label>
                                    <div class="form-group">
                                        <input type="text" class="form-control" name="slug" value="<?= $page->slug ?>">
                                    </div><!-- /.form-group -->
                                </div><!-- /.col -->
                            </div><!-- /.row -->

                            <div class="form-group m-b-20">
                                <label>محتوای صفحه</label>
                                <textarea name="content" class="hide" id="content"><?= $page->content ?></textarea>
                                <div id="editor"></div>
                            </div><!-- /.form-group -->

                            <div class="form-group m-b-20">
                                <label for="meta_title">متای عنوان(عنوان  مختصر و مفید تا حدود 65 حرف)</label>
                                <input id="meta_title" name="meta_title" class="form-control" value="<?= $page->meta_title ?>">
                            </div><!-- /.form-group -->
                            <div class="form-group m-b-20">
                                <label for="meta_description">متای توضیحات(حدود 155 حرف)</label>
                                <textarea id="meta_description" name="meta_description" rows="4" class="form-control"><?= $page->meta_description ?></textarea>
                            </div><!-- /.form-group -->
                            <div class="form-group m-b-20">
                                <label for="meta_keywords">متای کلمات کلیدی(کلمات را با , از هم جدا کنید)</label>
                                <textarea id="meta_keywords" name="meta_keywords" rows="4" class="form-control"><?= $page->meta_keywords ?></textarea>
                            </div><!-- /.form-group -->
                        </div><!-- /.form-body -->
                        <div class="form-actions">
                            <a class="btn btn-info btn-round btn-save">
                                <i class="icon-check"></i>
                                ذخیره
                            </a>
                            <a href="<?= base_url('admin/pages') ?>" class="btn btn-warning btn-round pull-left">
                                <i class="icon-close"></i>
                                بازگشت
                            </a>
                        </div><!-- /.form-actions -->
                    </form>
                </div><!-- /.col -->
            </div><!-- /.row -->
        </div><!-- /.portlet-body -->
    </div><!-- /.portlet -->
</div><!-- /.col-md-12 -->


<script>
    $(document).ready(function() {
        var editor;
        var config = {};

        function createPersianEditor(config) {
            editor = CKEDITOR.appendTo('editor', config);
            editor.setData($("#content").val());
        }

        //to enable uplaod image plugin
        config.extraPlugins = 'simage';
        config.imageUploadURL = baseUrl + 'admin/media/upload_ckeditor/';
        config.dataParser = function(data) {
            return data.url;
        };
        
        config.ContentLangDirection = 'rtl';
        config.language = 'fa';
        config.font_names =
                "Tahoma;" +
                "Nazanin/Nazanin, B Nazanin, BNazanin;" +
                "Yekan/Yekan, BYekan, B Yekan, Web Yekan;" +
                "IranSans/IranSans;" +
                "Parastoo/Parastoo;" +
                "Arial/Arial, Helvetica, sans-serif;" +
                "Times New Roman/Times New Roman, Times, serif;";
        createPersianEditor(config);
        


        $(".btn-save").click(function(e) {
            e.preventDefault();
            $("#content").val(editor.getData());
            insert('<?php echo base_url('admin/pages/save'); ?>', '#form-data', '', '', '#msg', false, true, 'sweetalert');
        });

    });
</script>