<?php
/**
 * @author Rayanik.com
 */
if (!defined('BASEPATH'))
    exit('No direct script access allowed');
?>
<div class="col-md-12">
    <div class="portlet box border shadow">
        <div class="portlet-heading">
            <div class="portlet-title">
                <h3 class="title">
                    <i class="icon-shield"></i>
                    سطوح دسترسی
                </h3>
            </div><!-- /.portlet-title -->
            <div class="buttons-box">
                <a class="btn btn-sm btn-default btn-round btn-collapse" rel="tooltip" title="کوچک کردن" href="#">
                    <i class="icon-arrow-up"></i>
                </a>
            </div><!-- /.buttons-box -->
        </div><!-- /.portlet-heading -->
        <div class="portlet-body">
            <div class="row">
                <div class="col col-md-12">
                    <?php
                    if (in_array('permissions_add', $user_permissions)) {
                        ?>
                        <a href="<?= base_url('admin/permissions/edit') ?>"  class="btn btn-primary has-tooltip btn-round btn-icon" title="جدید">
                            <i class="icon-plus"></i>
                        </a>
                        <?php
                    }
                    ?>
                </div><!-- col -->
            </div><!-- row -->
            <br>
            <div class="table-responsive">
                <table class="table table-bordered table-hover table-striped" id="data-table">
                    <thead>
                        <tr>
                            <th>ردیف</th>
                            <th>نام گروه</th>
                            <th>نقش پیش فرض</th>
                            <th>عملیات</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php if ($roles): ?>
                            <?php foreach ($roles as $key => $role): ?>
                                <tr>
                                    <td><?= $key+1 ?></td>
                                    <td><?= $role->title ?></td>
                                    <td>
                                        <?php if (in_array('permissions_edit', $user_permissions)) : ?>
                                            <a href="javascript:void(0)" title="اگر این نقش را به عنوان نقش پیش فرض انتخاب کنید، در صورتی که نقشی را حذف کنید آنگاه نقش آن کاربران به نقش پیش فرض تغییر می کند." class="has-tooltip"  onclick="insert('<?= base_url("/admin/permissions/defaultRole/$role->id") ?>', '', '<?= base_url("/admin/permissions/view") ?>', '#res', '#msg', false, true, 'noty', 'GET')">
                                                <i class="<?= ($role->default == 1) ? 'fa fa-check-circle fa-2x text-success' : 'fa fa-circle-o fa-2x' ?>"></i>
                                            </a>
                                        <?php else: ?>
                                            <span><i class="<?= ($role->default == 1) ? 'fa fa-check-circle fa-2x text-success' : 'fa fa-circle-o fa-2x' ?>"></i></span>
                                        <?php endif; ?>
                                    </td>
                                    <td>
                                        <?php if (in_array('permissions_edit', $user_permissions)): ?>
                                            <a class="btn btn-warning btn-round" href="<?= base_url('admin/permissions/edit/') . $role->id ?>">
                                                <i class="icon-pencil"></i>
                                                ویرایش
                                            </a>
                                        <?php endif; ?>
                                        <?php if (in_array('permissions_delete', $user_permissions) && $role->default == 0): ?>
                                            <a class="btn btn-danger btn-round" href="javascript: void(0)" onclick="deleteRow('<?= base_url("admin/permissions/delete/$role->id") ?>', '', '<?= base_url("admin/permissions/view") ?>', '#res', 'delete', 'GET')">
                                                <i class="icon-trash"></i>
                                                حذف
                                            </a>
                                        <?php endif ?>
                                    </td>
                                </tr>
                            <?php endforeach ?>
                        <?php endif ?>
                    </tbody>
                </table>
            </div><!-- /.table-responsive -->

        </div><!-- /.portlet-body -->
    </div><!-- /.portlet -->
</div><!-- /.col-md-12 -->

<script>
    $(document).ready(function() {
        var tableMain = $('#data-table').DataTable({
            "columnDefs": [
                {
                    "targets": 0,
                    "class": "width-10",
                },
                {
                    "targets": 2,
                    "orderable": false
                },
                {
                    "targets": 3,
                    "orderable": false
                }
            ],
            "pageLength": 25,
            "order": []
        });

        $(window).on('resize', function() {
            $('#data-table').css("width", "100%");
        });
    });
</script>
