<?php

/**
 * @author Rayanik.com
 */
if (!defined('BASEPATH'))
    exit('No direct script access allowed');

$slider->id = intval($slider->id);
?>
<div class="col-md-12">
    <div class="portlet box border shadow">
        <div class="portlet-heading">
            <div class="portlet-title">
                <h3 class="title">
                    <i class="<?= $slider->id == 0 ? 'icon-plus' : 'icon-note' ?>"></i>
                    <?= $slider->id == 0 ? 'اسلایدر جدید' : 'ویرایش اسلایدر' ?>
                </h3>
            </div><!-- /.portlet-title -->
            <div class="buttons-box">
                <a class="btn btn-sm btn-default btn-round btn-collapse" rel="tooltip" title="کوچک کردن" href="#">
                    <i class="icon-arrow-up"></i>
                </a>
            </div><!-- /.buttons-box -->
        </div><!-- /.portlet-heading -->
        <div class="portlet-body">
            <div class="row">
                <div class="col-md-12 p-b-30">
                    <form id="form-data" role="form" method="POST">
                        <input type="hidden" name="<?php echo $this->security->get_csrf_token_name(); ?>" value="<?php echo $this->security->get_csrf_hash(); ?>">
                        <input type="hidden" name="id" value="<?= $slider->id ?>">
                        <div class="form-body">
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label>صفحات ثابت</label>
                                        <select class="form-control select2" name="statics[]" multiple data-placeholder=" صفحات ثابت">
                                            <option value=""></option>
                                            <?php if($statics): ?>
                                                <?php foreach ($statics as $item): ?>
                                                    <option value="<?= $item->key ?>" <?php if(in_array($item->key, $slider_items->statics)) echo 'selected'; ?>><?= $item->title ?></option>
                                                <?php endforeach ?>
                                            <?php endif ?>
                                        </select>
                                    </div>
                                    
                                    <div class="form-group hide">
                                        <label>دسته‌ها</label>
                                        <select class="form-control select2" name="category_ids[]" multiple data-placeholder=" شهرها">
                                            <option value=""></option>
                                            <?php if($categories): ?>
                                                <?php foreach ($categories as $category): ?>
                                                    <option value="<?= $category->id ?>" <?php if(in_array($category->id, $slider_items->category_ids)) echo 'selected'; ?>><?= $category->title ?></option>
                                                <?php endforeach ?>
                                            <?php endif ?>
                                        </select>
                                    </div>

                                    <div class="form-group">
                                        <label>صفحات</label>
                                        <select class="form-control select2" name="page_ids[]" multiple data-placeholder=" صفحات">
                                            <option value=""></option>
                                            <?php if($pages): ?>
                                                <?php foreach ($pages as $page): ?>
                                                    <option value="<?= $page->id ?>" <?php if(in_array($page->id, $slider_items->page_ids)) echo 'selected'; ?>><?= $page->title ?></option>
                                                <?php endforeach ?>
                                            <?php endif ?>
                                        </select>
                                    </div>

                                    <div class="form-group">
                                        <label>عنوان</label>
                                        <input type="text" class="form-control" name="title" value="<?= $slider->title ?>">
                                    </div>
                                    <div class="form-group hide">
                                        <label>عنوان دومی</label>
                                        <input type="text" class="form-control" name="second_title" value="<?= $slider->second_title ?>">
                                    </div>
                                    <div class="form-group hide">
                                        <label>عنوان دکمه</label>
                                        <input type="text" class="form-control" name="btn_title" value="<?= $slider->btn_title ?>">
                                    </div>
                                    <div class="form-group">
                                        <label>لینک</label>
                                        <input type="text" class="form-control ltr" name="link" value="<?= $slider->link ?>">
                                    </div>
                                    <div class="form-group">
                                        <label>ترتیب نمایش</label>
                                        <input type="number" name="ordering" value="<?= $slider->ordering ?>" class="form-control numeric">
                                    </div>
                                    <div class="form-group">
                                        <label>وضعیت انتشار</label>
                                        <select class="form-control" name="publish">
                                            <option value="1" <?php if ($slider->publish == '1') echo 'selected'; ?>>انتشار</option>
                                            <option value="0" <?php if ($slider->publish == '0') echo 'selected'; ?>>عدم انتشار</option>
                                        </select>
                                    </div>
                                </div><!-- /.col -->
                                <div class="col-md-6">
                                    <div class="form-group box-image">
                                        <label>تصویر <span>(ترجیحا 1300x440 پیکسل)</span></label>
                                        <?php
                                        $class_hide = '';
                                        if ($slider->image != '' && file_exists($slider->image)) {
                                            $image = base_url() . $slider->image;
                                            $class_hide = 'hide';
                                        ?>
                                            <div class="box-old-image">
                                                <a href="javascript:void(0);" class="btn-danger remove-image" data-url="<?= base_url("admin/sliders/removeImage/$slider->id"); ?>" data-toggle="tooltip" title="حذف تصویر"><i class="icon-trash"></i></a>
                                                <img class="img-responsive img-thumbnail" src="<?= $image ?>">
                                            </div>
                                        <?php
                                        }
                                        ?>
                                        <div class="box-new-image <?= $class_hide ?>">
                                            <input type="file" class="form-control ltr" name="image">
                                        </div>
                                    </div>

                                    <div class="form-group box-image">
                                        <label>تصویر در موبایل <span>(ترجیحا 767x500 پیکسل)</span></label>
                                        <?php
                                        $class_hide = '';
                                        if ($slider->image_xs != '' && file_exists($slider->image_xs)) {
                                            $image = base_url() . $slider->image_xs;
                                            $class_hide = 'hide';
                                        ?>
                                            <div class="box-old-image">
                                                <a href="javascript:void(0);" class="btn-danger remove-image" data-url="<?= base_url("admin/sliders/removeImage/$slider->id/xs"); ?>" data-toggle="tooltip" title="حذف تصویر"><i class="icon-trash"></i></a>
                                                <img class="img-responsive img-thumbnail" src="<?= $image ?>">
                                            </div>
                                        <?php
                                        }
                                        ?>
                                        <div class="box-new-image <?= $class_hide ?>">
                                            <input type="file" class="form-control ltr" name="image_xs">
                                        </div>
                                    </div>
                                </div><!-- /.col -->
                            </div><!-- /.row -->

                        </div><!-- /.form-body -->
                        <div class="form-actions">
                            <a href="javascript: void(0)" class="btn btn-info btn-round" onclick="insert('<?php echo base_url('admin/sliders/save'); ?>', '#form-data', '', '', '#msg', false, true, 'sweetalert')">
                                <i class="icon-check"></i>
                                ذخیره
                            </a>
                            <a href="<?= base_url('admin/sliders') ?>" class="btn btn-warning btn-round pull-left">
                                <i class="icon-close"></i>
                                بازگشت
                            </a>
                        </div><!-- /.form-actions -->

                    </form>
                </div><!-- /.col -->
            </div><!-- /.row -->
        </div><!-- /.portlet-body -->
    </div><!-- /.portlet -->
</div><!-- /.col-md-12 -->
<script>
    $(document).ready(function(){
        $(".select2").select2({rtl: true});
    });
</script>