<?php
/**
 * @author Rayanik.com
 */
if (!defined('BASEPATH'))
    exit('No direct script access allowed');
?>
<div class="col-md-12">
    <div class="portlet box border shadow">
        <div class="portlet-heading">
            <div class="portlet-title">
                <h3 class="title">
                    <i class="icon-picture"></i>
                    اسلایدر ها
                </h3>
            </div><!-- /.portlet-title -->
            <div class="buttons-box">
                <a class="btn btn-sm btn-default btn-round btn-collapse" rel="tooltip" title="کوچک کردن" href="#">
                    <i class="icon-arrow-up"></i>
                </a>
            </div><!-- /.buttons-box -->
        </div><!-- /.portlet-heading -->
        <div class="portlet-body">
            <div class="row">
                <div class="col-md-12">
                    <?php if (in_array('sliders_add', $user_permissions)) : ?>
                        <a href="<?= base_url('admin/sliders/edit') ?>"  class="btn btn-primary has-tooltip btn-round btn-icon" title="جدید">
                            <i class="icon-plus"></i>
                        </a>
                    <?php endif; ?>
                    <?php if (in_array('sliders_edit', $user_permissions)) : ?>
                        <a href="javascript:void(0);"  onclick="insert('<?= base_url('admin/sliders/publish'); ?>', '#frm-main', '<?= base_url('admin/sliders/view'); ?>', '#res', '#msg', false, true, 'noty')" class="btn btn-success has-tooltip btn-round btn-icon" title="انتشار">
                            <i class="icon-eye"></i>
                        </a>
                        <a href="javascript:void(0);"  onclick="insert('<?= base_url('admin/sliders/un_publish'); ?>', '#frm-main', '<?= base_url('admin/sliders/view'); ?>', '#res', '#msg', false, true, 'noty')" class="btn btn-danger has-tooltip btn-round btn-icon" title="عدم انتشار">
                            <i class="icon-eye"></i>
                        </a>
                    <?php endif; ?>
                    <?php if (in_array('sliders_delete', $user_permissions)) : ?>
                        <a href="javascript:void(0);"  onclick="deleteRow('<?= base_url('admin/sliders/delete'); ?>', '#frm-main', '<?= base_url('admin/sliders/view'); ?>', '#res', 'delete', 'post')" class="btn btn-danger has-tooltip btn-round btn-icon" title="حذف">
                            <i class="icon-trash"></i>
                        </a>
                    <?php endif; ?>
                </div><!-- /.col -->

                <div class="clearfix"></div>

                <div class="col-md-12">
                    <div>
                        <div id="lbl-ids"></div>
                        <form method="post" id="frm-main">
                            <input type="hidden" name="<?php echo $this->security->get_csrf_token_name(); ?>" value="<?php echo $this->security->get_csrf_hash(); ?>">
                            <input type="hidden" id="txt-ids" name="list_ids"/>
                        </form>
                    </div>
                    <br>
                    <div class="table-responsive">
                        <table class="table table-bordered table-hover table-striped" id="data-table">
                            <thead>
                                <tr>
                                    <th><input type="checkbox" class="check-all"></th>
                                    <th>#</th>
                                    <th class="hidden">کد</th>
                                    <th>تصویر</th>
                                    <th>عنوان</th>
                                    <th>ترتیب نمایش</th>
                                    <th style="width:130px">عملیات</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php if ($sliders): ?>
                                    <?php foreach ($sliders as $key => $slider): ?>
                                        <tr>
                                            <td><input type="checkbox" value="<?= $slider->id ?>"></td>
                                            <td><?= $key + 1 ?></td>
                                            <td class="hidden"><?= $slider->id ?></td>
                                            <td>
                                                <?php if($slider->image && file_exists($slider->image)): ?>
                                                    <img src="<?= base_url($slider->image) ?>" width="100" class="thumbnail img-responsive">
                                                <?php endif ?>
                                            </td>
                                            <td><?= $slider->title ?></td>
                                            <td>
                                                <?php if (in_array('sliders_edit', $user_permissions)) : ?>
                                                    <input type="number" value="<?= $slider->ordering ?>"  class="form-control has-tooltip numeric" data-min="1" onblur="insert('<?= base_url('admin/sliders/ordering/') . $slider->id ?>/' + this.value, '#frm-main', '<?= base_url('admin/sliders/view') ?>', '#res', '#msg', false, true, 'noty');" title="برای تغییر ترتیب نمایش بعد از اینکه آن را تغییر دادید ، خارج از جعبه متن کلیک کنید" >
                                                <?php else: ?>
                                                    <span><?= $slider->ordering ?></span>
                                                <?php endif; ?>
                                            </td>
                                            <td>
                                                <?php if (in_array('sliders_edit', $user_permissions)) : ?>
                                                    <a class="btn btn-warning  btn-round btn-icon has-tooltip" title="ویرایش" href="<?= base_url('admin/sliders/edit/' . $slider->id) ?>" ><i class="icon-pencil"></i></a>
                                                    <?php if ($slider->publish == 0): ?>
                                                        <a class="btn btn-danger btn-round btn-icon has-tooltip" title="عدم انتشار" href="javascript: void(0)" onclick="insert('<?= base_url('admin/sliders/publish/' . $slider->id) ?>', '#frm-main', '<?= base_url('admin/sliders/view') ?>', '#res', '#msg', false, true, 'noty')" ><i class="icon-eye"></i></a>
                                                    <?php else: ?>
                                                        <a class="btn btn-success btn-round btn-icon has-tooltip" title="انتشار" href="javascript: void(0)" onclick="insert('<?= base_url('admin/sliders/un_publish/') . $slider->id; ?>', '#frm-main', '<?= base_url('admin/sliders/view'); ?>', '#res', '#msg', false, true, 'noty')"><i class="icon-eye"></i></a>
                                                    <?php endif; ?>
                                                <?php endif; ?>
                                                <?php if (in_array('sliders_delete', $user_permissions)) : ?>
                                                    <a class="btn btn-danger btn-round btn-icon has-tooltip" title="حذف" href="javascript: void(0)" onclick="deleteRow('<?= base_url('admin/sliders/delete/') . $slider->id; ?>', '#frm-main', '<?= base_url('admin/sliders/view'); ?>', '#res', 'delete', 'get');"><i class="icon-trash"></i></a>
                                                <?php endif; ?>
                                            </td>
                                        </tr>
                                    <?php endforeach ?>
                                <?php endif?>
                            </tbody>
                        </table>
                    </div><!-- /.table-responsive -->
                </div><!-- /.col -->
            </div><!-- /.row -->
        </div><!-- /.portlet-body -->
    </div><!-- /.portlet -->
</div><!-- /.col-md-12 -->

<!--  Tooltip -->
<script>
    $(document).ready(function () {
        var selectedMain = [];
        var tableMain = $('#data-table').DataTable({
            "pageLength": 50,
            "rowCallback": function (row, data) {
                //window.Modiran.initiCkeck();
            },
            "drawCallback": function( settings ) {
                chackAllStatus($('#data-table'));
            },
            "sPaginationType": "full_numbers",
            "columns": [
                {"data": "checkbox", "orderable": false, "class": "width-10 p-10"},
                {"data": "row", "orderable": false, "class": "width-10"},
                {"data": "DT_RowId"},
                {"data": "title"},
                {"data": "image"},
                {"data": "ordering"},
                {"data": "actions", "orderable": false}
            ], 
            "order": []
        });



        // Select checkboxes
        $("#data-table tbody").on("ifChanged", "input", function (event) {
            var id = event.target.value;
            //var isChecked = event.target.checked;
            var index = $.inArray(id, selectedMain);
            if (index === -1) {
                selectedMain.push(id);
                $(this).closest("tr").addClass("selected");
            } else {
                selectedMain.splice(index, 1);
                $(this).closest("tr").removeClass("selected");
            }

            if (selectedMain.length == 0) {
                $("#lbl-ids").html("");
            } else {
                $("#lbl-ids").html(selectedMain.length + "مورد انتخاب شده است.");
            }

            $("#txt-ids").val(selectedMain);

            chackAllStatus($('#data-table'));
        });

        $(window).on('resize', function () {
            $('#data-table').css("width", "100%");
        });
    });
</script>
