<?php
/**
 * @author Rayanik.com
 */
if (!defined('BASEPATH'))
    exit('No direct script access allowed');
?>

<style>
    #data-table{
        width: 100% !important;
    }
</style>
<div class="col-md-12">
    <div class="portlet box border shadow">
        <div class="portlet-heading">
            <div class="portlet-title">
                <h3 class="title">
                    <i class="icon-wallet"></i>
                    تراکنش ها
                </h3>
            </div><!-- /.portlet-title -->
            <div class="buttons-box">
                <a class="btn btn-sm btn-default btn-round btn-collapse" rel="tooltip" title="کوچک کردن" href="#">
                    <i class="icon-arrow-up"></i>
                </a>
            </div><!-- /.buttons-box -->
        </div><!-- /.portlet-heading -->
        <div class="portlet-body">
            <div class="m-t-10">
                <div id="lbl-ids"></div>
                <div class="m-b-10">
                    <span class="bold">راهنمای رنگ</span>
                    <label>:</label>
                    <label class="label label-success">موفق</label>
                    <label class="label label-warning">منتظر تایید</label>
                    <label class="label label-danger">ناموفق/ رد شده</label>
                    <label class="label label-default">خرید / برداشت</label>
                </div>
                <form id="form-data" role="form" method="POST" >
                    <input type="hidden" name="<?php echo $this->security->get_csrf_token_name(); ?>" value="<?php echo $this->security->get_csrf_hash(); ?>">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label>از تاریخ</label>
                                        <input type="text"  class="form-control ltr" id="from-date" name="from_date">
                                    </div>
                                </div><!-- /.col -->
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label>تا تاریخ</label>
                                        <input type="text"  class="form-control ltr" id="to-date" name="to_date">
                                    </div>
                                </div><!-- /.col -->
                            </div><!-- /.row -->
                        </div><!-- /.col -->
                    </div><!-- /.row -->
                </form>
            </div>
            <div class="table-responsive">
                <table class="table table-bordered table-hover table-striped" id="data-table">
                    <tfoot class="top-search">
                        <tr>
                            <th></th>
                            <th class="searchable" data-width="100"></th>
                            <th class="searchable" data-width="100"></th>
                            <th class="searchable" data-width="100"></th>
                            <th class="searchable" data-width="100"></th>
                            <th class="select-type"></th>
                            <th class="select-gateway"></th>
                            <th></th>
                            <th></th>
                        </tr>
                    </tfoot>
                    <thead>
                        <tr>
                            <th>#</th>
                            <th>ش. سفارش</th>
                            <th>ش. همراه</th>
                            <th>مبلغ</th>
                            <th>ش. تراکنش</th>
                            <th>نوع</th>
                            <th>درگاه</th>
                            <th>تاریخ</th>
                            <th>عملیات</th>
                        </tr>
                    </thead>
                    <tbody>
                    </tbody>
                </table>
            </div><!-- /.table-responsive -->

        </div><!-- /.portlet-body -->
    </div><!-- /.portlet -->
</div><!-- /.col-md-12 -->

<script>
    $(document).ready(function() {


        var selectedMain = [];
        var tableMain = $('#data-table').DataTable({
            "processing": true, //Feature control the processing indicator.
            "serverSide": true, //Feature control DataTables' server-side processing mode.
            "pageLength": 50,
           "columns": [
                {"data": "row",           "class": "ltr text-center with-10", "orderable": false},
                {"data": "tracking_code", "class": "ltr text-center"},
                {"data": "cell_phone",    "class": "ltr text-center"},
                {"data": "amount",        "class": "ltr text-center"},
                {"data": "reference",     "class": "ltr text-center maybe-long"},
                {"data": "type",          "class": "ltr text-center"},
                {"data": "gateway",       "class": "ltr text-center"},
                {"data": "created",       "class": "ltr text-center"},
                {"data": "actions",       "class": "ltr text-center", "orderable": false}
            ],
            "ajax": {
                "url": "<?php echo base_url('admin/transactions/ajax_list') ?>",
                "type": "POST",
                data: function(d) {
                    d.<?= $this->security->get_csrf_token_name() ?> = $("input[name='" + csrfTokenName + "']").val();
                    d.from_date = $("input[name='from_date']").val();
                    d.to_date = $("input[name='to_date']").val();
                },
                dataSrc: function(json) {
                    if (json.csrf !== undefined)
                        $("input[name='" + csrfTokenName + "']").val(json.csrf);
                    return json.data;
                }
            },
            "sPaginationType": "full_numbers",
            "order": [], //Initial no order.
            "fnDrawCallback": function() {
                $(".has-tooltip, table .btn").tooltip();
            }
        });


        // Resize
        $(window).on('resize', function() {
            $('#data-table').css("width", "100%");
        });


        // Add Search input, select
        $('#data-table tfoot th.searchable').each(function() {
            var title = $("#data-table thead th").eq($(this).index()).text();
            $(this).html('<input type="text" placeholder="' + title + '"  style="width:' +$(this).attr('data-width')+ 'px;">');
        });
        $('#data-table tfoot th.select-type').each(function() {
            var html = '<select class="rtl">';
            html += '<option value="">همه</option>';
            <?php foreach (getTransactionTypes() as $item) : ?>
                html += '<option value="<?=$item->type?>"><?=$item->title?></option>';
            <?php endforeach; ?>
            html += '</seclect>';
            $(this).html(html);
        });
        $('#data-table tfoot th.select-gateway').each(function() {
            var html = '<select class="rtl">';
            html += '<option value="">همه</option>';
            <?php if($gatewayes): ?>
                <?php foreach ($gatewayes as $item) : ?>
                    html += '<option value="<?=$item->title_en?>"><?=$item->title_fa?></option>';
                <?php endforeach; ?>
            <?php endif; ?>
            html += '</seclect>';
            $(this).html(html);
        });

        // Apply the search
        tableMain.columns().eq(0).each(function(colIdx) {
            $(':input', tableMain.column(colIdx).footer()).on('keyup change', function() {
                tableMain
                    .column(colIdx)
                    .search(this.value)
                    .draw();
            });
        });

        $('#form-data :input').on('change keyup',function(){
            tableMain.draw();
        });

        // datepicker config
        var datepicker = $("#from-date, #to-date").pDatepicker({
            initialValue: false,
            persianDigit: false,
            format: "YYYY/MM/DD",
            observer: true,
            autoClose: true,
            toolbox: {
                calendarSwitch: {
                    enabled: false
                },
            },
            calendar:{
                persian: {
                    leapYearMode: 'astronomical'
                }
            },
            onSelect: function(unix){
                tableMain.draw();
            }
        });
    });
</script>
