<?php
/**
 * @author Rayanik.com
 */
if (!defined('BASEPATH'))
    exit('No direct script access allowed');

$category->id = intval($category->id);
?>
<form id="form-data" role="form" method="POST" >
    <input type="hidden" name="<?php echo $this->security->get_csrf_token_name(); ?>" value="<?php echo $this->security->get_csrf_hash(); ?>">
    <input type="hidden" value="<?= $category->id ?>" name="id"/>
    <div class="col-md-12">
        <div class="portlet box border shadow">
            <div class="portlet-heading">
                <div class="portlet-title">
                    <h3 class="title">
                        <i class="<?= $category->id == 0 ? 'icon-plus' : 'icon-note' ?>"></i>
                        <?= $category->id == 0 ? 'دسته جدید' : 'ویرایش دسته' ?>
                    </h3>
                </div><!-- /.portlet-title -->
                <div class="buttons-box">
                    <a class="btn btn-sm btn-default btn-round btn-collapse" rel="tooltip" title="کوچک کردن" href="#">
                        <i class="icon-arrow-up"></i>
                    </a>
                </div><!-- /.buttons-box -->
            </div><!-- /.portlet-heading -->
            <div class="portlet-body">
                <div class="row">
                    <div class="form-body">
                        <div class="col-md-6">
                            <div class="form-group box-image">
                                <label>عکس کوچک <span>(80x80)</span> پیکسل <a class="btn btn-warning btn-icon btn-round btn-sm" data-toggle="modal" data-target="#modal-education-ui"><i class="fa fa-question"></i></a></label>
                                <?php
                                $class_hide = '';
                                if ($category->image != '' && file_exists($category->image)) {
                                    $image = base_url() . $category->image;
                                    $class_hide = 'hide';
                                    ?>
                                    <div class="box-old-image">
                                        <a href="javascript:void(0);" class="btn-danger remove-image" data-url="<?= base_url("admin/tree_categories/removeImage/product/$category->id/"); ?>" data-toggle="tooltip" title="حذف تصویر"><i class="icon-trash"></i></a>
                                        <img class="img-responsive img-thumbnail" src="<?= $image ?>">
                                    </div>
                                    <?php
                                }
                                ?>
                                <div class="box-new-image <?= $class_hide ?>">
                                    <input type="file" class="form-control ltr" name="image">
                                </div>
                            </div><!-- /.form-group -->
                        </div><!-- /.col -->
                        <div class="col-md-6">
                            <div class="form-group box-image">
                                <label>عکس بزرگ <span>(480x360)</span> پیکسل <a class="btn btn-warning btn-icon btn-round btn-sm" data-toggle="modal" data-target="#modal-education-ui"><i class="fa fa-question"></i></a></label>
                                <?php
                                $class_hide = '';
                                if ($category->large_image != '' && file_exists($category->large_image)) {
                                    $image = base_url() . $category->large_image;
                                    $class_hide = 'hide';
                                    ?>
                                    <div class="box-old-image">
                                        <a href="javascript:void(0);" class="btn-danger remove-image" data-url="<?= base_url("admin/tree_categories/removeLargeImage/product/$category->id/"); ?>" data-toggle="tooltip" title="حذف تصویر"><i class="icon-trash"></i></a>
                                        <img class="img-responsive img-thumbnail" src="<?= $image ?>" width="150">
                                    </div>
                                    <?php
                                }
                                ?>
                                <div class="box-new-image <?= $class_hide ?>">
                                    <input type="file" class="form-control ltr" name="large_image">
                                </div>
                            </div><!-- /.form-group -->
                        </div><!-- /.col -->
                        <div class="col-md-12 m-b-10">
                            <div class="row">
                                <div class="col-md-8">
                                    <div class="form-group">
                                        <label>Slug (فاصله ها با - جایگزین خواهند شد)</label>
                                        <input type="text" class="form-control" name="slug" value="<?= $category->slug ?>" placeholder="">
                                    </div><!-- ./form-group -->
                                    <div class="input-group curve">
                                        <input type="text" id="txt-link" class="form-control ltr" value="<?= ($category->slug) ? base_url("category/$category->slug") : '' ?>" readonly>
                                        <span class="input-group-btn">
                                            <button id="btn-copy-link" class="btn btn-primary" type="button" ><i class="icon-docs"></i> کپی لینک دسته</button>
                                        </span>
                                    </div><!-- ./input-group -->
                                </div><!-- ./col -->
                            </div><!-- ./row -->
                        </div><!-- ./col -->
                        <div class="clearfix"></div>

                        <div class="col-md-4">
                            <div class="form-group">
                                <label>عنوان فارسی<span class="text-danger">*</span></label>
                                <input type="text" class="form-control" name="title_fa" value="<?= $category->title_fa ?>" placeholder="عنوان فارسی">
                            </div>
                        </div><!-- /.col -->
                        <div class="col-md-4">
                            <div class="form-group">
                                <label>عنوان انگلیسی</label>
                                <input type="text" class="form-control ltr text-left" name="title_en" value="<?= $category->title_en ?>" placeholder="عنوان انگلیسی">
                            </div>
                        </div><!-- /.col -->
                        <div class="col-md-4">
                            <div class="form-group">
                                <label>ترتیب نمایش<span class="text-danger">*</span></label>
                                <input type="number" class="form-control numeric" name="ordering" value="<?= $category->ordering ?>">
                            </div><!-- /.form-group -->
                        </div><!-- /.col -->

                        <div class="col-md-4">
                            <div class="form-group">
                                <label>عنوان رمز اول<span class="text-danger">*</span></label>
                                <input type="text" class="form-control" name="field1_title" value="<?= $category->field1_title ?>" placeholder="عنوان رمز اول مثلا رمز کارت">
                            </div>
                        </div><!-- /.col -->
                        <div class="col-md-4">
                            <div class="form-group">
                                <label>عنوان رمز دوم</label>
                                <input type="text" class="form-control" name="field2_title" value="<?= $category->field2_title ?>" placeholder="عنوان رمز دوم مثلا سریال">
                            </div>
                        </div><!-- /.col -->
                        <div class="col-md-4">
                            <div class="form-group">
                                <label>عنوان رمز سوم</label>
                                <input type="text" class="form-control" name="field3_title" value="<?= $category->field3_title ?>" placeholder="عنوان رمز سوم مثلا رمز نهایی">
                            </div>
                        </div><!-- /.col -->
                    </div><!-- /.form-body -->
                </div><!-- /.row -->
            </div><!-- /.portlet-body -->
        </div><!-- /.portlet -->
        <div class="portlet box border shadow">
            <div class="portlet-heading">
                <div class="portlet-title">
                    <h3 class="title">
                        فیلد‌های زمان ثبت سفارش
                    </h3>
                </div><!-- /.portlet-title -->
                <div class="buttons-box">
                    <a class="btn btn-sm btn-default btn-round btn-collapse" rel="tooltip" title="کوچک کردن" href="#">
                        <i class="icon-arrow-up"></i>
                    </a>
                </div><!-- /.buttons-box -->
            </div><!-- /.portlet-heading -->
            <div class="portlet-body">
                <div class="row">
                    <div class="form-body">
                        <div class="col-md-12">
                            <div class="table-responsive">
                                <table class="table table-bordered table-hover table-striped" id="table-fields">
                                    <thead>
                                        <tr>
                                            <th>عنوان</th>
                                            <th>این فیلد باشد؟</th>
                                            <th>اجباری باشد؟</th>
                                            <th>چپ‌چین باشد؟</th>
                                            <th style="width:100px">ترتیب</th>
                                            <th>حذف</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php foreach ($category->fields as $key => $item): ?>
                                            <tr>
                                                <td>
                                                    <input  name="fields[][statics_key]" class="txt-statics-key hide" value="<?= $item->statics_key ?>">
                                                    <?php if($item->statics_key): ?>
                                                        <span><?= $item->title ?></span>
                                                    <?php else: ?>
                                                        <input  name="fields[][title]" class="txt-title form-control" value="<?= $item->title ?>" placeholder="عنوان">
                                                    <?php endif; ?>
                                                </td>
                                                <td><input type="checkbox" name="fields[][use]" class="chk-use" value="1" <?php if($item->use) echo 'checked'?>></td>
                                                <td><input type="checkbox" name="fields[][required]" class="chk-required" value="1" <?php if($item->required) echo 'checked'?>></td>
                                                <td><input type="checkbox" name="fields[][ltr]" class="chk-ltr"  value="1" <?php if($item->ltr) echo 'checked'?> <?php if($item->statics_key) echo 'disabled'?>></td>
                                                <td><input type="number"   name="fields[][ordering]" class="txt-ordering form-control" min="1" value="<?= $item->ordering ?>"></td>
                                                <td>
                                                    <?php if(!$item->statics_key): ?>
                                                        <a href="javascript:void(0)" class="btn btn-danger btn-round btn-icon btn-remove"><i class="icon-close"></i></a>
                                                    <?php endif ?>
                                                </td>
                                            </tr>
                                        <?php endforeach; ?>
                                    </tbody>
                                </table>
                            </div>
                            <a href="javascript:void(0)" class="btn btn-success btn-round" id="btn-add-field"> <i class="icon-plus"></i> افزودن فیلد جدید</a>
                        </div><!-- /.col -->
                    </div><!-- /.form-body -->
                </div><!-- /.row -->
            </div><!-- /.portlet-body -->
        </div><!-- /.portlet -->
        <div class="portlet box border shadow">
            <div class="portlet-heading">
                <div class="portlet-title">
                    <h3 class="title">
                        توضیحات و متا
                    </h3>
                </div><!-- /.portlet-title -->
                <div class="buttons-box">
                    <a class="btn btn-sm btn-default btn-round btn-collapse" rel="tooltip" title="کوچک کردن" href="#">
                        <i class="icon-arrow-up"></i>
                    </a>
                </div><!-- /.buttons-box -->
            </div><!-- /.portlet-heading -->
            <div class="portlet-body">
                <div class="row">
                    <div class="form-body">
                        <div class="col-md-12">
                            <div class="form-group">
                                <label>توضیحات</label>
                                <textarea name="description" class="hide" id="content1"><?= $category->description ?></textarea>
                                <div id="editor1"></div>
                            </div><!-- /.form-group -->
                            <div class="form-group">
                                <label for="meta_title">متای عنوان(عنوان  مختصر و مفید تا حدود 65 حرف)</label>
                                <input id="meta_title" name="meta_title" class="form-control" value="<?= $category->meta_title ?>">
                            </div><!-- /.form-group -->
                            <div class="form-group">
                                <label for="meta_description">متای توضیحات(حدود 155 حرف)</label>
                                <textarea id="meta_description" name="meta_description" rows="4" class="form-control"><?= $category->meta_description ?></textarea>
                            </div><!-- /.form-group -->
                        </div><!-- /.col -->
                    </div><!-- /.form-body -->
                </div><!-- /.row -->
            </div><!-- /.portlet-body -->
        </div><!-- /.portlet -->
    </div><!-- /.col -->
    <div class="col-md-12">
        <div class="portlet box border shadow">
            <div class="form-actions">
                <a href="javascript: void(0)"  class="btn btn-info btn-round btn-save">
                    <i class="icon-check"></i>
                    ذخیره
                </a>
                <a href="<?= base_url("admin/tree_categories/index/$category->type") ?>" class="btn btn-warning btn-round pull-left">
                    <i class="icon-close"></i>
                    بازگشت
                </a>
            </div><!-- /.form-actions -->
        </div><!-- /.portlet -->
    </div><!-- /.col -->
</form>
<script>
    $(document).ready(function(){
        $("#btn-copy-link").on("click", function() {
            let textBox = document.getElementById("txt-link");
            textBox.select();
            document.execCommand("copy");
            generateType('success', 'با موفقیت کپی شد', 'bottomLeft');
        });

        $("input[name='slug']").on("keyup", function(e) {
            let slug = $(this).val();
            slug = slug.trim();
            slug = slug.replace(/\s+/g, '-');
            slug = slug.replace(/[،,;()*.'"]/g, "");

            if(slug == ''){
                $("#txt-link").val('');
            } else {
                slug = encodeURIComponent(slug);
                $("#txt-link").val(baseUrl + 'category/' + slug);
            }
        });

        var editor1;
        var config = {};

        //to enable uplaod image plugin
        config.extraPlugins = 'simage';
        config.imageUploadURL = baseUrl + 'admin/media/upload_ckeditor/';
        config.dataParser = function(data) {
            return data.url;
        };
        
        config.ContentLangDirection = 'rtl';
        config.language = 'fa';
        config.font_names =
                "Tahoma;" +
                "Nazanin/Nazanin, B Nazanin, BNazanin;" +
                "Yekan/Yekan, BYekan, B Yekan, Web Yekan;" +
                "IranSans/IranSans;" +
                "Parastoo/Parastoo;" +
                "Arial/Arial, Helvetica, sans-serif;" +
                "Times New Roman/Times New Roman, Times, serif;";

        editor1 = CKEDITOR.appendTo('editor1', config);
        editor1.setData($("#content1").val());

        $(document).on("click", ".btn-save", function () {
            // چک می کنیم که برای فیلد ها ترتیب را وارد کرده باشد و ترتیب هم تکراری نباشد
            let errorMessage = '';
            let orderingValues = [];
            $("#table-fields tbody tr").each(function(key, elem){
                let use = $(elem).find(".chk-use").parent('[class*="icheckbox"]').hasClass("checked");
                if(use){
                    let ordering = Number($(elem).find(".txt-ordering").val());
                    if(ordering == 0){
                        errorMessage = 'باید برای فیلد‌ها ترتیب نمایش وارد شود.';
                    } else if(orderingValues.includes(ordering)){
                        errorMessage = 'ترتیب نمایش فیلد‌ها نمی‌تواند تکراری باشد.';
                    }
                    orderingValues.push(ordering);
                }
            });

            if(errorMessage != ''){
                swal('خطا', errorMessage, 'error');
                return;
            }

            $("#content1").val(editor1.getData());

            // Rename field inputs
            $("#table-fields tbody tr").each(function(key, elem){
                $(elem).find(".txt-statics-key").attr("name", `fields[${key}][statics_key]`);
                $(elem).find(".txt-title").attr("name", `fields[${key}][title]`);
                $(elem).find(".chk-use").attr("name", `fields[${key}][use]`);
                $(elem).find(".chk-required").attr("name", `fields[${key}][required]`);
                $(elem).find(".chk-ltr").attr("name", `fields[${key}][ltr]`);
                $(elem).find(".txt-ordering").attr("name", `fields[${key}][ordering]`);
            });

            insert('<?php echo base_url("admin/tree_categories/saveEdit/$category->type"); ?>', '#form-data', '', '', '#msg', false, true, 'sweetalert');
        });

        // Fileds
        let originalFieldRow = $("#table-fields tbody tr:last").clone();
        $("#btn-add-field").on("click", function(){
            let oneRow = originalFieldRow.clone();
            $("#table-fields tbody").append(oneRow);
            window.Modiran.initiCkeck();
        });

        $("#table-fields").on("click", ".btn-remove", function(){
            $(this).closest("tr").remove();
        });
    }); 
</script>