<?php
/**
 * @author Rayanik.com
 */
if (!defined('BASEPATH'))
    exit('No direct script access allowed');

$user->id = intval($user->id);
?>

<div class="col-md-12">
    <div class="portlet box border shadow">
        <div class="portlet-heading">
            <div class="portlet-title">
                <h3 class="title">

                    <i class="<?= $user->id == 0 ? 'icon-plus' : 'icon-note' ?>"></i>
                    <?= $user->id == 0 ? 'مدیر جدید' : 'ویرایش مدیر' ?>
                </h3>
            </div><!-- /.portlet-title -->
            <div class="buttons-box">
                <a class="btn btn-sm btn-default btn-round btn-collapse" rel="tooltip" title="کوچک کردن" href="#">
                    <i class="icon-arrow-up"></i>
                </a>
            </div><!-- /.buttons-box -->
        </div><!-- /.portlet-heading -->
        <div class="portlet-body">
            <div class="row">
                <div class="col-md-12">
                    <form id="form-data" role="form" method="POST" enctype="multipart/form-data">
                        <input type="hidden" name="<?php echo $this->security->get_csrf_token_name(); ?>" value="<?php echo $this->security->get_csrf_hash(); ?>">
                        <input type="hidden" value="<?= $user->id ?>" name="id"/>
                        <div class="form-body">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>نام</label>
                                    <input type="text" class="form-control" name="first_name" value="<?= $user->first_name ?>" placeholder="نام">
                                </div>
                                <div class="form-group">
                                    <label>نام خانوادگی</label>
                                    <input type="text" class="form-control" name="last_name" value="<?= $user->last_name ?>" placeholder="نام خانوادگی">
                                </div>
                                <div class="form-group">
                                    <label>تلفن همراه (فرمت صحیح: 9123456789)</label>
                                    <input type="text" class="form-control ltr numeric" name="cell_phone" value="<?= $user->cell_phone ?>" placeholder="9123456789" maxlength="10">
                                </div>
                                <div class="form-group">
                                    <label>ایمیل</label>
                                    <input type="email" class="form-control ltr" name="email" value="<?= $user->email ?>" placeholder="ایمیل">
                                </div>
                                <div class="form-group">
                                    <label>نقش</label>
                                    <select class="form-control" name="role_id">
                                        <?php if ($roles) : ?>
                                            <option value="" disabled selected></option>
                                            <?php foreach ($roles as $role): ?>
                                                <option value="<?= $role->id ?>" <?php if ($user->role_id == $role->id) echo 'selected'; ?>><?= $role->title ?></option>
                                            <?php endforeach; ?>
                                        <?php endif; ?>
                                    </select>
                                </div>
                            </div><!-- /.col -->
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>نام کاربری</label>
                                    <input type="text" class="form-control ltr" name="username" value="<?= $user->username ?>" placeholder="نام کاربری" <?php if ($user->id > 0) echo "disabled"; ?>>
                                </div>
                                <?php
                                if ($user->id == 0) {
                                    ?>
                                    <div class="form-group">
                                        <label>رمز عبور</label>
                                        <input type="password" class="form-control ltr" name="password" value="">
                                    </div>
                                    <div class="form-group">
                                        <label>تکرار رمز عبور</label>
                                        <input type="password" class="form-control ltr" name="cf_password" value="">
                                    </div>
                                    <?php
                                }
                                ?>
                                <div class="form-group box-image">
                                    <label>تصویر <span>(128x128)</span> پیکسل</label>
                                    <?php
                                    $class_hide = '';
                                    if ($user->image != '' && file_exists($user->image)) {
                                        $image = base_url() . $user->image;
                                        $class_hide = 'hide';
                                        ?>
                                        <div class="box-old-image">
                                            <a href="javascript:void(0);" class="btn-danger remove-image" data-url="<?= base_url("admin/users/removeImage/$user->id");?>" data-toggle="tooltip" title="حذف تصویر"><i class="icon-trash"></i></a>
                                            <img class="img-responsive img-thumbnail" width="100" src="<?= $image ?>">
                                        </div>
                                        <?php
                                    }
                                    ?>
                                    <div class="box-new-image <?= $class_hide ?>">
                                        <input type="file" class="form-control ltr" name="image">
                                    </div>
                                </div>
                            </div><!-- /.col -->

                        </div><!-- /.form-body -->
                        <div class="col-md-12">
                            <div class="form-actions">
                                <a href="javascript: void(0)"  class="btn btn-info btn-round" onclick="insert('<?php echo base_url('admin/users/save'); ?>', '#form-data', '', '', '#msg', false, true, 'sweetalert')">
                                    <i class="icon-check"></i>
                                    ذخیره
                                </a>
                                <a href="<?= base_url('admin/users') ?>" class="btn btn-warning btn-round pull-left">
                                    <i class="icon-close"></i>
                                    بازگشت
                                </a>
                            </div><!-- /.form-actions -->
                        </div><!-- /.col -->
                    </form>
                </div><!-- /.col -->
            </div><!-- /.row -->
        </div><!-- /.portlet-body -->
    </div><!-- /.portlet -->
</div><!-- /.col-md-12 -->
