<?php
/**
 * @author Rayanik.com
 */
if (!defined('BASEPATH'))
    exit('No direct script access allowed');
?>

<div class="col-md-12">
    <div class="logo-con m-t-10 m-b-10">
        <img src="<?= base_url('assets/admin/images/logo.png') ?>" class="center-block img-responsive">
    </div><!-- /.logo-con -->
    <h2 class="text-center m-b-20">وارد شوید</h2>
    <hr>
    <?php
    if (isset($messages)) {
        ?>
        <div class="alert alert-danger">
            <button type="button" class="close" data-dismiss="alert">×</button>
            <?= $messages ?>
        </div>
        <?php
    }
    ?>
    <form id="form" class="m-t-30 m-b-30" action="<?= $form_action ?>" method="POST" role="form"> 
        <input type="hidden" name="<?php echo $this->security->get_csrf_token_name(); ?>" value="<?php echo $this->security->get_csrf_hash(); ?>">
        <div class="form-group">
            <label for="username" class="sr-only">نام کاربری</label>
            <div class="input-group round">
                <span class="input-group-addon">
                    <i class="icon-user"></i>
                </span>
                <input id="username" class="form-control ltr text-left"  name="username" required>
            </div><!-- /.input-group -->
        </div><!-- /.form-group -->
        <div class="form-group">
            <label for="password" class="sr-only">رمز عبور</label>
            <div class="input-group round">
                <span class="input-group-addon">
                    <i class="icon-key"></i>
                </span>
                <input id="password" class="form-control ltr text-left" type="password" name="password" minlength="5" required>
            </div><!-- /.input-group -->
        </div><!-- /.form-group -->
        
        <div class="form-group">
            <div class="text-center">
                <?= $captcha_image ?>
            </div>
        </div><!-- /.form-group -->

        <div class="form-group">
            <label for="captcha" class="sr-only">کد امنیتی</label>
            <div class="input-group round">
                <span class="input-group-addon">
                    <i class="icon-lock-open"></i>
                </span>
                <input id="captcha" class="form-control ltr text-left  iransans-en" name="captcha" autocomplete="off" required>
            </div><!-- /.input-group -->
        </div><!-- /.form-group -->
        



        <p>
            <button class="btn btn-info btn-round btn-block" name="submit" value="submit">
                <i class="icon-paper-plane font-lg"></i>
                ورود
            </button>
        </p>
    </form>
    <hr class="m-b-30">
    <a href="forget.html" class="btn btn-default btn-round btn-block m-b-10 hide">
        <i class="icon-refresh font-lg"></i> 
        بازیابی رمز  عبور
    </a>
    <a href="register.html" class="btn btn-default btn-round btn-block hide">
        <i class="icon-user-follow font-lg"></i>
        حساب ندارید، ثبت نام کنید!    
    </a>
</div><!-- /.col-md-12 -->